/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.DomainHealth;
import software.amazon.awssdk.services.opensearch.model.DomainState;
import software.amazon.awssdk.services.opensearch.model.EnvironmentInfo;
import software.amazon.awssdk.services.opensearch.model.EnvironmentInfoListCopier;
import software.amazon.awssdk.services.opensearch.model.MasterNodeStatus;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainHealthResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, DescribeDomainHealthResponse> {
    private static final SdkField<String> DOMAIN_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainState").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::domainStateAsString)).setter(DescribeDomainHealthResponse.setter(Builder::domainState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainState").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneCount").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::availabilityZoneCount)).setter(DescribeDomainHealthResponse.setter(Builder::availabilityZoneCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneCount").build()}).build();
    private static final SdkField<String> ACTIVE_AVAILABILITY_ZONE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveAvailabilityZoneCount").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::activeAvailabilityZoneCount)).setter(DescribeDomainHealthResponse.setter(Builder::activeAvailabilityZoneCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveAvailabilityZoneCount").build()}).build();
    private static final SdkField<String> STAND_BY_AVAILABILITY_ZONE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandByAvailabilityZoneCount").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::standByAvailabilityZoneCount)).setter(DescribeDomainHealthResponse.setter(Builder::standByAvailabilityZoneCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandByAvailabilityZoneCount").build()}).build();
    private static final SdkField<String> DATA_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataNodeCount").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::dataNodeCount)).setter(DescribeDomainHealthResponse.setter(Builder::dataNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataNodeCount").build()}).build();
    private static final SdkField<Boolean> DEDICATED_MASTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DedicatedMaster").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::dedicatedMaster)).setter(DescribeDomainHealthResponse.setter(Builder::dedicatedMaster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMaster").build()}).build();
    private static final SdkField<String> MASTER_ELIGIBLE_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterEligibleNodeCount").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::masterEligibleNodeCount)).setter(DescribeDomainHealthResponse.setter(Builder::masterEligibleNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterEligibleNodeCount").build()}).build();
    private static final SdkField<String> WARM_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WarmNodeCount").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::warmNodeCount)).setter(DescribeDomainHealthResponse.setter(Builder::warmNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmNodeCount").build()}).build();
    private static final SdkField<String> MASTER_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterNode").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::masterNodeAsString)).setter(DescribeDomainHealthResponse.setter(Builder::masterNode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterNode").build()}).build();
    private static final SdkField<String> CLUSTER_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterHealth").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::clusterHealthAsString)).setter(DescribeDomainHealthResponse.setter(Builder::clusterHealth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterHealth").build()}).build();
    private static final SdkField<String> TOTAL_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalShards").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::totalShards)).setter(DescribeDomainHealthResponse.setter(Builder::totalShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalShards").build()}).build();
    private static final SdkField<String> TOTAL_UN_ASSIGNED_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalUnAssignedShards").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::totalUnAssignedShards)).setter(DescribeDomainHealthResponse.setter(Builder::totalUnAssignedShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalUnAssignedShards").build()}).build();
    private static final SdkField<List<EnvironmentInfo>> ENVIRONMENT_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentInformation").getter(DescribeDomainHealthResponse.getter(DescribeDomainHealthResponse::environmentInformation)).setter(DescribeDomainHealthResponse.setter(Builder::environmentInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentInformation").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_STATE_FIELD, AVAILABILITY_ZONE_COUNT_FIELD, ACTIVE_AVAILABILITY_ZONE_COUNT_FIELD, STAND_BY_AVAILABILITY_ZONE_COUNT_FIELD, DATA_NODE_COUNT_FIELD, DEDICATED_MASTER_FIELD, MASTER_ELIGIBLE_NODE_COUNT_FIELD, WARM_NODE_COUNT_FIELD, MASTER_NODE_FIELD, CLUSTER_HEALTH_FIELD, TOTAL_SHARDS_FIELD, TOTAL_UN_ASSIGNED_SHARDS_FIELD, ENVIRONMENT_INFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDomainHealthResponse.memberNameToFieldInitializer();
    private final String domainState;
    private final String availabilityZoneCount;
    private final String activeAvailabilityZoneCount;
    private final String standByAvailabilityZoneCount;
    private final String dataNodeCount;
    private final Boolean dedicatedMaster;
    private final String masterEligibleNodeCount;
    private final String warmNodeCount;
    private final String masterNode;
    private final String clusterHealth;
    private final String totalShards;
    private final String totalUnAssignedShards;
    private final List<EnvironmentInfo> environmentInformation;

    private DescribeDomainHealthResponse(BuilderImpl builder) {
        super(builder);
        this.domainState = builder.domainState;
        this.availabilityZoneCount = builder.availabilityZoneCount;
        this.activeAvailabilityZoneCount = builder.activeAvailabilityZoneCount;
        this.standByAvailabilityZoneCount = builder.standByAvailabilityZoneCount;
        this.dataNodeCount = builder.dataNodeCount;
        this.dedicatedMaster = builder.dedicatedMaster;
        this.masterEligibleNodeCount = builder.masterEligibleNodeCount;
        this.warmNodeCount = builder.warmNodeCount;
        this.masterNode = builder.masterNode;
        this.clusterHealth = builder.clusterHealth;
        this.totalShards = builder.totalShards;
        this.totalUnAssignedShards = builder.totalUnAssignedShards;
        this.environmentInformation = builder.environmentInformation;
    }

    public final DomainState domainState() {
        return DomainState.fromValue(this.domainState);
    }

    public final String domainStateAsString() {
        return this.domainState;
    }

    public final String availabilityZoneCount() {
        return this.availabilityZoneCount;
    }

    public final String activeAvailabilityZoneCount() {
        return this.activeAvailabilityZoneCount;
    }

    public final String standByAvailabilityZoneCount() {
        return this.standByAvailabilityZoneCount;
    }

    public final String dataNodeCount() {
        return this.dataNodeCount;
    }

    public final Boolean dedicatedMaster() {
        return this.dedicatedMaster;
    }

    public final String masterEligibleNodeCount() {
        return this.masterEligibleNodeCount;
    }

    public final String warmNodeCount() {
        return this.warmNodeCount;
    }

    public final MasterNodeStatus masterNode() {
        return MasterNodeStatus.fromValue(this.masterNode);
    }

    public final String masterNodeAsString() {
        return this.masterNode;
    }

    public final DomainHealth clusterHealth() {
        return DomainHealth.fromValue(this.clusterHealth);
    }

    public final String clusterHealthAsString() {
        return this.clusterHealth;
    }

    public final String totalShards() {
        return this.totalShards;
    }

    public final String totalUnAssignedShards() {
        return this.totalUnAssignedShards;
    }

    public final boolean hasEnvironmentInformation() {
        return this.environmentInformation != null && !(this.environmentInformation instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentInfo> environmentInformation() {
        return this.environmentInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeAvailabilityZoneCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.standByAvailabilityZoneCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedMaster());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterEligibleNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterNodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalShards());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalUnAssignedShards());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentInformation() ? this.environmentInformation() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainHealthResponse)) {
            return false;
        }
        DescribeDomainHealthResponse other = (DescribeDomainHealthResponse)((Object)obj);
        return Objects.equals(this.domainStateAsString(), other.domainStateAsString()) && Objects.equals(this.availabilityZoneCount(), other.availabilityZoneCount()) && Objects.equals(this.activeAvailabilityZoneCount(), other.activeAvailabilityZoneCount()) && Objects.equals(this.standByAvailabilityZoneCount(), other.standByAvailabilityZoneCount()) && Objects.equals(this.dataNodeCount(), other.dataNodeCount()) && Objects.equals(this.dedicatedMaster(), other.dedicatedMaster()) && Objects.equals(this.masterEligibleNodeCount(), other.masterEligibleNodeCount()) && Objects.equals(this.warmNodeCount(), other.warmNodeCount()) && Objects.equals(this.masterNodeAsString(), other.masterNodeAsString()) && Objects.equals(this.clusterHealthAsString(), other.clusterHealthAsString()) && Objects.equals(this.totalShards(), other.totalShards()) && Objects.equals(this.totalUnAssignedShards(), other.totalUnAssignedShards()) && this.hasEnvironmentInformation() == other.hasEnvironmentInformation() && Objects.equals(this.environmentInformation(), other.environmentInformation());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDomainHealthResponse").add("DomainState", (Object)this.domainStateAsString()).add("AvailabilityZoneCount", (Object)this.availabilityZoneCount()).add("ActiveAvailabilityZoneCount", (Object)this.activeAvailabilityZoneCount()).add("StandByAvailabilityZoneCount", (Object)this.standByAvailabilityZoneCount()).add("DataNodeCount", (Object)this.dataNodeCount()).add("DedicatedMaster", (Object)this.dedicatedMaster()).add("MasterEligibleNodeCount", (Object)this.masterEligibleNodeCount()).add("WarmNodeCount", (Object)this.warmNodeCount()).add("MasterNode", (Object)this.masterNodeAsString()).add("ClusterHealth", (Object)this.clusterHealthAsString()).add("TotalShards", (Object)this.totalShards()).add("TotalUnAssignedShards", (Object)this.totalUnAssignedShards()).add("EnvironmentInformation", this.hasEnvironmentInformation() ? this.environmentInformation() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainState": {
                return Optional.ofNullable(clazz.cast(this.domainStateAsString()));
            }
            case "AvailabilityZoneCount": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneCount()));
            }
            case "ActiveAvailabilityZoneCount": {
                return Optional.ofNullable(clazz.cast(this.activeAvailabilityZoneCount()));
            }
            case "StandByAvailabilityZoneCount": {
                return Optional.ofNullable(clazz.cast(this.standByAvailabilityZoneCount()));
            }
            case "DataNodeCount": {
                return Optional.ofNullable(clazz.cast(this.dataNodeCount()));
            }
            case "DedicatedMaster": {
                return Optional.ofNullable(clazz.cast(this.dedicatedMaster()));
            }
            case "MasterEligibleNodeCount": {
                return Optional.ofNullable(clazz.cast(this.masterEligibleNodeCount()));
            }
            case "WarmNodeCount": {
                return Optional.ofNullable(clazz.cast(this.warmNodeCount()));
            }
            case "MasterNode": {
                return Optional.ofNullable(clazz.cast(this.masterNodeAsString()));
            }
            case "ClusterHealth": {
                return Optional.ofNullable(clazz.cast(this.clusterHealthAsString()));
            }
            case "TotalShards": {
                return Optional.ofNullable(clazz.cast(this.totalShards()));
            }
            case "TotalUnAssignedShards": {
                return Optional.ofNullable(clazz.cast(this.totalUnAssignedShards()));
            }
            case "EnvironmentInformation": {
                return Optional.ofNullable(clazz.cast(this.environmentInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainState", DOMAIN_STATE_FIELD);
        map.put("AvailabilityZoneCount", AVAILABILITY_ZONE_COUNT_FIELD);
        map.put("ActiveAvailabilityZoneCount", ACTIVE_AVAILABILITY_ZONE_COUNT_FIELD);
        map.put("StandByAvailabilityZoneCount", STAND_BY_AVAILABILITY_ZONE_COUNT_FIELD);
        map.put("DataNodeCount", DATA_NODE_COUNT_FIELD);
        map.put("DedicatedMaster", DEDICATED_MASTER_FIELD);
        map.put("MasterEligibleNodeCount", MASTER_ELIGIBLE_NODE_COUNT_FIELD);
        map.put("WarmNodeCount", WARM_NODE_COUNT_FIELD);
        map.put("MasterNode", MASTER_NODE_FIELD);
        map.put("ClusterHealth", CLUSTER_HEALTH_FIELD);
        map.put("TotalShards", TOTAL_SHARDS_FIELD);
        map.put("TotalUnAssignedShards", TOTAL_UN_ASSIGNED_SHARDS_FIELD);
        map.put("EnvironmentInformation", ENVIRONMENT_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainHealthResponse, T> g) {
        return obj -> g.apply((DescribeDomainHealthResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private String domainState;
        private String availabilityZoneCount;
        private String activeAvailabilityZoneCount;
        private String standByAvailabilityZoneCount;
        private String dataNodeCount;
        private Boolean dedicatedMaster;
        private String masterEligibleNodeCount;
        private String warmNodeCount;
        private String masterNode;
        private String clusterHealth;
        private String totalShards;
        private String totalUnAssignedShards;
        private List<EnvironmentInfo> environmentInformation = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainHealthResponse model) {
            super(model);
            this.domainState(model.domainState);
            this.availabilityZoneCount(model.availabilityZoneCount);
            this.activeAvailabilityZoneCount(model.activeAvailabilityZoneCount);
            this.standByAvailabilityZoneCount(model.standByAvailabilityZoneCount);
            this.dataNodeCount(model.dataNodeCount);
            this.dedicatedMaster(model.dedicatedMaster);
            this.masterEligibleNodeCount(model.masterEligibleNodeCount);
            this.warmNodeCount(model.warmNodeCount);
            this.masterNode(model.masterNode);
            this.clusterHealth(model.clusterHealth);
            this.totalShards(model.totalShards);
            this.totalUnAssignedShards(model.totalUnAssignedShards);
            this.environmentInformation(model.environmentInformation);
        }

        public final String getDomainState() {
            return this.domainState;
        }

        public final void setDomainState(String domainState) {
            this.domainState = domainState;
        }

        @Override
        public final Builder domainState(String domainState) {
            this.domainState = domainState;
            return this;
        }

        @Override
        public final Builder domainState(DomainState domainState) {
            this.domainState(domainState == null ? null : domainState.toString());
            return this;
        }

        public final String getAvailabilityZoneCount() {
            return this.availabilityZoneCount;
        }

        public final void setAvailabilityZoneCount(String availabilityZoneCount) {
            this.availabilityZoneCount = availabilityZoneCount;
        }

        @Override
        public final Builder availabilityZoneCount(String availabilityZoneCount) {
            this.availabilityZoneCount = availabilityZoneCount;
            return this;
        }

        public final String getActiveAvailabilityZoneCount() {
            return this.activeAvailabilityZoneCount;
        }

        public final void setActiveAvailabilityZoneCount(String activeAvailabilityZoneCount) {
            this.activeAvailabilityZoneCount = activeAvailabilityZoneCount;
        }

        @Override
        public final Builder activeAvailabilityZoneCount(String activeAvailabilityZoneCount) {
            this.activeAvailabilityZoneCount = activeAvailabilityZoneCount;
            return this;
        }

        public final String getStandByAvailabilityZoneCount() {
            return this.standByAvailabilityZoneCount;
        }

        public final void setStandByAvailabilityZoneCount(String standByAvailabilityZoneCount) {
            this.standByAvailabilityZoneCount = standByAvailabilityZoneCount;
        }

        @Override
        public final Builder standByAvailabilityZoneCount(String standByAvailabilityZoneCount) {
            this.standByAvailabilityZoneCount = standByAvailabilityZoneCount;
            return this;
        }

        public final String getDataNodeCount() {
            return this.dataNodeCount;
        }

        public final void setDataNodeCount(String dataNodeCount) {
            this.dataNodeCount = dataNodeCount;
        }

        @Override
        public final Builder dataNodeCount(String dataNodeCount) {
            this.dataNodeCount = dataNodeCount;
            return this;
        }

        public final Boolean getDedicatedMaster() {
            return this.dedicatedMaster;
        }

        public final void setDedicatedMaster(Boolean dedicatedMaster) {
            this.dedicatedMaster = dedicatedMaster;
        }

        @Override
        public final Builder dedicatedMaster(Boolean dedicatedMaster) {
            this.dedicatedMaster = dedicatedMaster;
            return this;
        }

        public final String getMasterEligibleNodeCount() {
            return this.masterEligibleNodeCount;
        }

        public final void setMasterEligibleNodeCount(String masterEligibleNodeCount) {
            this.masterEligibleNodeCount = masterEligibleNodeCount;
        }

        @Override
        public final Builder masterEligibleNodeCount(String masterEligibleNodeCount) {
            this.masterEligibleNodeCount = masterEligibleNodeCount;
            return this;
        }

        public final String getWarmNodeCount() {
            return this.warmNodeCount;
        }

        public final void setWarmNodeCount(String warmNodeCount) {
            this.warmNodeCount = warmNodeCount;
        }

        @Override
        public final Builder warmNodeCount(String warmNodeCount) {
            this.warmNodeCount = warmNodeCount;
            return this;
        }

        public final String getMasterNode() {
            return this.masterNode;
        }

        public final void setMasterNode(String masterNode) {
            this.masterNode = masterNode;
        }

        @Override
        public final Builder masterNode(String masterNode) {
            this.masterNode = masterNode;
            return this;
        }

        @Override
        public final Builder masterNode(MasterNodeStatus masterNode) {
            this.masterNode(masterNode == null ? null : masterNode.toString());
            return this;
        }

        public final String getClusterHealth() {
            return this.clusterHealth;
        }

        public final void setClusterHealth(String clusterHealth) {
            this.clusterHealth = clusterHealth;
        }

        @Override
        public final Builder clusterHealth(String clusterHealth) {
            this.clusterHealth = clusterHealth;
            return this;
        }

        @Override
        public final Builder clusterHealth(DomainHealth clusterHealth) {
            this.clusterHealth(clusterHealth == null ? null : clusterHealth.toString());
            return this;
        }

        public final String getTotalShards() {
            return this.totalShards;
        }

        public final void setTotalShards(String totalShards) {
            this.totalShards = totalShards;
        }

        @Override
        public final Builder totalShards(String totalShards) {
            this.totalShards = totalShards;
            return this;
        }

        public final String getTotalUnAssignedShards() {
            return this.totalUnAssignedShards;
        }

        public final void setTotalUnAssignedShards(String totalUnAssignedShards) {
            this.totalUnAssignedShards = totalUnAssignedShards;
        }

        @Override
        public final Builder totalUnAssignedShards(String totalUnAssignedShards) {
            this.totalUnAssignedShards = totalUnAssignedShards;
            return this;
        }

        public final List<EnvironmentInfo.Builder> getEnvironmentInformation() {
            List<EnvironmentInfo.Builder> result = EnvironmentInfoListCopier.copyToBuilder(this.environmentInformation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentInformation(Collection<EnvironmentInfo.BuilderImpl> environmentInformation) {
            this.environmentInformation = EnvironmentInfoListCopier.copyFromBuilder(environmentInformation);
        }

        @Override
        public final Builder environmentInformation(Collection<EnvironmentInfo> environmentInformation) {
            this.environmentInformation = EnvironmentInfoListCopier.copy(environmentInformation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInformation(EnvironmentInfo ... environmentInformation) {
            this.environmentInformation(Arrays.asList(environmentInformation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInformation(Consumer<EnvironmentInfo.Builder> ... environmentInformation) {
            this.environmentInformation(Stream.of(environmentInformation).map(c -> (EnvironmentInfo)((EnvironmentInfo.Builder)EnvironmentInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDomainHealthResponse build() {
            return new DescribeDomainHealthResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDomainHealthResponse> {
        public Builder domainState(String var1);

        public Builder domainState(DomainState var1);

        public Builder availabilityZoneCount(String var1);

        public Builder activeAvailabilityZoneCount(String var1);

        public Builder standByAvailabilityZoneCount(String var1);

        public Builder dataNodeCount(String var1);

        public Builder dedicatedMaster(Boolean var1);

        public Builder masterEligibleNodeCount(String var1);

        public Builder warmNodeCount(String var1);

        public Builder masterNode(String var1);

        public Builder masterNode(MasterNodeStatus var1);

        public Builder clusterHealth(String var1);

        public Builder clusterHealth(DomainHealth var1);

        public Builder totalShards(String var1);

        public Builder totalUnAssignedShards(String var1);

        public Builder environmentInformation(Collection<EnvironmentInfo> var1);

        public Builder environmentInformation(EnvironmentInfo ... var1);

        public Builder environmentInformation(Consumer<EnvironmentInfo.Builder> ... var1);
    }
}

