/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HandshakeConstraintViolationExceptionReason {
    ACCOUNT_NUMBER_LIMIT_EXCEEDED("ACCOUNT_NUMBER_LIMIT_EXCEEDED"),
    HANDSHAKE_RATE_LIMIT_EXCEEDED("HANDSHAKE_RATE_LIMIT_EXCEEDED"),
    ALREADY_IN_AN_ORGANIZATION("ALREADY_IN_AN_ORGANIZATION"),
    ORGANIZATION_ALREADY_HAS_ALL_FEATURES("ORGANIZATION_ALREADY_HAS_ALL_FEATURES"),
    ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION("ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION"),
    INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES("INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES"),
    PAYMENT_INSTRUMENT_REQUIRED("PAYMENT_INSTRUMENT_REQUIRED"),
    ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD("ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD"),
    ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED("ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED"),
    MANAGEMENT_ACCOUNT_EMAIL_NOT_VERIFIED("MANAGEMENT_ACCOUNT_EMAIL_NOT_VERIFIED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HandshakeConstraintViolationExceptionReason> VALUE_MAP;
    private final String value;

    private HandshakeConstraintViolationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HandshakeConstraintViolationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HandshakeConstraintViolationExceptionReason> knownValues() {
        EnumSet<HandshakeConstraintViolationExceptionReason> knownValues = EnumSet.allOf(HandshakeConstraintViolationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HandshakeConstraintViolationExceptionReason.class, HandshakeConstraintViolationExceptionReason::toString);
    }
}

