/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.ResponsibilityTransferStatus;
import software.amazon.awssdk.services.organizations.model.ResponsibilityTransferType;
import software.amazon.awssdk.services.organizations.model.TransferParticipant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponsibilityTransfer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponsibilityTransfer> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ResponsibilityTransfer.getter(ResponsibilityTransfer::arn)).setter(ResponsibilityTransfer.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResponsibilityTransfer.getter(ResponsibilityTransfer::name)).setter(ResponsibilityTransfer.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ResponsibilityTransfer.getter(ResponsibilityTransfer::id)).setter(ResponsibilityTransfer.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ResponsibilityTransfer.getter(ResponsibilityTransfer::typeAsString)).setter(ResponsibilityTransfer.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ResponsibilityTransfer.getter(ResponsibilityTransfer::statusAsString)).setter(ResponsibilityTransfer.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<TransferParticipant> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(ResponsibilityTransfer.getter(ResponsibilityTransfer::source)).setter(ResponsibilityTransfer.setter(Builder::source)).constructor(TransferParticipant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<TransferParticipant> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Target").getter(ResponsibilityTransfer.getter(ResponsibilityTransfer::target)).setter(ResponsibilityTransfer.setter(Builder::target)).constructor(TransferParticipant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(ResponsibilityTransfer.getter(ResponsibilityTransfer::startTimestamp)).setter(ResponsibilityTransfer.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimestamp").getter(ResponsibilityTransfer.getter(ResponsibilityTransfer::endTimestamp)).setter(ResponsibilityTransfer.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()}).build();
    private static final SdkField<String> ACTIVE_HANDSHAKE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveHandshakeId").getter(ResponsibilityTransfer.getter(ResponsibilityTransfer::activeHandshakeId)).setter(ResponsibilityTransfer.setter(Builder::activeHandshakeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveHandshakeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, ID_FIELD, TYPE_FIELD, STATUS_FIELD, SOURCE_FIELD, TARGET_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, ACTIVE_HANDSHAKE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResponsibilityTransfer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String id;
    private final String type;
    private final String status;
    private final TransferParticipant source;
    private final TransferParticipant target;
    private final Instant startTimestamp;
    private final Instant endTimestamp;
    private final String activeHandshakeId;

    private ResponsibilityTransfer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.source = builder.source;
        this.target = builder.target;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.activeHandshakeId = builder.activeHandshakeId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final ResponsibilityTransferType type() {
        return ResponsibilityTransferType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ResponsibilityTransferStatus status() {
        return ResponsibilityTransferStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TransferParticipant source() {
        return this.source;
    }

    public final TransferParticipant target() {
        return this.target;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final Instant endTimestamp() {
        return this.endTimestamp;
    }

    public final String activeHandshakeId() {
        return this.activeHandshakeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeHandshakeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponsibilityTransfer)) {
            return false;
        }
        ResponsibilityTransfer other = (ResponsibilityTransfer)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp()) && Objects.equals(this.activeHandshakeId(), other.activeHandshakeId());
    }

    public final String toString() {
        return ToString.builder((String)"ResponsibilityTransfer").add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("Source", (Object)this.source()).add("Target", (Object)this.target()).add("StartTimestamp", (Object)this.startTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).add("ActiveHandshakeId", (Object)this.activeHandshakeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "EndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
            case "ActiveHandshakeId": {
                return Optional.ofNullable(clazz.cast(this.activeHandshakeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        map.put("ActiveHandshakeId", ACTIVE_HANDSHAKE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponsibilityTransfer, T> g) {
        return obj -> g.apply((ResponsibilityTransfer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String id;
        private String type;
        private String status;
        private TransferParticipant source;
        private TransferParticipant target;
        private Instant startTimestamp;
        private Instant endTimestamp;
        private String activeHandshakeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponsibilityTransfer model) {
            this.arn(model.arn);
            this.name(model.name);
            this.id(model.id);
            this.type(model.type);
            this.status(model.status);
            this.source(model.source);
            this.target(model.target);
            this.startTimestamp(model.startTimestamp);
            this.endTimestamp(model.endTimestamp);
            this.activeHandshakeId(model.activeHandshakeId);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResponsibilityTransferType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResponsibilityTransferStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TransferParticipant.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TransferParticipant.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransferParticipant source) {
            this.source = source;
            return this;
        }

        public final TransferParticipant.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(TransferParticipant.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TransferParticipant target) {
            this.target = target;
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final String getActiveHandshakeId() {
            return this.activeHandshakeId;
        }

        public final void setActiveHandshakeId(String activeHandshakeId) {
            this.activeHandshakeId = activeHandshakeId;
        }

        @Override
        public final Builder activeHandshakeId(String activeHandshakeId) {
            this.activeHandshakeId = activeHandshakeId;
            return this;
        }

        public ResponsibilityTransfer build() {
            return new ResponsibilityTransfer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponsibilityTransfer> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(ResponsibilityTransferType var1);

        public Builder status(String var1);

        public Builder status(ResponsibilityTransferStatus var1);

        public Builder source(TransferParticipant var1);

        default public Builder source(Consumer<TransferParticipant.Builder> source) {
            return this.source((TransferParticipant)((TransferParticipant.Builder)TransferParticipant.builder().applyMutation(source)).build());
        }

        public Builder target(TransferParticipant var1);

        default public Builder target(Consumer<TransferParticipant.Builder> target) {
            return this.target((TransferParticipant)((TransferParticipant.Builder)TransferParticipant.builder().applyMutation(target)).build());
        }

        public Builder startTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);

        public Builder activeHandshakeId(String var1);
    }
}

