/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An application instance's state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportedRuntimeContextState implements SdkPojo, Serializable,
        ToCopyableBuilder<ReportedRuntimeContextState.Builder, ReportedRuntimeContextState> {
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredState").getter(getter(ReportedRuntimeContextState::desiredStateAsString))
            .setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()).build();

    private static final SdkField<String> DEVICE_REPORTED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceReportedStatus").getter(getter(ReportedRuntimeContextState::deviceReportedStatusAsString))
            .setter(setter(Builder::deviceReportedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceReportedStatus").build())
            .build();

    private static final SdkField<Instant> DEVICE_REPORTED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeviceReportedTime").getter(getter(ReportedRuntimeContextState::deviceReportedTime))
            .setter(setter(Builder::deviceReportedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceReportedTime").build())
            .build();

    private static final SdkField<String> RUNTIME_CONTEXT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeContextName").getter(getter(ReportedRuntimeContextState::runtimeContextName))
            .setter(setter(Builder::runtimeContextName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeContextName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_STATE_FIELD,
            DEVICE_REPORTED_STATUS_FIELD, DEVICE_REPORTED_TIME_FIELD, RUNTIME_CONTEXT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String desiredState;

    private final String deviceReportedStatus;

    private final Instant deviceReportedTime;

    private final String runtimeContextName;

    private ReportedRuntimeContextState(BuilderImpl builder) {
        this.desiredState = builder.desiredState;
        this.deviceReportedStatus = builder.deviceReportedStatus;
        this.deviceReportedTime = builder.deviceReportedTime;
        this.runtimeContextName = builder.runtimeContextName;
    }

    /**
     * <p>
     * The application's desired state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link DesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The application's desired state.
     * @see DesiredState
     */
    public final DesiredState desiredState() {
        return DesiredState.fromValue(desiredState);
    }

    /**
     * <p>
     * The application's desired state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link DesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The application's desired state.
     * @see DesiredState
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * <p>
     * The application's reported status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceReportedStatus} will return {@link DeviceReportedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceReportedStatusAsString}.
     * </p>
     * 
     * @return The application's reported status.
     * @see DeviceReportedStatus
     */
    public final DeviceReportedStatus deviceReportedStatus() {
        return DeviceReportedStatus.fromValue(deviceReportedStatus);
    }

    /**
     * <p>
     * The application's reported status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceReportedStatus} will return {@link DeviceReportedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceReportedStatusAsString}.
     * </p>
     * 
     * @return The application's reported status.
     * @see DeviceReportedStatus
     */
    public final String deviceReportedStatusAsString() {
        return deviceReportedStatus;
    }

    /**
     * <p>
     * When the device reported the application's state.
     * </p>
     * 
     * @return When the device reported the application's state.
     */
    public final Instant deviceReportedTime() {
        return deviceReportedTime;
    }

    /**
     * <p>
     * The device's name.
     * </p>
     * 
     * @return The device's name.
     */
    public final String runtimeContextName() {
        return runtimeContextName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceReportedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceReportedTime());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeContextName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportedRuntimeContextState)) {
            return false;
        }
        ReportedRuntimeContextState other = (ReportedRuntimeContextState) obj;
        return Objects.equals(desiredStateAsString(), other.desiredStateAsString())
                && Objects.equals(deviceReportedStatusAsString(), other.deviceReportedStatusAsString())
                && Objects.equals(deviceReportedTime(), other.deviceReportedTime())
                && Objects.equals(runtimeContextName(), other.runtimeContextName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportedRuntimeContextState").add("DesiredState", desiredStateAsString())
                .add("DeviceReportedStatus", deviceReportedStatusAsString()).add("DeviceReportedTime", deviceReportedTime())
                .add("RuntimeContextName", runtimeContextName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "DeviceReportedStatus":
            return Optional.ofNullable(clazz.cast(deviceReportedStatusAsString()));
        case "DeviceReportedTime":
            return Optional.ofNullable(clazz.cast(deviceReportedTime()));
        case "RuntimeContextName":
            return Optional.ofNullable(clazz.cast(runtimeContextName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportedRuntimeContextState, T> g) {
        return obj -> g.apply((ReportedRuntimeContextState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportedRuntimeContextState> {
        /**
         * <p>
         * The application's desired state.
         * </p>
         * 
         * @param desiredState
         *        The application's desired state.
         * @see DesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredState
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * The application's desired state.
         * </p>
         * 
         * @param desiredState
         *        The application's desired state.
         * @see DesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredState
         */
        Builder desiredState(DesiredState desiredState);

        /**
         * <p>
         * The application's reported status.
         * </p>
         * 
         * @param deviceReportedStatus
         *        The application's reported status.
         * @see DeviceReportedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceReportedStatus
         */
        Builder deviceReportedStatus(String deviceReportedStatus);

        /**
         * <p>
         * The application's reported status.
         * </p>
         * 
         * @param deviceReportedStatus
         *        The application's reported status.
         * @see DeviceReportedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceReportedStatus
         */
        Builder deviceReportedStatus(DeviceReportedStatus deviceReportedStatus);

        /**
         * <p>
         * When the device reported the application's state.
         * </p>
         * 
         * @param deviceReportedTime
         *        When the device reported the application's state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceReportedTime(Instant deviceReportedTime);

        /**
         * <p>
         * The device's name.
         * </p>
         * 
         * @param runtimeContextName
         *        The device's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeContextName(String runtimeContextName);
    }

    static final class BuilderImpl implements Builder {
        private String desiredState;

        private String deviceReportedStatus;

        private Instant deviceReportedTime;

        private String runtimeContextName;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportedRuntimeContextState model) {
            desiredState(model.desiredState);
            deviceReportedStatus(model.deviceReportedStatus);
            deviceReportedTime(model.deviceReportedTime);
            runtimeContextName(model.runtimeContextName);
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(DesiredState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getDeviceReportedStatus() {
            return deviceReportedStatus;
        }

        public final void setDeviceReportedStatus(String deviceReportedStatus) {
            this.deviceReportedStatus = deviceReportedStatus;
        }

        @Override
        public final Builder deviceReportedStatus(String deviceReportedStatus) {
            this.deviceReportedStatus = deviceReportedStatus;
            return this;
        }

        @Override
        public final Builder deviceReportedStatus(DeviceReportedStatus deviceReportedStatus) {
            this.deviceReportedStatus(deviceReportedStatus == null ? null : deviceReportedStatus.toString());
            return this;
        }

        public final Instant getDeviceReportedTime() {
            return deviceReportedTime;
        }

        public final void setDeviceReportedTime(Instant deviceReportedTime) {
            this.deviceReportedTime = deviceReportedTime;
        }

        @Override
        public final Builder deviceReportedTime(Instant deviceReportedTime) {
            this.deviceReportedTime = deviceReportedTime;
            return this;
        }

        public final String getRuntimeContextName() {
            return runtimeContextName;
        }

        public final void setRuntimeContextName(String runtimeContextName) {
            this.runtimeContextName = runtimeContextName;
        }

        @Override
        public final Builder runtimeContextName(String runtimeContextName) {
            this.runtimeContextName = runtimeContextName;
            return this;
        }

        @Override
        public ReportedRuntimeContextState build() {
            return new ReportedRuntimeContextState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
