/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyResponse;
import software.amazon.awssdk.services.paymentcryptography.model.RegionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableDefaultKeyReplicationRegionsResponse
extends PaymentCryptographyResponse
implements ToCopyableBuilder<Builder, EnableDefaultKeyReplicationRegionsResponse> {
    private static final SdkField<List<String>> ENABLED_REPLICATION_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledReplicationRegions").getter(EnableDefaultKeyReplicationRegionsResponse.getter(EnableDefaultKeyReplicationRegionsResponse::enabledReplicationRegions)).setter(EnableDefaultKeyReplicationRegionsResponse.setter(Builder::enabledReplicationRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledReplicationRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_REPLICATION_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableDefaultKeyReplicationRegionsResponse.memberNameToFieldInitializer();
    private final List<String> enabledReplicationRegions;

    private EnableDefaultKeyReplicationRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.enabledReplicationRegions = builder.enabledReplicationRegions;
    }

    public final boolean hasEnabledReplicationRegions() {
        return this.enabledReplicationRegions != null && !(this.enabledReplicationRegions instanceof SdkAutoConstructList);
    }

    public final List<String> enabledReplicationRegions() {
        return this.enabledReplicationRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledReplicationRegions() ? this.enabledReplicationRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableDefaultKeyReplicationRegionsResponse)) {
            return false;
        }
        EnableDefaultKeyReplicationRegionsResponse other = (EnableDefaultKeyReplicationRegionsResponse)((Object)obj);
        return this.hasEnabledReplicationRegions() == other.hasEnabledReplicationRegions() && Objects.equals(this.enabledReplicationRegions(), other.enabledReplicationRegions());
    }

    public final String toString() {
        return ToString.builder((String)"EnableDefaultKeyReplicationRegionsResponse").add("EnabledReplicationRegions", this.hasEnabledReplicationRegions() ? this.enabledReplicationRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnabledReplicationRegions": {
                return Optional.ofNullable(clazz.cast(this.enabledReplicationRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("EnabledReplicationRegions", ENABLED_REPLICATION_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableDefaultKeyReplicationRegionsResponse, T> g) {
        return obj -> g.apply((EnableDefaultKeyReplicationRegionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyResponse.BuilderImpl
    implements Builder {
        private List<String> enabledReplicationRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableDefaultKeyReplicationRegionsResponse model) {
            super(model);
            this.enabledReplicationRegions(model.enabledReplicationRegions);
        }

        public final Collection<String> getEnabledReplicationRegions() {
            if (this.enabledReplicationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledReplicationRegions;
        }

        public final void setEnabledReplicationRegions(Collection<String> enabledReplicationRegions) {
            this.enabledReplicationRegions = RegionsCopier.copy(enabledReplicationRegions);
        }

        @Override
        public final Builder enabledReplicationRegions(Collection<String> enabledReplicationRegions) {
            this.enabledReplicationRegions = RegionsCopier.copy(enabledReplicationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledReplicationRegions(String ... enabledReplicationRegions) {
            this.enabledReplicationRegions(Arrays.asList(enabledReplicationRegions));
            return this;
        }

        @Override
        public EnableDefaultKeyReplicationRegionsResponse build() {
            return new EnableDefaultKeyReplicationRegionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PaymentCryptographyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableDefaultKeyReplicationRegionsResponse> {
        public Builder enabledReplicationRegions(Collection<String> var1);

        public Builder enabledReplicationRegions(String ... var1);
    }
}

