/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DukptDerivationType {
    TDES_2_KEY("TDES_2KEY"),
    TDES_3_KEY("TDES_3KEY"),
    AES_128("AES_128"),
    AES_192("AES_192"),
    AES_256("AES_256"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DukptDerivationType> VALUE_MAP;
    private final String value;

    private DukptDerivationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DukptDerivationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DukptDerivationType> knownValues() {
        EnumSet<DukptDerivationType> knownValues = EnumSet.allOf(DukptDerivationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DukptDerivationType.class, DukptDerivationType::toString);
    }
}

