/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.KeyUsageFlags;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyUsage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyUsage> {
    private static final SdkField<Boolean> CRITICAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Critical").getter(KeyUsage.getter(KeyUsage::critical)).setter(KeyUsage.setter(Builder::critical)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Critical").build()}).build();
    private static final SdkField<KeyUsageFlags> USAGE_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UsageFlags").getter(KeyUsage.getter(KeyUsage::usageFlags)).setter(KeyUsage.setter(Builder::usageFlags)).constructor(KeyUsageFlags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageFlags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITICAL_FIELD, USAGE_FLAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean critical;
    private final KeyUsageFlags usageFlags;

    private KeyUsage(BuilderImpl builder) {
        this.critical = builder.critical;
        this.usageFlags = builder.usageFlags;
    }

    public final Boolean critical() {
        return this.critical;
    }

    public final KeyUsageFlags usageFlags() {
        return this.usageFlags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.critical());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageFlags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsage)) {
            return false;
        }
        KeyUsage other = (KeyUsage)obj;
        return Objects.equals(this.critical(), other.critical()) && Objects.equals(this.usageFlags(), other.usageFlags());
    }

    public final String toString() {
        return ToString.builder((String)"KeyUsage").add("Critical", (Object)this.critical()).add("UsageFlags", (Object)this.usageFlags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Critical": {
                return Optional.ofNullable(clazz.cast(this.critical()));
            }
            case "UsageFlags": {
                return Optional.ofNullable(clazz.cast(this.usageFlags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyUsage, T> g) {
        return obj -> g.apply((KeyUsage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean critical;
        private KeyUsageFlags usageFlags;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsage model) {
            this.critical(model.critical);
            this.usageFlags(model.usageFlags);
        }

        public final Boolean getCritical() {
            return this.critical;
        }

        public final void setCritical(Boolean critical) {
            this.critical = critical;
        }

        @Override
        public final Builder critical(Boolean critical) {
            this.critical = critical;
            return this;
        }

        public final KeyUsageFlags.Builder getUsageFlags() {
            return this.usageFlags != null ? this.usageFlags.toBuilder() : null;
        }

        public final void setUsageFlags(KeyUsageFlags.BuilderImpl usageFlags) {
            this.usageFlags = usageFlags != null ? usageFlags.build() : null;
        }

        @Override
        public final Builder usageFlags(KeyUsageFlags usageFlags) {
            this.usageFlags = usageFlags;
            return this;
        }

        public KeyUsage build() {
            return new KeyUsage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyUsage> {
        public Builder critical(Boolean var1);

        public Builder usageFlags(KeyUsageFlags var1);

        default public Builder usageFlags(Consumer<KeyUsageFlags.Builder> usageFlags) {
            return this.usageFlags((KeyUsageFlags)((KeyUsageFlags.Builder)KeyUsageFlags.builder().applyMutation(usageFlags)).build());
        }
    }
}

