/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.ConnectorStatus;
import software.amazon.awssdk.services.pcaconnectorad.model.ConnectorStatusReason;
import software.amazon.awssdk.services.pcaconnectorad.model.VpcInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Connector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Connector> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Connector.getter(Connector::arn)).setter(Connector.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(Connector.getter(Connector::certificateAuthorityArn)).setter(Connector.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ENROLLMENT_POLICY_SERVER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateEnrollmentPolicyServerEndpoint").getter(Connector.getter(Connector::certificateEnrollmentPolicyServerEndpoint)).setter(Connector.setter(Builder::certificateEnrollmentPolicyServerEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateEnrollmentPolicyServerEndpoint").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Connector.getter(Connector::createdAt)).setter(Connector.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(Connector.getter(Connector::directoryId)).setter(Connector.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Connector.getter(Connector::statusAsString)).setter(Connector.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(Connector.getter(Connector::statusReasonAsString)).setter(Connector.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(Connector.getter(Connector::updatedAt)).setter(Connector.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<VpcInformation> VPC_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcInformation").getter(Connector.getter(Connector::vpcInformation)).setter(Connector.setter(Builder::vpcInformation)).constructor(VpcInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD, CERTIFICATE_ENROLLMENT_POLICY_SERVER_ENDPOINT_FIELD, CREATED_AT_FIELD, DIRECTORY_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, UPDATED_AT_FIELD, VPC_INFORMATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String certificateAuthorityArn;
    private final String certificateEnrollmentPolicyServerEndpoint;
    private final Instant createdAt;
    private final String directoryId;
    private final String status;
    private final String statusReason;
    private final Instant updatedAt;
    private final VpcInformation vpcInformation;

    private Connector(BuilderImpl builder) {
        this.arn = builder.arn;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.certificateEnrollmentPolicyServerEndpoint = builder.certificateEnrollmentPolicyServerEndpoint;
        this.createdAt = builder.createdAt;
        this.directoryId = builder.directoryId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.updatedAt = builder.updatedAt;
        this.vpcInformation = builder.vpcInformation;
    }

    public final String arn() {
        return this.arn;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final String certificateEnrollmentPolicyServerEndpoint() {
        return this.certificateEnrollmentPolicyServerEndpoint;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final ConnectorStatus status() {
        return ConnectorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ConnectorStatusReason statusReason() {
        return ConnectorStatusReason.fromValue(this.statusReason);
    }

    public final String statusReasonAsString() {
        return this.statusReason;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final VpcInformation vpcInformation() {
        return this.vpcInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateEnrollmentPolicyServerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcInformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connector)) {
            return false;
        }
        Connector other = (Connector)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.certificateEnrollmentPolicyServerEndpoint(), other.certificateEnrollmentPolicyServerEndpoint()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReasonAsString(), other.statusReasonAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.vpcInformation(), other.vpcInformation());
    }

    public final String toString() {
        return ToString.builder((String)"Connector").add("Arn", (Object)this.arn()).add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("CertificateEnrollmentPolicyServerEndpoint", (Object)this.certificateEnrollmentPolicyServerEndpoint()).add("CreatedAt", (Object)this.createdAt()).add("DirectoryId", (Object)this.directoryId()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReasonAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("VpcInformation", (Object)this.vpcInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "CertificateEnrollmentPolicyServerEndpoint": {
                return Optional.ofNullable(clazz.cast(this.certificateEnrollmentPolicyServerEndpoint()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReasonAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "VpcInformation": {
                return Optional.ofNullable(clazz.cast(this.vpcInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Connector, T> g) {
        return obj -> g.apply((Connector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String certificateAuthorityArn;
        private String certificateEnrollmentPolicyServerEndpoint;
        private Instant createdAt;
        private String directoryId;
        private String status;
        private String statusReason;
        private Instant updatedAt;
        private VpcInformation vpcInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(Connector model) {
            this.arn(model.arn);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.certificateEnrollmentPolicyServerEndpoint(model.certificateEnrollmentPolicyServerEndpoint);
            this.createdAt(model.createdAt);
            this.directoryId(model.directoryId);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.updatedAt(model.updatedAt);
            this.vpcInformation(model.vpcInformation);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final String getCertificateEnrollmentPolicyServerEndpoint() {
            return this.certificateEnrollmentPolicyServerEndpoint;
        }

        public final void setCertificateEnrollmentPolicyServerEndpoint(String certificateEnrollmentPolicyServerEndpoint) {
            this.certificateEnrollmentPolicyServerEndpoint = certificateEnrollmentPolicyServerEndpoint;
        }

        @Override
        public final Builder certificateEnrollmentPolicyServerEndpoint(String certificateEnrollmentPolicyServerEndpoint) {
            this.certificateEnrollmentPolicyServerEndpoint = certificateEnrollmentPolicyServerEndpoint;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ConnectorStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final VpcInformation.Builder getVpcInformation() {
            return this.vpcInformation != null ? this.vpcInformation.toBuilder() : null;
        }

        public final void setVpcInformation(VpcInformation.BuilderImpl vpcInformation) {
            this.vpcInformation = vpcInformation != null ? vpcInformation.build() : null;
        }

        @Override
        public final Builder vpcInformation(VpcInformation vpcInformation) {
            this.vpcInformation = vpcInformation;
            return this;
        }

        public Connector build() {
            return new Connector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Connector> {
        public Builder arn(String var1);

        public Builder certificateAuthorityArn(String var1);

        public Builder certificateEnrollmentPolicyServerEndpoint(String var1);

        public Builder createdAt(Instant var1);

        public Builder directoryId(String var1);

        public Builder status(String var1);

        public Builder status(ConnectorStatus var1);

        public Builder statusReason(String var1);

        public Builder statusReason(ConnectorStatusReason var1);

        public Builder updatedAt(Instant var1);

        public Builder vpcInformation(VpcInformation var1);

        default public Builder vpcInformation(Consumer<VpcInformation.Builder> vpcInformation) {
            return this.vpcInformation((VpcInformation)((VpcInformation.Builder)VpcInformation.builder().applyMutation(vpcInformation)).build());
        }
    }
}

