/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClientCompatibilityV4 {
    WINDOWS_SERVER_2012("WINDOWS_SERVER_2012"),
    WINDOWS_SERVER_2012_R2("WINDOWS_SERVER_2012_R2"),
    WINDOWS_SERVER_2016("WINDOWS_SERVER_2016"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClientCompatibilityV4> VALUE_MAP;
    private final String value;

    private ClientCompatibilityV4(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClientCompatibilityV4 fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClientCompatibilityV4> knownValues() {
        EnumSet<ClientCompatibilityV4> knownValues = EnumSet.allOf(ClientCompatibilityV4.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClientCompatibilityV4.class, ClientCompatibilityV4::toString);
    }
}

