/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on a metric attribution. A metric attribution creates reports on the data that you import into
 * Amazon Personalize. Depending on how you import the data, you can view reports in Amazon CloudWatch or Amazon S3. For
 * more information, see <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of
 * recommendations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricAttribution implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricAttribution.Builder, MetricAttribution> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MetricAttribution::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> METRIC_ATTRIBUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricAttributionArn").getter(getter(MetricAttribution::metricAttributionArn))
            .setter(setter(Builder::metricAttributionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricAttributionArn").build())
            .build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(MetricAttribution::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<MetricAttributionOutput> METRICS_OUTPUT_CONFIG_FIELD = SdkField
            .<MetricAttributionOutput> builder(MarshallingType.SDK_POJO).memberName("metricsOutputConfig")
            .getter(getter(MetricAttribution::metricsOutputConfig)).setter(setter(Builder::metricsOutputConfig))
            .constructor(MetricAttributionOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsOutputConfig").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(MetricAttribution::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(MetricAttribution::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(MetricAttribution::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(MetricAttribution::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            METRIC_ATTRIBUTION_ARN_FIELD, DATASET_GROUP_ARN_FIELD, METRICS_OUTPUT_CONFIG_FIELD, STATUS_FIELD,
            CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String metricAttributionArn;

    private final String datasetGroupArn;

    private final MetricAttributionOutput metricsOutputConfig;

    private final String status;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String failureReason;

    private MetricAttribution(BuilderImpl builder) {
        this.name = builder.name;
        this.metricAttributionArn = builder.metricAttributionArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.metricsOutputConfig = builder.metricsOutputConfig;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The metric attribution's name.
     * </p>
     * 
     * @return The metric attribution's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The metric attribution's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The metric attribution's Amazon Resource Name (ARN).
     */
    public final String metricAttributionArn() {
        return metricAttributionArn;
    }

    /**
     * <p>
     * The metric attribution's dataset group Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The metric attribution's dataset group Amazon Resource Name (ARN).
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The metric attribution's output configuration.
     * </p>
     * 
     * @return The metric attribution's output configuration.
     */
    public final MetricAttributionOutput metricsOutputConfig() {
        return metricsOutputConfig;
    }

    /**
     * <p>
     * The metric attribution's status.
     * </p>
     * 
     * @return The metric attribution's status.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The metric attribution's creation date time.
     * </p>
     * 
     * @return The metric attribution's creation date time.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The metric attribution's last updated date time.
     * </p>
     * 
     * @return The metric attribution's last updated date time.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The metric attribution's failure reason.
     * </p>
     * 
     * @return The metric attribution's failure reason.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(metricAttributionArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricsOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricAttribution)) {
            return false;
        }
        MetricAttribution other = (MetricAttribution) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(metricAttributionArn(), other.metricAttributionArn())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(metricsOutputConfig(), other.metricsOutputConfig()) && Objects.equals(status(), other.status())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricAttribution").add("Name", name()).add("MetricAttributionArn", metricAttributionArn())
                .add("DatasetGroupArn", datasetGroupArn()).add("MetricsOutputConfig", metricsOutputConfig())
                .add("Status", status()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "metricAttributionArn":
            return Optional.ofNullable(clazz.cast(metricAttributionArn()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "metricsOutputConfig":
            return Optional.ofNullable(clazz.cast(metricsOutputConfig()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricAttribution, T> g) {
        return obj -> g.apply((MetricAttribution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricAttribution> {
        /**
         * <p>
         * The metric attribution's name.
         * </p>
         * 
         * @param name
         *        The metric attribution's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The metric attribution's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param metricAttributionArn
         *        The metric attribution's Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAttributionArn(String metricAttributionArn);

        /**
         * <p>
         * The metric attribution's dataset group Amazon Resource Name (ARN).
         * </p>
         * 
         * @param datasetGroupArn
         *        The metric attribution's dataset group Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The metric attribution's output configuration.
         * </p>
         * 
         * @param metricsOutputConfig
         *        The metric attribution's output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsOutputConfig(MetricAttributionOutput metricsOutputConfig);

        /**
         * <p>
         * The metric attribution's output configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricAttributionOutput.Builder} avoiding
         * the need to create one manually via {@link MetricAttributionOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricAttributionOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #metricsOutputConfig(MetricAttributionOutput)}.
         * 
         * @param metricsOutputConfig
         *        a consumer that will call methods on {@link MetricAttributionOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsOutputConfig(MetricAttributionOutput)
         */
        default Builder metricsOutputConfig(Consumer<MetricAttributionOutput.Builder> metricsOutputConfig) {
            return metricsOutputConfig(MetricAttributionOutput.builder().applyMutation(metricsOutputConfig).build());
        }

        /**
         * <p>
         * The metric attribution's status.
         * </p>
         * 
         * @param status
         *        The metric attribution's status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The metric attribution's creation date time.
         * </p>
         * 
         * @param creationDateTime
         *        The metric attribution's creation date time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The metric attribution's last updated date time.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The metric attribution's last updated date time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The metric attribution's failure reason.
         * </p>
         * 
         * @param failureReason
         *        The metric attribution's failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String metricAttributionArn;

        private String datasetGroupArn;

        private MetricAttributionOutput metricsOutputConfig;

        private String status;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricAttribution model) {
            name(model.name);
            metricAttributionArn(model.metricAttributionArn);
            datasetGroupArn(model.datasetGroupArn);
            metricsOutputConfig(model.metricsOutputConfig);
            status(model.status);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReason(model.failureReason);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMetricAttributionArn() {
            return metricAttributionArn;
        }

        public final void setMetricAttributionArn(String metricAttributionArn) {
            this.metricAttributionArn = metricAttributionArn;
        }

        @Override
        public final Builder metricAttributionArn(String metricAttributionArn) {
            this.metricAttributionArn = metricAttributionArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final MetricAttributionOutput.Builder getMetricsOutputConfig() {
            return metricsOutputConfig != null ? metricsOutputConfig.toBuilder() : null;
        }

        public final void setMetricsOutputConfig(MetricAttributionOutput.BuilderImpl metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig != null ? metricsOutputConfig.build() : null;
        }

        @Override
        public final Builder metricsOutputConfig(MetricAttributionOutput metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public MetricAttribution build() {
            return new MetricAttribution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
