/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.HyperParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CampaignConfig> {
    private static final SdkField<Map<String, String>> ITEM_EXPLORATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("itemExplorationConfig").getter(CampaignConfig.getter(CampaignConfig::itemExplorationConfig)).setter(CampaignConfig.setter(Builder::itemExplorationConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemExplorationConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_EXPLORATION_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> itemExplorationConfig;

    private CampaignConfig(BuilderImpl builder) {
        this.itemExplorationConfig = builder.itemExplorationConfig;
    }

    public final boolean hasItemExplorationConfig() {
        return this.itemExplorationConfig != null && !(this.itemExplorationConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> itemExplorationConfig() {
        return this.itemExplorationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemExplorationConfig() ? this.itemExplorationConfig() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignConfig)) {
            return false;
        }
        CampaignConfig other = (CampaignConfig)obj;
        return this.hasItemExplorationConfig() == other.hasItemExplorationConfig() && Objects.equals(this.itemExplorationConfig(), other.itemExplorationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CampaignConfig").add("ItemExplorationConfig", this.hasItemExplorationConfig() ? this.itemExplorationConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemExplorationConfig": {
                return Optional.ofNullable(clazz.cast(this.itemExplorationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignConfig, T> g) {
        return obj -> g.apply((CampaignConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> itemExplorationConfig = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignConfig model) {
            this.itemExplorationConfig(model.itemExplorationConfig);
        }

        public final Map<String, String> getItemExplorationConfig() {
            if (this.itemExplorationConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.itemExplorationConfig;
        }

        public final void setItemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
        }

        @Override
        public final Builder itemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
            return this;
        }

        public CampaignConfig build() {
            return new CampaignConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CampaignConfig> {
        public Builder itemExplorationConfig(Map<String, String> var1);
    }
}

