/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient;
import software.amazon.awssdk.services.personalize.internal.UserAgentUtils;
import software.amazon.awssdk.services.personalize.model.BatchInferenceJobSummary;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse;

public class ListBatchInferenceJobsPublisher
implements SdkPublisher<ListBatchInferenceJobsResponse> {
    private final PersonalizeAsyncClient client;
    private final ListBatchInferenceJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBatchInferenceJobsPublisher(PersonalizeAsyncClient client, ListBatchInferenceJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBatchInferenceJobsPublisher(PersonalizeAsyncClient client, ListBatchInferenceJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBatchInferenceJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBatchInferenceJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BatchInferenceJobSummary> batchInferenceJobs() {
        Function<ListBatchInferenceJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.batchInferenceJobs() != null) {
                return response.batchInferenceJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBatchInferenceJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBatchInferenceJobsResponseFetcher
    implements AsyncPageFetcher<ListBatchInferenceJobsResponse> {
        private ListBatchInferenceJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListBatchInferenceJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBatchInferenceJobsResponse> nextPage(ListBatchInferenceJobsResponse previousPage) {
            if (previousPage == null) {
                return ListBatchInferenceJobsPublisher.this.client.listBatchInferenceJobs(ListBatchInferenceJobsPublisher.this.firstRequest);
            }
            return ListBatchInferenceJobsPublisher.this.client.listBatchInferenceJobs((ListBatchInferenceJobsRequest)((Object)ListBatchInferenceJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

