/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the results of a query that retrieved the data for a standard metric that applies to an application,
 * campaign, or journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultRow implements SdkPojo, Serializable, ToCopyableBuilder<ResultRow.Builder, ResultRow> {
    private static final SdkField<List<ResultRowValue>> GROUPED_BYS_FIELD = SdkField
            .<List<ResultRowValue>> builder(MarshallingType.LIST)
            .memberName("GroupedBys")
            .getter(getter(ResultRow::groupedBys))
            .setter(setter(Builder::groupedBys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupedBys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResultRowValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultRowValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResultRowValue>> VALUES_FIELD = SdkField
            .<List<ResultRowValue>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(ResultRow::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResultRowValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultRowValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPED_BYS_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ResultRowValue> groupedBys;

    private final List<ResultRowValue> values;

    private ResultRow(BuilderImpl builder) {
        this.groupedBys = builder.groupedBys;
        this.values = builder.values;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupedBys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupedBys() {
        return groupedBys != null && !(groupedBys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that defines the field and field values that were used to group data in a result set that
     * contains multiple results. This value is null if the data in a result set isn’t grouped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupedBys} method.
     * </p>
     * 
     * @return An array of objects that defines the field and field values that were used to group data in a result set
     *         that contains multiple results. This value is null if the data in a result set isn’t grouped.
     */
    public final List<ResultRowValue> groupedBys() {
        return groupedBys;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that provides pre-aggregated values for a standard metric that applies to an application,
     * campaign, or journey.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return An array of objects that provides pre-aggregated values for a standard metric that applies to an
     *         application, campaign, or journey.
     */
    public final List<ResultRowValue> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupedBys() ? groupedBys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultRow)) {
            return false;
        }
        ResultRow other = (ResultRow) obj;
        return hasGroupedBys() == other.hasGroupedBys() && Objects.equals(groupedBys(), other.groupedBys())
                && hasValues() == other.hasValues() && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultRow").add("GroupedBys", hasGroupedBys() ? groupedBys() : null)
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupedBys":
            return Optional.ofNullable(clazz.cast(groupedBys()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultRow, T> g) {
        return obj -> g.apply((ResultRow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultRow> {
        /**
         * <p>
         * An array of objects that defines the field and field values that were used to group data in a result set that
         * contains multiple results. This value is null if the data in a result set isn’t grouped.
         * </p>
         * 
         * @param groupedBys
         *        An array of objects that defines the field and field values that were used to group data in a result
         *        set that contains multiple results. This value is null if the data in a result set isn’t grouped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedBys(Collection<ResultRowValue> groupedBys);

        /**
         * <p>
         * An array of objects that defines the field and field values that were used to group data in a result set that
         * contains multiple results. This value is null if the data in a result set isn’t grouped.
         * </p>
         * 
         * @param groupedBys
         *        An array of objects that defines the field and field values that were used to group data in a result
         *        set that contains multiple results. This value is null if the data in a result set isn’t grouped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedBys(ResultRowValue... groupedBys);

        /**
         * <p>
         * An array of objects that defines the field and field values that were used to group data in a result set that
         * contains multiple results. This value is null if the data in a result set isn’t grouped.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.ResultRowValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.ResultRowValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.ResultRowValue.Builder#build()} is called immediately
         * and its result is passed to {@link #groupedBys(List<ResultRowValue>)}.
         * 
         * @param groupedBys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.ResultRowValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupedBys(java.util.Collection<ResultRowValue>)
         */
        Builder groupedBys(Consumer<ResultRowValue.Builder>... groupedBys);

        /**
         * <p>
         * An array of objects that provides pre-aggregated values for a standard metric that applies to an application,
         * campaign, or journey.
         * </p>
         * 
         * @param values
         *        An array of objects that provides pre-aggregated values for a standard metric that applies to an
         *        application, campaign, or journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<ResultRowValue> values);

        /**
         * <p>
         * An array of objects that provides pre-aggregated values for a standard metric that applies to an application,
         * campaign, or journey.
         * </p>
         * 
         * @param values
         *        An array of objects that provides pre-aggregated values for a standard metric that applies to an
         *        application, campaign, or journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(ResultRowValue... values);

        /**
         * <p>
         * An array of objects that provides pre-aggregated values for a standard metric that applies to an application,
         * campaign, or journey.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.ResultRowValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.ResultRowValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.ResultRowValue.Builder#build()} is called immediately
         * and its result is passed to {@link #values(List<ResultRowValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.ResultRowValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<ResultRowValue>)
         */
        Builder values(Consumer<ResultRowValue.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private List<ResultRowValue> groupedBys = DefaultSdkAutoConstructList.getInstance();

        private List<ResultRowValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultRow model) {
            groupedBys(model.groupedBys);
            values(model.values);
        }

        public final List<ResultRowValue.Builder> getGroupedBys() {
            List<ResultRowValue.Builder> result = ListOfResultRowValueCopier.copyToBuilder(this.groupedBys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedBys(Collection<ResultRowValue.BuilderImpl> groupedBys) {
            this.groupedBys = ListOfResultRowValueCopier.copyFromBuilder(groupedBys);
        }

        @Override
        public final Builder groupedBys(Collection<ResultRowValue> groupedBys) {
            this.groupedBys = ListOfResultRowValueCopier.copy(groupedBys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedBys(ResultRowValue... groupedBys) {
            groupedBys(Arrays.asList(groupedBys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedBys(Consumer<ResultRowValue.Builder>... groupedBys) {
            groupedBys(Stream.of(groupedBys).map(c -> ResultRowValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResultRowValue.Builder> getValues() {
            List<ResultRowValue.Builder> result = ListOfResultRowValueCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<ResultRowValue.BuilderImpl> values) {
            this.values = ListOfResultRowValueCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<ResultRowValue> values) {
            this.values = ListOfResultRowValueCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(ResultRowValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<ResultRowValue.Builder>... values) {
            values(Stream.of(values).map(c -> ResultRowValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResultRow build() {
            return new ResultRow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
