/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRecommenderConfigurationRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, DeleteRecommenderConfigurationRequest> {
    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderId").getter(DeleteRecommenderConfigurationRequest.getter(DeleteRecommenderConfigurationRequest::recommenderId)).setter(DeleteRecommenderConfigurationRequest.setter(Builder::recommenderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("recommender-id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteRecommenderConfigurationRequest.memberNameToFieldInitializer();
    private final String recommenderId;

    private DeleteRecommenderConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.recommenderId = builder.recommenderId;
    }

    public final String recommenderId() {
        return this.recommenderId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecommenderConfigurationRequest)) {
            return false;
        }
        DeleteRecommenderConfigurationRequest other = (DeleteRecommenderConfigurationRequest)((Object)obj);
        return Objects.equals(this.recommenderId(), other.recommenderId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRecommenderConfigurationRequest").add("RecommenderId", (Object)this.recommenderId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommenderId": {
                return Optional.ofNullable(clazz.cast(this.recommenderId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("recommender-id", RECOMMENDER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRecommenderConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteRecommenderConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String recommenderId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRecommenderConfigurationRequest model) {
            super(model);
            this.recommenderId(model.recommenderId);
        }

        public final String getRecommenderId() {
            return this.recommenderId;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        @Override
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRecommenderConfigurationRequest build() {
            return new DeleteRecommenderConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRecommenderConfigurationRequest> {
        public Builder recommenderId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

