/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.MessageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JourneySMSMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JourneySMSMessage> {
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageType").getter(JourneySMSMessage.getter(JourneySMSMessage::messageTypeAsString)).setter(JourneySMSMessage.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final SdkField<String> ORIGINATION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationNumber").getter(JourneySMSMessage.getter(JourneySMSMessage::originationNumber)).setter(JourneySMSMessage.setter(Builder::originationNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationNumber").build()}).build();
    private static final SdkField<String> SENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderId").getter(JourneySMSMessage.getter(JourneySMSMessage::senderId)).setter(JourneySMSMessage.setter(Builder::senderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityId").getter(JourneySMSMessage.getter(JourneySMSMessage::entityId)).setter(JourneySMSMessage.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(JourneySMSMessage.getter(JourneySMSMessage::templateId)).setter(JourneySMSMessage.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TYPE_FIELD, ORIGINATION_NUMBER_FIELD, SENDER_ID_FIELD, ENTITY_ID_FIELD, TEMPLATE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JourneySMSMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String messageType;
    private final String originationNumber;
    private final String senderId;
    private final String entityId;
    private final String templateId;

    private JourneySMSMessage(BuilderImpl builder) {
        this.messageType = builder.messageType;
        this.originationNumber = builder.originationNumber;
        this.senderId = builder.senderId;
        this.entityId = builder.entityId;
        this.templateId = builder.templateId;
    }

    public final MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public final String originationNumber() {
        return this.originationNumber;
    }

    public final String senderId() {
        return this.senderId;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String templateId() {
        return this.templateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneySMSMessage)) {
            return false;
        }
        JourneySMSMessage other = (JourneySMSMessage)obj;
        return Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && Objects.equals(this.originationNumber(), other.originationNumber()) && Objects.equals(this.senderId(), other.senderId()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.templateId(), other.templateId());
    }

    public final String toString() {
        return ToString.builder((String)"JourneySMSMessage").add("MessageType", (Object)this.messageTypeAsString()).add("OriginationNumber", (Object)this.originationNumber()).add("SenderId", (Object)this.senderId()).add("EntityId", (Object)this.entityId()).add("TemplateId", (Object)this.templateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "OriginationNumber": {
                return Optional.ofNullable(clazz.cast(this.originationNumber()));
            }
            case "SenderId": {
                return Optional.ofNullable(clazz.cast(this.senderId()));
            }
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MessageType", MESSAGE_TYPE_FIELD);
        map.put("OriginationNumber", ORIGINATION_NUMBER_FIELD);
        map.put("SenderId", SENDER_ID_FIELD);
        map.put("EntityId", ENTITY_ID_FIELD);
        map.put("TemplateId", TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JourneySMSMessage, T> g) {
        return obj -> g.apply((JourneySMSMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageType;
        private String originationNumber;
        private String senderId;
        private String entityId;
        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneySMSMessage model) {
            this.messageType(model.messageType);
            this.originationNumber(model.originationNumber);
            this.senderId(model.senderId);
            this.entityId(model.entityId);
            this.templateId(model.templateId);
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final String getOriginationNumber() {
            return this.originationNumber;
        }

        public final void setOriginationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
        }

        @Override
        public final Builder originationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
            return this;
        }

        public final String getSenderId() {
            return this.senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public JourneySMSMessage build() {
            return new JourneySMSMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JourneySMSMessage> {
        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder originationNumber(String var1);

        public Builder senderId(String var1);

        public Builder entityId(String var1);

        public Builder templateId(String var1);
    }
}

