/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ListOfMultiConditionalBranchCopier;
import software.amazon.awssdk.services.pinpoint.model.MultiConditionalBranch;
import software.amazon.awssdk.services.pinpoint.model.WaitTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiConditionalSplitActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiConditionalSplitActivity> {
    private static final SdkField<List<MultiConditionalBranch>> BRANCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Branches").getter(MultiConditionalSplitActivity.getter(MultiConditionalSplitActivity::branches)).setter(MultiConditionalSplitActivity.setter(Builder::branches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiConditionalBranch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultActivity").getter(MultiConditionalSplitActivity.getter(MultiConditionalSplitActivity::defaultActivity)).setter(MultiConditionalSplitActivity.setter(Builder::defaultActivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultActivity").build()}).build();
    private static final SdkField<WaitTime> EVALUATION_WAIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationWaitTime").getter(MultiConditionalSplitActivity.getter(MultiConditionalSplitActivity::evaluationWaitTime)).setter(MultiConditionalSplitActivity.setter(Builder::evaluationWaitTime)).constructor(WaitTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationWaitTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCHES_FIELD, DEFAULT_ACTIVITY_FIELD, EVALUATION_WAIT_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MultiConditionalSplitActivity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MultiConditionalBranch> branches;
    private final String defaultActivity;
    private final WaitTime evaluationWaitTime;

    private MultiConditionalSplitActivity(BuilderImpl builder) {
        this.branches = builder.branches;
        this.defaultActivity = builder.defaultActivity;
        this.evaluationWaitTime = builder.evaluationWaitTime;
    }

    public final boolean hasBranches() {
        return this.branches != null && !(this.branches instanceof SdkAutoConstructList);
    }

    public final List<MultiConditionalBranch> branches() {
        return this.branches;
    }

    public final String defaultActivity() {
        return this.defaultActivity;
    }

    public final WaitTime evaluationWaitTime() {
        return this.evaluationWaitTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBranches() ? this.branches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationWaitTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiConditionalSplitActivity)) {
            return false;
        }
        MultiConditionalSplitActivity other = (MultiConditionalSplitActivity)obj;
        return this.hasBranches() == other.hasBranches() && Objects.equals(this.branches(), other.branches()) && Objects.equals(this.defaultActivity(), other.defaultActivity()) && Objects.equals(this.evaluationWaitTime(), other.evaluationWaitTime());
    }

    public final String toString() {
        return ToString.builder((String)"MultiConditionalSplitActivity").add("Branches", this.hasBranches() ? this.branches() : null).add("DefaultActivity", (Object)this.defaultActivity()).add("EvaluationWaitTime", (Object)this.evaluationWaitTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Branches": {
                return Optional.ofNullable(clazz.cast(this.branches()));
            }
            case "DefaultActivity": {
                return Optional.ofNullable(clazz.cast(this.defaultActivity()));
            }
            case "EvaluationWaitTime": {
                return Optional.ofNullable(clazz.cast(this.evaluationWaitTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Branches", BRANCHES_FIELD);
        map.put("DefaultActivity", DEFAULT_ACTIVITY_FIELD);
        map.put("EvaluationWaitTime", EVALUATION_WAIT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiConditionalSplitActivity, T> g) {
        return obj -> g.apply((MultiConditionalSplitActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MultiConditionalBranch> branches = DefaultSdkAutoConstructList.getInstance();
        private String defaultActivity;
        private WaitTime evaluationWaitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiConditionalSplitActivity model) {
            this.branches(model.branches);
            this.defaultActivity(model.defaultActivity);
            this.evaluationWaitTime(model.evaluationWaitTime);
        }

        public final List<MultiConditionalBranch.Builder> getBranches() {
            List<MultiConditionalBranch.Builder> result = ListOfMultiConditionalBranchCopier.copyToBuilder(this.branches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBranches(Collection<MultiConditionalBranch.BuilderImpl> branches) {
            this.branches = ListOfMultiConditionalBranchCopier.copyFromBuilder(branches);
        }

        @Override
        public final Builder branches(Collection<MultiConditionalBranch> branches) {
            this.branches = ListOfMultiConditionalBranchCopier.copy(branches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(MultiConditionalBranch ... branches) {
            this.branches(Arrays.asList(branches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(Consumer<MultiConditionalBranch.Builder> ... branches) {
            this.branches(Stream.of(branches).map(c -> (MultiConditionalBranch)((MultiConditionalBranch.Builder)MultiConditionalBranch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultActivity() {
            return this.defaultActivity;
        }

        public final void setDefaultActivity(String defaultActivity) {
            this.defaultActivity = defaultActivity;
        }

        @Override
        public final Builder defaultActivity(String defaultActivity) {
            this.defaultActivity = defaultActivity;
            return this;
        }

        public final WaitTime.Builder getEvaluationWaitTime() {
            return this.evaluationWaitTime != null ? this.evaluationWaitTime.toBuilder() : null;
        }

        public final void setEvaluationWaitTime(WaitTime.BuilderImpl evaluationWaitTime) {
            this.evaluationWaitTime = evaluationWaitTime != null ? evaluationWaitTime.build() : null;
        }

        @Override
        public final Builder evaluationWaitTime(WaitTime evaluationWaitTime) {
            this.evaluationWaitTime = evaluationWaitTime;
            return this;
        }

        public MultiConditionalSplitActivity build() {
            return new MultiConditionalSplitActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiConditionalSplitActivity> {
        public Builder branches(Collection<MultiConditionalBranch> var1);

        public Builder branches(MultiConditionalBranch ... var1);

        public Builder branches(Consumer<MultiConditionalBranch.Builder> ... var1);

        public Builder defaultActivity(String var1);

        public Builder evaluationWaitTime(WaitTime var1);

        default public Builder evaluationWaitTime(Consumer<WaitTime.Builder> evaluationWaitTime) {
            return this.evaluationWaitTime((WaitTime)((WaitTime.Builder)WaitTime.builder().applyMutation(evaluationWaitTime)).build());
        }
    }
}

