/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.Body;
import software.amazon.awssdk.services.pinpointemail.model.Content;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Message
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Message> {
    private static final SdkField<Content> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subject").getter(Message.getter(Message::subject)).setter(Message.setter(Builder::subject)).constructor(Content::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<Body> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Body").getter(Message.getter(Message::body)).setter(Message.setter(Builder::body)).constructor(Body::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, BODY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Content subject;
    private final Body body;

    private Message(BuilderImpl builder) {
        this.subject = builder.subject;
        this.body = builder.body;
    }

    public final Content subject() {
        return this.subject;
    }

    public final Body body() {
        return this.body;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.subject(), other.subject()) && Objects.equals(this.body(), other.body());
    }

    public final String toString() {
        return ToString.builder((String)"Message").add("Subject", (Object)this.subject()).add("Body", (Object)this.body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Content subject;
        private Body body;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.subject(model.subject);
            this.body(model.body);
        }

        public final Content.Builder getSubject() {
            return this.subject != null ? this.subject.toBuilder() : null;
        }

        public final void setSubject(Content.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        @Override
        public final Builder subject(Content subject) {
            this.subject = subject;
            return this;
        }

        public final Body.Builder getBody() {
            return this.body != null ? this.body.toBuilder() : null;
        }

        public final void setBody(Body.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(Body body) {
            this.body = body;
            return this;
        }

        public Message build() {
            return new Message(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Message> {
        public Builder subject(Content var1);

        default public Builder subject(Consumer<Content.Builder> subject) {
            return this.subject((Content)((Content.Builder)Content.builder().applyMutation(subject)).build());
        }

        public Builder body(Body var1);

        default public Builder body(Consumer<Body.Builder> body) {
            return this.body((Body)((Body.Builder)Body.builder().applyMutation(body)).build());
        }
    }
}

