/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.pinpointsmsvoicev2.endpoints.PinpointSmsVoiceV2EndpointProvider;

/**
 * This includes configuration specific to Amazon Pinpoint SMS Voice V2 that is supported by both
 * {@link PinpointSmsVoiceV2ClientBuilder} and {@link PinpointSmsVoiceV2AsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
public interface PinpointSmsVoiceV2BaseClientBuilder<B extends PinpointSmsVoiceV2BaseClientBuilder<B, C>, C> extends
        AwsClientBuilder<B, C> {
    /**
     * Set the {@link PinpointSmsVoiceV2EndpointProvider} implementation that will be used by the client to determine
     * the endpoint for each request. This is optional; if none is provided a default implementation will be used the
     * SDK.
     */
    default B endpointProvider(PinpointSmsVoiceV2EndpointProvider endpointProvider) {
        throw new UnsupportedOperationException();
    }
}
