/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldDefinition;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistrationFieldDefinitionsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeRegistrationFieldDefinitionsResponse> {
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationType").getter(DescribeRegistrationFieldDefinitionsResponse.getter(DescribeRegistrationFieldDefinitionsResponse::registrationType)).setter(DescribeRegistrationFieldDefinitionsResponse.setter(Builder::registrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()}).build();
    private static final SdkField<List<RegistrationFieldDefinition>> REGISTRATION_FIELD_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegistrationFieldDefinitions").getter(DescribeRegistrationFieldDefinitionsResponse.getter(DescribeRegistrationFieldDefinitionsResponse::registrationFieldDefinitions)).setter(DescribeRegistrationFieldDefinitionsResponse.setter(Builder::registrationFieldDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationFieldDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationFieldDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegistrationFieldDefinitionsResponse.getter(DescribeRegistrationFieldDefinitionsResponse::nextToken)).setter(DescribeRegistrationFieldDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TYPE_FIELD, REGISTRATION_FIELD_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));
    private final String registrationType;
    private final List<RegistrationFieldDefinition> registrationFieldDefinitions;
    private final String nextToken;

    private DescribeRegistrationFieldDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.registrationType = builder.registrationType;
        this.registrationFieldDefinitions = builder.registrationFieldDefinitions;
        this.nextToken = builder.nextToken;
    }

    public final String registrationType() {
        return this.registrationType;
    }

    public final boolean hasRegistrationFieldDefinitions() {
        return this.registrationFieldDefinitions != null && !(this.registrationFieldDefinitions instanceof SdkAutoConstructList);
    }

    public final List<RegistrationFieldDefinition> registrationFieldDefinitions() {
        return this.registrationFieldDefinitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistrationFieldDefinitions() ? this.registrationFieldDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationFieldDefinitionsResponse)) {
            return false;
        }
        DescribeRegistrationFieldDefinitionsResponse other = (DescribeRegistrationFieldDefinitionsResponse)((Object)obj);
        return Objects.equals(this.registrationType(), other.registrationType()) && this.hasRegistrationFieldDefinitions() == other.hasRegistrationFieldDefinitions() && Objects.equals(this.registrationFieldDefinitions(), other.registrationFieldDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegistrationFieldDefinitionsResponse").add("RegistrationType", (Object)this.registrationType()).add("RegistrationFieldDefinitions", this.hasRegistrationFieldDefinitions() ? this.registrationFieldDefinitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationType": {
                return Optional.ofNullable(clazz.cast(this.registrationType()));
            }
            case "RegistrationFieldDefinitions": {
                return Optional.ofNullable(clazz.cast(this.registrationFieldDefinitions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationFieldDefinitionsResponse, T> g) {
        return obj -> g.apply((DescribeRegistrationFieldDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String registrationType;
        private List<RegistrationFieldDefinition> registrationFieldDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationFieldDefinitionsResponse model) {
            super(model);
            this.registrationType(model.registrationType);
            this.registrationFieldDefinitions(model.registrationFieldDefinitions);
            this.nextToken(model.nextToken);
        }

        public final String getRegistrationType() {
            return this.registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final List<RegistrationFieldDefinition.Builder> getRegistrationFieldDefinitions() {
            List<RegistrationFieldDefinition.Builder> result = RegistrationFieldDefinitionListCopier.copyToBuilder(this.registrationFieldDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationFieldDefinitions(Collection<RegistrationFieldDefinition.BuilderImpl> registrationFieldDefinitions) {
            this.registrationFieldDefinitions = RegistrationFieldDefinitionListCopier.copyFromBuilder(registrationFieldDefinitions);
        }

        @Override
        public final Builder registrationFieldDefinitions(Collection<RegistrationFieldDefinition> registrationFieldDefinitions) {
            this.registrationFieldDefinitions = RegistrationFieldDefinitionListCopier.copy(registrationFieldDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationFieldDefinitions(RegistrationFieldDefinition ... registrationFieldDefinitions) {
            this.registrationFieldDefinitions(Arrays.asList(registrationFieldDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationFieldDefinitions(Consumer<RegistrationFieldDefinition.Builder> ... registrationFieldDefinitions) {
            this.registrationFieldDefinitions(Stream.of(registrationFieldDefinitions).map(c -> (RegistrationFieldDefinition)((RegistrationFieldDefinition.Builder)RegistrationFieldDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistrationFieldDefinitionsResponse build() {
            return new DescribeRegistrationFieldDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistrationFieldDefinitionsResponse> {
        public Builder registrationType(String var1);

        public Builder registrationFieldDefinitions(Collection<RegistrationFieldDefinition> var1);

        public Builder registrationFieldDefinitions(RegistrationFieldDefinition ... var1);

        public Builder registrationFieldDefinitions(Consumer<RegistrationFieldDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

