/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationDeniedReasonInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationDeniedReasonInformationListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationVersionStatus;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationVersionStatusHistory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistrationVersionInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistrationVersionInformation> {
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(RegistrationVersionInformation.getter(RegistrationVersionInformation::versionNumber)).setter(RegistrationVersionInformation.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<String> REGISTRATION_VERSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationVersionStatus").getter(RegistrationVersionInformation.getter(RegistrationVersionInformation::registrationVersionStatusAsString)).setter(RegistrationVersionInformation.setter(Builder::registrationVersionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationVersionStatus").build()}).build();
    private static final SdkField<RegistrationVersionStatusHistory> REGISTRATION_VERSION_STATUS_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegistrationVersionStatusHistory").getter(RegistrationVersionInformation.getter(RegistrationVersionInformation::registrationVersionStatusHistory)).setter(RegistrationVersionInformation.setter(Builder::registrationVersionStatusHistory)).constructor(RegistrationVersionStatusHistory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationVersionStatusHistory").build()}).build();
    private static final SdkField<List<RegistrationDeniedReasonInformation>> DENIED_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeniedReasons").getter(RegistrationVersionInformation.getter(RegistrationVersionInformation::deniedReasons)).setter(RegistrationVersionInformation.setter(Builder::deniedReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeniedReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationDeniedReasonInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_NUMBER_FIELD, REGISTRATION_VERSION_STATUS_FIELD, REGISTRATION_VERSION_STATUS_HISTORY_FIELD, DENIED_REASONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long versionNumber;
    private final String registrationVersionStatus;
    private final RegistrationVersionStatusHistory registrationVersionStatusHistory;
    private final List<RegistrationDeniedReasonInformation> deniedReasons;

    private RegistrationVersionInformation(BuilderImpl builder) {
        this.versionNumber = builder.versionNumber;
        this.registrationVersionStatus = builder.registrationVersionStatus;
        this.registrationVersionStatusHistory = builder.registrationVersionStatusHistory;
        this.deniedReasons = builder.deniedReasons;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public final RegistrationVersionStatus registrationVersionStatus() {
        return RegistrationVersionStatus.fromValue(this.registrationVersionStatus);
    }

    public final String registrationVersionStatusAsString() {
        return this.registrationVersionStatus;
    }

    public final RegistrationVersionStatusHistory registrationVersionStatusHistory() {
        return this.registrationVersionStatusHistory;
    }

    public final boolean hasDeniedReasons() {
        return this.deniedReasons != null && !(this.deniedReasons instanceof SdkAutoConstructList);
    }

    public final List<RegistrationDeniedReasonInformation> deniedReasons() {
        return this.deniedReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationVersionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationVersionStatusHistory());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeniedReasons() ? this.deniedReasons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationVersionInformation)) {
            return false;
        }
        RegistrationVersionInformation other = (RegistrationVersionInformation)obj;
        return Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.registrationVersionStatusAsString(), other.registrationVersionStatusAsString()) && Objects.equals(this.registrationVersionStatusHistory(), other.registrationVersionStatusHistory()) && this.hasDeniedReasons() == other.hasDeniedReasons() && Objects.equals(this.deniedReasons(), other.deniedReasons());
    }

    public final String toString() {
        return ToString.builder((String)"RegistrationVersionInformation").add("VersionNumber", (Object)this.versionNumber()).add("RegistrationVersionStatus", (Object)this.registrationVersionStatusAsString()).add("RegistrationVersionStatusHistory", (Object)this.registrationVersionStatusHistory()).add("DeniedReasons", this.hasDeniedReasons() ? this.deniedReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "RegistrationVersionStatus": {
                return Optional.ofNullable(clazz.cast(this.registrationVersionStatusAsString()));
            }
            case "RegistrationVersionStatusHistory": {
                return Optional.ofNullable(clazz.cast(this.registrationVersionStatusHistory()));
            }
            case "DeniedReasons": {
                return Optional.ofNullable(clazz.cast(this.deniedReasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegistrationVersionInformation, T> g) {
        return obj -> g.apply((RegistrationVersionInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long versionNumber;
        private String registrationVersionStatus;
        private RegistrationVersionStatusHistory registrationVersionStatusHistory;
        private List<RegistrationDeniedReasonInformation> deniedReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationVersionInformation model) {
            this.versionNumber(model.versionNumber);
            this.registrationVersionStatus(model.registrationVersionStatus);
            this.registrationVersionStatusHistory(model.registrationVersionStatusHistory);
            this.deniedReasons(model.deniedReasons);
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getRegistrationVersionStatus() {
            return this.registrationVersionStatus;
        }

        public final void setRegistrationVersionStatus(String registrationVersionStatus) {
            this.registrationVersionStatus = registrationVersionStatus;
        }

        @Override
        public final Builder registrationVersionStatus(String registrationVersionStatus) {
            this.registrationVersionStatus = registrationVersionStatus;
            return this;
        }

        @Override
        public final Builder registrationVersionStatus(RegistrationVersionStatus registrationVersionStatus) {
            this.registrationVersionStatus(registrationVersionStatus == null ? null : registrationVersionStatus.toString());
            return this;
        }

        public final RegistrationVersionStatusHistory.Builder getRegistrationVersionStatusHistory() {
            return this.registrationVersionStatusHistory != null ? this.registrationVersionStatusHistory.toBuilder() : null;
        }

        public final void setRegistrationVersionStatusHistory(RegistrationVersionStatusHistory.BuilderImpl registrationVersionStatusHistory) {
            this.registrationVersionStatusHistory = registrationVersionStatusHistory != null ? registrationVersionStatusHistory.build() : null;
        }

        @Override
        public final Builder registrationVersionStatusHistory(RegistrationVersionStatusHistory registrationVersionStatusHistory) {
            this.registrationVersionStatusHistory = registrationVersionStatusHistory;
            return this;
        }

        public final List<RegistrationDeniedReasonInformation.Builder> getDeniedReasons() {
            List<RegistrationDeniedReasonInformation.Builder> result = RegistrationDeniedReasonInformationListCopier.copyToBuilder(this.deniedReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeniedReasons(Collection<RegistrationDeniedReasonInformation.BuilderImpl> deniedReasons) {
            this.deniedReasons = RegistrationDeniedReasonInformationListCopier.copyFromBuilder(deniedReasons);
        }

        @Override
        public final Builder deniedReasons(Collection<RegistrationDeniedReasonInformation> deniedReasons) {
            this.deniedReasons = RegistrationDeniedReasonInformationListCopier.copy(deniedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deniedReasons(RegistrationDeniedReasonInformation ... deniedReasons) {
            this.deniedReasons(Arrays.asList(deniedReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deniedReasons(Consumer<RegistrationDeniedReasonInformation.Builder> ... deniedReasons) {
            this.deniedReasons(Stream.of(deniedReasons).map(c -> (RegistrationDeniedReasonInformation)((RegistrationDeniedReasonInformation.Builder)RegistrationDeniedReasonInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RegistrationVersionInformation build() {
            return new RegistrationVersionInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistrationVersionInformation> {
        public Builder versionNumber(Long var1);

        public Builder registrationVersionStatus(String var1);

        public Builder registrationVersionStatus(RegistrationVersionStatus var1);

        public Builder registrationVersionStatusHistory(RegistrationVersionStatusHistory var1);

        default public Builder registrationVersionStatusHistory(Consumer<RegistrationVersionStatusHistory.Builder> registrationVersionStatusHistory) {
            return this.registrationVersionStatusHistory((RegistrationVersionStatusHistory)((RegistrationVersionStatusHistory.Builder)RegistrationVersionStatusHistory.builder().applyMutation(registrationVersionStatusHistory)).build());
        }

        public Builder deniedReasons(Collection<RegistrationDeniedReasonInformation> var1);

        public Builder deniedReasons(RegistrationDeniedReasonInformation ... var1);

        public Builder deniedReasons(Consumer<RegistrationDeniedReasonInformation.Builder> ... var1);
    }
}

