/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationRuleSetNumberOverride;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationRuleSetNumberOverrideListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProtectConfigurationRuleSetNumberOverridesResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, ListProtectConfigurationRuleSetNumberOverridesResponse> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationArn").getter(ListProtectConfigurationRuleSetNumberOverridesResponse.getter(ListProtectConfigurationRuleSetNumberOverridesResponse::protectConfigurationArn)).setter(ListProtectConfigurationRuleSetNumberOverridesResponse.setter(Builder::protectConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationArn").build()}).build();
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationId").getter(ListProtectConfigurationRuleSetNumberOverridesResponse.getter(ListProtectConfigurationRuleSetNumberOverridesResponse::protectConfigurationId)).setter(ListProtectConfigurationRuleSetNumberOverridesResponse.setter(Builder::protectConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build()}).build();
    private static final SdkField<List<ProtectConfigurationRuleSetNumberOverride>> RULE_SET_NUMBER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleSetNumberOverrides").getter(ListProtectConfigurationRuleSetNumberOverridesResponse.getter(ListProtectConfigurationRuleSetNumberOverridesResponse::ruleSetNumberOverrides)).setter(ListProtectConfigurationRuleSetNumberOverridesResponse.setter(Builder::ruleSetNumberOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetNumberOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectConfigurationRuleSetNumberOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProtectConfigurationRuleSetNumberOverridesResponse.getter(ListProtectConfigurationRuleSetNumberOverridesResponse::nextToken)).setter(ListProtectConfigurationRuleSetNumberOverridesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECT_CONFIGURATION_ARN_FIELD, PROTECT_CONFIGURATION_ID_FIELD, RULE_SET_NUMBER_OVERRIDES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProtectConfigurationRuleSetNumberOverridesResponse.memberNameToFieldInitializer();
    private final String protectConfigurationArn;
    private final String protectConfigurationId;
    private final List<ProtectConfigurationRuleSetNumberOverride> ruleSetNumberOverrides;
    private final String nextToken;

    private ListProtectConfigurationRuleSetNumberOverridesResponse(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationArn = builder.protectConfigurationArn;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.ruleSetNumberOverrides = builder.ruleSetNumberOverrides;
        this.nextToken = builder.nextToken;
    }

    public final String protectConfigurationArn() {
        return this.protectConfigurationArn;
    }

    public final String protectConfigurationId() {
        return this.protectConfigurationId;
    }

    public final boolean hasRuleSetNumberOverrides() {
        return this.ruleSetNumberOverrides != null && !(this.ruleSetNumberOverrides instanceof SdkAutoConstructList);
    }

    public final List<ProtectConfigurationRuleSetNumberOverride> ruleSetNumberOverrides() {
        return this.ruleSetNumberOverrides;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleSetNumberOverrides() ? this.ruleSetNumberOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectConfigurationRuleSetNumberOverridesResponse)) {
            return false;
        }
        ListProtectConfigurationRuleSetNumberOverridesResponse other = (ListProtectConfigurationRuleSetNumberOverridesResponse)((Object)obj);
        return Objects.equals(this.protectConfigurationArn(), other.protectConfigurationArn()) && Objects.equals(this.protectConfigurationId(), other.protectConfigurationId()) && this.hasRuleSetNumberOverrides() == other.hasRuleSetNumberOverrides() && Objects.equals(this.ruleSetNumberOverrides(), other.ruleSetNumberOverrides()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProtectConfigurationRuleSetNumberOverridesResponse").add("ProtectConfigurationArn", (Object)this.protectConfigurationArn()).add("ProtectConfigurationId", (Object)this.protectConfigurationId()).add("RuleSetNumberOverrides", this.hasRuleSetNumberOverrides() ? this.ruleSetNumberOverrides() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationArn()));
            }
            case "ProtectConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationId()));
            }
            case "RuleSetNumberOverrides": {
                return Optional.ofNullable(clazz.cast(this.ruleSetNumberOverrides()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProtectConfigurationArn", PROTECT_CONFIGURATION_ARN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("RuleSetNumberOverrides", RULE_SET_NUMBER_OVERRIDES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProtectConfigurationRuleSetNumberOverridesResponse, T> g) {
        return obj -> g.apply((ListProtectConfigurationRuleSetNumberOverridesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String protectConfigurationArn;
        private String protectConfigurationId;
        private List<ProtectConfigurationRuleSetNumberOverride> ruleSetNumberOverrides = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectConfigurationRuleSetNumberOverridesResponse model) {
            super(model);
            this.protectConfigurationArn(model.protectConfigurationArn);
            this.protectConfigurationId(model.protectConfigurationId);
            this.ruleSetNumberOverrides(model.ruleSetNumberOverrides);
            this.nextToken(model.nextToken);
        }

        public final String getProtectConfigurationArn() {
            return this.protectConfigurationArn;
        }

        public final void setProtectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
        }

        @Override
        public final Builder protectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
            return this;
        }

        public final String getProtectConfigurationId() {
            return this.protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final List<ProtectConfigurationRuleSetNumberOverride.Builder> getRuleSetNumberOverrides() {
            List<ProtectConfigurationRuleSetNumberOverride.Builder> result = ProtectConfigurationRuleSetNumberOverrideListCopier.copyToBuilder(this.ruleSetNumberOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleSetNumberOverrides(Collection<ProtectConfigurationRuleSetNumberOverride.BuilderImpl> ruleSetNumberOverrides) {
            this.ruleSetNumberOverrides = ProtectConfigurationRuleSetNumberOverrideListCopier.copyFromBuilder(ruleSetNumberOverrides);
        }

        @Override
        public final Builder ruleSetNumberOverrides(Collection<ProtectConfigurationRuleSetNumberOverride> ruleSetNumberOverrides) {
            this.ruleSetNumberOverrides = ProtectConfigurationRuleSetNumberOverrideListCopier.copy(ruleSetNumberOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetNumberOverrides(ProtectConfigurationRuleSetNumberOverride ... ruleSetNumberOverrides) {
            this.ruleSetNumberOverrides(Arrays.asList(ruleSetNumberOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetNumberOverrides(Consumer<ProtectConfigurationRuleSetNumberOverride.Builder> ... ruleSetNumberOverrides) {
            this.ruleSetNumberOverrides(Stream.of(ruleSetNumberOverrides).map(c -> (ProtectConfigurationRuleSetNumberOverride)((ProtectConfigurationRuleSetNumberOverride.Builder)ProtectConfigurationRuleSetNumberOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProtectConfigurationRuleSetNumberOverridesResponse build() {
            return new ListProtectConfigurationRuleSetNumberOverridesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProtectConfigurationRuleSetNumberOverridesResponse> {
        public Builder protectConfigurationArn(String var1);

        public Builder protectConfigurationId(String var1);

        public Builder ruleSetNumberOverrides(Collection<ProtectConfigurationRuleSetNumberOverride> var1);

        public Builder ruleSetNumberOverrides(ProtectConfigurationRuleSetNumberOverride ... var1);

        public Builder ruleSetNumberOverrides(Consumer<ProtectConfigurationRuleSetNumberOverride.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

