/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventTypeListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SnsDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventDestinationRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, UpdateEventDestinationRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(UpdateEventDestinationRequest.getter(UpdateEventDestinationRequest::configurationSetName)).setter(UpdateEventDestinationRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<String> EVENT_DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDestinationName").getter(UpdateEventDestinationRequest.getter(UpdateEventDestinationRequest::eventDestinationName)).setter(UpdateEventDestinationRequest.setter(Builder::eventDestinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestinationName").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(UpdateEventDestinationRequest.getter(UpdateEventDestinationRequest::enabled)).setter(UpdateEventDestinationRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<List<String>> MATCHING_EVENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchingEventTypes").getter(UpdateEventDestinationRequest.getter(UpdateEventDestinationRequest::matchingEventTypesAsStrings)).setter(UpdateEventDestinationRequest.setter(Builder::matchingEventTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchingEventTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CloudWatchLogsDestination> CLOUD_WATCH_LOGS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLogsDestination").getter(UpdateEventDestinationRequest.getter(UpdateEventDestinationRequest::cloudWatchLogsDestination)).setter(UpdateEventDestinationRequest.setter(Builder::cloudWatchLogsDestination)).constructor(CloudWatchLogsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsDestination").build()}).build();
    private static final SdkField<KinesisFirehoseDestination> KINESIS_FIREHOSE_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisFirehoseDestination").getter(UpdateEventDestinationRequest.getter(UpdateEventDestinationRequest::kinesisFirehoseDestination)).setter(UpdateEventDestinationRequest.setter(Builder::kinesisFirehoseDestination)).constructor(KinesisFirehoseDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseDestination").build()}).build();
    private static final SdkField<SnsDestination> SNS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnsDestination").getter(UpdateEventDestinationRequest.getter(UpdateEventDestinationRequest::snsDestination)).setter(UpdateEventDestinationRequest.setter(Builder::snsDestination)).constructor(SnsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD, EVENT_DESTINATION_NAME_FIELD, ENABLED_FIELD, MATCHING_EVENT_TYPES_FIELD, CLOUD_WATCH_LOGS_DESTINATION_FIELD, KINESIS_FIREHOSE_DESTINATION_FIELD, SNS_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEventDestinationRequest.memberNameToFieldInitializer();
    private final String configurationSetName;
    private final String eventDestinationName;
    private final Boolean enabled;
    private final List<String> matchingEventTypes;
    private final CloudWatchLogsDestination cloudWatchLogsDestination;
    private final KinesisFirehoseDestination kinesisFirehoseDestination;
    private final SnsDestination snsDestination;

    private UpdateEventDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinationName = builder.eventDestinationName;
        this.enabled = builder.enabled;
        this.matchingEventTypes = builder.matchingEventTypes;
        this.cloudWatchLogsDestination = builder.cloudWatchLogsDestination;
        this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
        this.snsDestination = builder.snsDestination;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final String eventDestinationName() {
        return this.eventDestinationName;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final List<EventType> matchingEventTypes() {
        return EventTypeListCopier.copyStringToEnum(this.matchingEventTypes);
    }

    public final boolean hasMatchingEventTypes() {
        return this.matchingEventTypes != null && !(this.matchingEventTypes instanceof SdkAutoConstructList);
    }

    public final List<String> matchingEventTypesAsStrings() {
        return this.matchingEventTypes;
    }

    public final CloudWatchLogsDestination cloudWatchLogsDestination() {
        return this.cloudWatchLogsDestination;
    }

    public final KinesisFirehoseDestination kinesisFirehoseDestination() {
        return this.kinesisFirehoseDestination;
    }

    public final SnsDestination snsDestination() {
        return this.snsDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDestinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchingEventTypes() ? this.matchingEventTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventDestinationRequest)) {
            return false;
        }
        UpdateEventDestinationRequest other = (UpdateEventDestinationRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.eventDestinationName(), other.eventDestinationName()) && Objects.equals(this.enabled(), other.enabled()) && this.hasMatchingEventTypes() == other.hasMatchingEventTypes() && Objects.equals(this.matchingEventTypesAsStrings(), other.matchingEventTypesAsStrings()) && Objects.equals(this.cloudWatchLogsDestination(), other.cloudWatchLogsDestination()) && Objects.equals(this.kinesisFirehoseDestination(), other.kinesisFirehoseDestination()) && Objects.equals(this.snsDestination(), other.snsDestination());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEventDestinationRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("EventDestinationName", (Object)this.eventDestinationName()).add("Enabled", (Object)this.enabled()).add("MatchingEventTypes", this.hasMatchingEventTypes() ? this.matchingEventTypesAsStrings() : null).add("CloudWatchLogsDestination", (Object)this.cloudWatchLogsDestination()).add("KinesisFirehoseDestination", (Object)this.kinesisFirehoseDestination()).add("SnsDestination", (Object)this.snsDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "EventDestinationName": {
                return Optional.ofNullable(clazz.cast(this.eventDestinationName()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "MatchingEventTypes": {
                return Optional.ofNullable(clazz.cast(this.matchingEventTypesAsStrings()));
            }
            case "CloudWatchLogsDestination": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsDestination()));
            }
            case "KinesisFirehoseDestination": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseDestination()));
            }
            case "SnsDestination": {
                return Optional.ofNullable(clazz.cast(this.snsDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("EventDestinationName", EVENT_DESTINATION_NAME_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("MatchingEventTypes", MATCHING_EVENT_TYPES_FIELD);
        map.put("CloudWatchLogsDestination", CLOUD_WATCH_LOGS_DESTINATION_FIELD);
        map.put("KinesisFirehoseDestination", KINESIS_FIREHOSE_DESTINATION_FIELD);
        map.put("SnsDestination", SNS_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventDestinationRequest, T> g) {
        return obj -> g.apply((UpdateEventDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private String eventDestinationName;
        private Boolean enabled;
        private List<String> matchingEventTypes = DefaultSdkAutoConstructList.getInstance();
        private CloudWatchLogsDestination cloudWatchLogsDestination;
        private KinesisFirehoseDestination kinesisFirehoseDestination;
        private SnsDestination snsDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventDestinationRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.eventDestinationName(model.eventDestinationName);
            this.enabled(model.enabled);
            this.matchingEventTypesWithStrings(model.matchingEventTypes);
            this.cloudWatchLogsDestination(model.cloudWatchLogsDestination);
            this.kinesisFirehoseDestination(model.kinesisFirehoseDestination);
            this.snsDestination(model.snsDestination);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getEventDestinationName() {
            return this.eventDestinationName;
        }

        public final void setEventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
        }

        @Override
        public final Builder eventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Collection<String> getMatchingEventTypes() {
            if (this.matchingEventTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchingEventTypes;
        }

        public final void setMatchingEventTypes(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypeListCopier.copy(matchingEventTypes);
        }

        @Override
        public final Builder matchingEventTypesWithStrings(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypeListCopier.copy(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypesWithStrings(String ... matchingEventTypes) {
            this.matchingEventTypesWithStrings(Arrays.asList(matchingEventTypes));
            return this;
        }

        @Override
        public final Builder matchingEventTypes(Collection<EventType> matchingEventTypes) {
            this.matchingEventTypes = EventTypeListCopier.copyEnumToString(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypes(EventType ... matchingEventTypes) {
            this.matchingEventTypes(Arrays.asList(matchingEventTypes));
            return this;
        }

        public final CloudWatchLogsDestination.Builder getCloudWatchLogsDestination() {
            return this.cloudWatchLogsDestination != null ? this.cloudWatchLogsDestination.toBuilder() : null;
        }

        public final void setCloudWatchLogsDestination(CloudWatchLogsDestination.BuilderImpl cloudWatchLogsDestination) {
            this.cloudWatchLogsDestination = cloudWatchLogsDestination != null ? cloudWatchLogsDestination.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsDestination(CloudWatchLogsDestination cloudWatchLogsDestination) {
            this.cloudWatchLogsDestination = cloudWatchLogsDestination;
            return this;
        }

        public final KinesisFirehoseDestination.Builder getKinesisFirehoseDestination() {
            return this.kinesisFirehoseDestination != null ? this.kinesisFirehoseDestination.toBuilder() : null;
        }

        public final void setKinesisFirehoseDestination(KinesisFirehoseDestination.BuilderImpl kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination != null ? kinesisFirehoseDestination.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination;
            return this;
        }

        public final SnsDestination.Builder getSnsDestination() {
            return this.snsDestination != null ? this.snsDestination.toBuilder() : null;
        }

        public final void setSnsDestination(SnsDestination.BuilderImpl snsDestination) {
            this.snsDestination = snsDestination != null ? snsDestination.build() : null;
        }

        @Override
        public final Builder snsDestination(SnsDestination snsDestination) {
            this.snsDestination = snsDestination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventDestinationRequest build() {
            return new UpdateEventDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventDestinationRequest> {
        public Builder configurationSetName(String var1);

        public Builder eventDestinationName(String var1);

        public Builder enabled(Boolean var1);

        public Builder matchingEventTypesWithStrings(Collection<String> var1);

        public Builder matchingEventTypesWithStrings(String ... var1);

        public Builder matchingEventTypes(Collection<EventType> var1);

        public Builder matchingEventTypes(EventType ... var1);

        public Builder cloudWatchLogsDestination(CloudWatchLogsDestination var1);

        default public Builder cloudWatchLogsDestination(Consumer<CloudWatchLogsDestination.Builder> cloudWatchLogsDestination) {
            return this.cloudWatchLogsDestination((CloudWatchLogsDestination)((CloudWatchLogsDestination.Builder)CloudWatchLogsDestination.builder().applyMutation(cloudWatchLogsDestination)).build());
        }

        public Builder kinesisFirehoseDestination(KinesisFirehoseDestination var1);

        default public Builder kinesisFirehoseDestination(Consumer<KinesisFirehoseDestination.Builder> kinesisFirehoseDestination) {
            return this.kinesisFirehoseDestination((KinesisFirehoseDestination)((KinesisFirehoseDestination.Builder)KinesisFirehoseDestination.builder().applyMutation(kinesisFirehoseDestination)).build());
        }

        public Builder snsDestination(SnsDestination var1);

        default public Builder snsDestination(Consumer<SnsDestination.Builder> snsDestination) {
            return this.snsDestination((SnsDestination)((SnsDestination.Builder)SnsDestination.builder().applyMutation(snsDestination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

