/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberCapability;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationCountryRuleSetCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationCountryRuleSetInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProtectConfigurationCountryRuleSetRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, UpdateProtectConfigurationCountryRuleSetRequest> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationId").getter(UpdateProtectConfigurationCountryRuleSetRequest.getter(UpdateProtectConfigurationCountryRuleSetRequest::protectConfigurationId)).setter(UpdateProtectConfigurationCountryRuleSetRequest.setter(Builder::protectConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build()}).build();
    private static final SdkField<String> NUMBER_CAPABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberCapability").getter(UpdateProtectConfigurationCountryRuleSetRequest.getter(UpdateProtectConfigurationCountryRuleSetRequest::numberCapabilityAsString)).setter(UpdateProtectConfigurationCountryRuleSetRequest.setter(Builder::numberCapability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapability").build()}).build();
    private static final SdkField<Map<String, ProtectConfigurationCountryRuleSetInformation>> COUNTRY_RULE_SET_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CountryRuleSetUpdates").getter(UpdateProtectConfigurationCountryRuleSetRequest.getter(UpdateProtectConfigurationCountryRuleSetRequest::countryRuleSetUpdates)).setter(UpdateProtectConfigurationCountryRuleSetRequest.setter(Builder::countryRuleSetUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryRuleSetUpdates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectConfigurationCountryRuleSetInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECT_CONFIGURATION_ID_FIELD, NUMBER_CAPABILITY_FIELD, COUNTRY_RULE_SET_UPDATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProtectConfigurationCountryRuleSetRequest.memberNameToFieldInitializer();
    private final String protectConfigurationId;
    private final String numberCapability;
    private final Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSetUpdates;

    private UpdateProtectConfigurationCountryRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationId = builder.protectConfigurationId;
        this.numberCapability = builder.numberCapability;
        this.countryRuleSetUpdates = builder.countryRuleSetUpdates;
    }

    public final String protectConfigurationId() {
        return this.protectConfigurationId;
    }

    public final NumberCapability numberCapability() {
        return NumberCapability.fromValue(this.numberCapability);
    }

    public final String numberCapabilityAsString() {
        return this.numberCapability;
    }

    public final boolean hasCountryRuleSetUpdates() {
        return this.countryRuleSetUpdates != null && !(this.countryRuleSetUpdates instanceof SdkAutoConstructMap);
    }

    public final Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSetUpdates() {
        return this.countryRuleSetUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberCapabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountryRuleSetUpdates() ? this.countryRuleSetUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProtectConfigurationCountryRuleSetRequest)) {
            return false;
        }
        UpdateProtectConfigurationCountryRuleSetRequest other = (UpdateProtectConfigurationCountryRuleSetRequest)((Object)obj);
        return Objects.equals(this.protectConfigurationId(), other.protectConfigurationId()) && Objects.equals(this.numberCapabilityAsString(), other.numberCapabilityAsString()) && this.hasCountryRuleSetUpdates() == other.hasCountryRuleSetUpdates() && Objects.equals(this.countryRuleSetUpdates(), other.countryRuleSetUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProtectConfigurationCountryRuleSetRequest").add("ProtectConfigurationId", (Object)this.protectConfigurationId()).add("NumberCapability", (Object)this.numberCapabilityAsString()).add("CountryRuleSetUpdates", this.hasCountryRuleSetUpdates() ? this.countryRuleSetUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationId()));
            }
            case "NumberCapability": {
                return Optional.ofNullable(clazz.cast(this.numberCapabilityAsString()));
            }
            case "CountryRuleSetUpdates": {
                return Optional.ofNullable(clazz.cast(this.countryRuleSetUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("NumberCapability", NUMBER_CAPABILITY_FIELD);
        map.put("CountryRuleSetUpdates", COUNTRY_RULE_SET_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProtectConfigurationCountryRuleSetRequest, T> g) {
        return obj -> g.apply((UpdateProtectConfigurationCountryRuleSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String protectConfigurationId;
        private String numberCapability;
        private Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSetUpdates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProtectConfigurationCountryRuleSetRequest model) {
            super(model);
            this.protectConfigurationId(model.protectConfigurationId);
            this.numberCapability(model.numberCapability);
            this.countryRuleSetUpdates(model.countryRuleSetUpdates);
        }

        public final String getProtectConfigurationId() {
            return this.protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final String getNumberCapability() {
            return this.numberCapability;
        }

        public final void setNumberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
        }

        @Override
        public final Builder numberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
            return this;
        }

        @Override
        public final Builder numberCapability(NumberCapability numberCapability) {
            this.numberCapability(numberCapability == null ? null : numberCapability.toString());
            return this;
        }

        public final Map<String, ProtectConfigurationCountryRuleSetInformation.Builder> getCountryRuleSetUpdates() {
            Map<String, ProtectConfigurationCountryRuleSetInformation.Builder> result = ProtectConfigurationCountryRuleSetCopier.copyToBuilder(this.countryRuleSetUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCountryRuleSetUpdates(Map<String, ProtectConfigurationCountryRuleSetInformation.BuilderImpl> countryRuleSetUpdates) {
            this.countryRuleSetUpdates = ProtectConfigurationCountryRuleSetCopier.copyFromBuilder(countryRuleSetUpdates);
        }

        @Override
        public final Builder countryRuleSetUpdates(Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSetUpdates) {
            this.countryRuleSetUpdates = ProtectConfigurationCountryRuleSetCopier.copy(countryRuleSetUpdates);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProtectConfigurationCountryRuleSetRequest build() {
            return new UpdateProtectConfigurationCountryRuleSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProtectConfigurationCountryRuleSetRequest> {
        public Builder protectConfigurationId(String var1);

        public Builder numberCapability(String var1);

        public Builder numberCapability(NumberCapability var1);

        public Builder countryRuleSetUpdates(Map<String, ProtectConfigurationCountryRuleSetInformation> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

