/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldValueInformation;

public class DescribeRegistrationFieldValuesPublisher
implements SdkPublisher<DescribeRegistrationFieldValuesResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeRegistrationFieldValuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRegistrationFieldValuesPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationFieldValuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRegistrationFieldValuesPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationFieldValuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRegistrationFieldValuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRegistrationFieldValuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegistrationFieldValueInformation> registrationFieldValues() {
        Function<DescribeRegistrationFieldValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationFieldValues() != null) {
                return response.registrationFieldValues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRegistrationFieldValuesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRegistrationFieldValuesResponseFetcher
    implements AsyncPageFetcher<DescribeRegistrationFieldValuesResponse> {
        private DescribeRegistrationFieldValuesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationFieldValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRegistrationFieldValuesResponse> nextPage(DescribeRegistrationFieldValuesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationFieldValuesPublisher.this.client.describeRegistrationFieldValues(DescribeRegistrationFieldValuesPublisher.this.firstRequest);
            }
            return DescribeRegistrationFieldValuesPublisher.this.client.describeRegistrationFieldValues((DescribeRegistrationFieldValuesRequest)((Object)DescribeRegistrationFieldValuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

