/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes;

import java.net.URI;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.services.pipes.endpoints.PipesEndpointProvider;

/**
 * Internal implementation of {@link PipesAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPipesAsyncClientBuilder extends DefaultPipesBaseClientBuilder<PipesAsyncClientBuilder, PipesAsyncClient>
        implements PipesAsyncClientBuilder {
    @Override
    public DefaultPipesAsyncClientBuilder endpointProvider(PipesEndpointProvider endpointProvider) {
        clientConfiguration.option(SdkClientOption.ENDPOINT_PROVIDER, endpointProvider);
        return this;
    }

    @Override
    protected final PipesAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        this.validateClientOptions(clientConfiguration);
        PipesServiceClientConfiguration serviceClientConfiguration = initializeServiceClientConfig(clientConfiguration);
        PipesAsyncClient client = new DefaultPipesAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PipesServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = clientConfig.option(SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN) != null
                && Boolean.TRUE.equals(clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = clientConfig.option(SdkClientOption.ENDPOINT);
        }
        return PipesServiceClientConfiguration.builder().overrideConfiguration(overrideConfiguration())
                .region(clientConfig.option(AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride)
                .endpointProvider(endpointProvider).build();
    }
}
