/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.PipeState;
import software.amazon.awssdk.services.pipes.model.PipesResponse;
import software.amazon.awssdk.services.pipes.model.RequestedPipeStateDescribeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePipeResponse
extends PipesResponse
implements ToCopyableBuilder<Builder, DeletePipeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DeletePipeResponse.getter(DeletePipeResponse::arn)).setter(DeletePipeResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DeletePipeResponse.getter(DeletePipeResponse::creationTime)).setter(DeletePipeResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentState").getter(DeletePipeResponse.getter(DeletePipeResponse::currentStateAsString)).setter(DeletePipeResponse.setter(Builder::currentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentState").build()}).build();
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredState").getter(DeletePipeResponse.getter(DeletePipeResponse::desiredStateAsString)).setter(DeletePipeResponse.setter(Builder::desiredState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DeletePipeResponse.getter(DeletePipeResponse::lastModifiedTime)).setter(DeletePipeResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DeletePipeResponse.getter(DeletePipeResponse::name)).setter(DeletePipeResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, CURRENT_STATE_FIELD, DESIRED_STATE_FIELD, LAST_MODIFIED_TIME_FIELD, NAME_FIELD));
    private final String arn;
    private final Instant creationTime;
    private final String currentState;
    private final String desiredState;
    private final Instant lastModifiedTime;
    private final String name;

    private DeletePipeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.currentState = builder.currentState;
        this.desiredState = builder.desiredState;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.name = builder.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final PipeState currentState() {
        return PipeState.fromValue(this.currentState);
    }

    public final String currentStateAsString() {
        return this.currentState;
    }

    public final RequestedPipeStateDescribeResponse desiredState() {
        return RequestedPipeStateDescribeResponse.fromValue(this.desiredState);
    }

    public final String desiredStateAsString() {
        return this.desiredState;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePipeResponse)) {
            return false;
        }
        DeletePipeResponse other = (DeletePipeResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.currentStateAsString(), other.currentStateAsString()) && Objects.equals(this.desiredStateAsString(), other.desiredStateAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"DeletePipeResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("CurrentState", (Object)this.currentStateAsString()).add("DesiredState", (Object)this.desiredStateAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CurrentState": {
                return Optional.ofNullable(clazz.cast(this.currentStateAsString()));
            }
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredStateAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePipeResponse, T> g) {
        return obj -> g.apply((DeletePipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PipesResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private String currentState;
        private String desiredState;
        private Instant lastModifiedTime;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePipeResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.currentState(model.currentState);
            this.desiredState(model.desiredState);
            this.lastModifiedTime(model.lastModifiedTime);
            this.name(model.name);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCurrentState() {
            return this.currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(PipeState currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        public final String getDesiredState() {
            return this.desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(RequestedPipeStateDescribeResponse desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public DeletePipeResponse build() {
            return new DeletePipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PipesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeletePipeResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder currentState(String var1);

        public Builder currentState(PipeState var1);

        public Builder desiredState(String var1);

        public Builder desiredState(RequestedPipeStateDescribeResponse var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder name(String var1);
    }
}

