/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a network site.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkSite implements SdkPojo, Serializable, ToCopyableBuilder<NetworkSite.Builder, NetworkSite> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(NetworkSite::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(NetworkSite::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(NetworkSite::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<SitePlan> CURRENT_PLAN_FIELD = SdkField.<SitePlan> builder(MarshallingType.SDK_POJO)
            .memberName("currentPlan").getter(getter(NetworkSite::currentPlan)).setter(setter(Builder::currentPlan))
            .constructor(SitePlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPlan").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(NetworkSite::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkArn").getter(getter(NetworkSite::networkArn)).setter(setter(Builder::networkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()).build();

    private static final SdkField<String> NETWORK_SITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSiteArn").getter(getter(NetworkSite::networkSiteArn)).setter(setter(Builder::networkSiteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteArn").build()).build();

    private static final SdkField<String> NETWORK_SITE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSiteName").getter(getter(NetworkSite::networkSiteName)).setter(setter(Builder::networkSiteName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteName").build()).build();

    private static final SdkField<SitePlan> PENDING_PLAN_FIELD = SdkField.<SitePlan> builder(MarshallingType.SDK_POJO)
            .memberName("pendingPlan").getter(getter(NetworkSite::pendingPlan)).setter(setter(Builder::pendingPlan))
            .constructor(SitePlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingPlan").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(NetworkSite::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(NetworkSite::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, CREATED_AT_FIELD, CURRENT_PLAN_FIELD, DESCRIPTION_FIELD, NETWORK_ARN_FIELD,
            NETWORK_SITE_ARN_FIELD, NETWORK_SITE_NAME_FIELD, PENDING_PLAN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final Instant createdAt;

    private final SitePlan currentPlan;

    private final String description;

    private final String networkArn;

    private final String networkSiteArn;

    private final String networkSiteName;

    private final SitePlan pendingPlan;

    private final String status;

    private final String statusReason;

    private NetworkSite(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.createdAt = builder.createdAt;
        this.currentPlan = builder.currentPlan;
        this.description = builder.description;
        this.networkArn = builder.networkArn;
        this.networkSiteArn = builder.networkSiteArn;
        this.networkSiteName = builder.networkSiteName;
        this.pendingPlan = builder.pendingPlan;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The parent Availability Zone for the network site.
     * </p>
     * 
     * @return The parent Availability Zone for the network site.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The parent Availability Zone ID for the network site.
     * </p>
     * 
     * @return The parent Availability Zone ID for the network site.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The creation time of the network site.
     * </p>
     * 
     * @return The creation time of the network site.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The current plan of the network site.
     * </p>
     * 
     * @return The current plan of the network site.
     */
    public final SitePlan currentPlan() {
        return currentPlan;
    }

    /**
     * <p>
     * The description of the network site.
     * </p>
     * 
     * @return The description of the network site.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network to which the network site belongs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network to which the network site belongs.
     */
    public final String networkArn() {
        return networkArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network site.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network site.
     */
    public final String networkSiteArn() {
        return networkSiteArn;
    }

    /**
     * <p>
     * The name of the network site.
     * </p>
     * 
     * @return The name of the network site.
     */
    public final String networkSiteName() {
        return networkSiteName;
    }

    /**
     * <p>
     * The pending plan of the network site.
     * </p>
     * 
     * @return The pending plan of the network site.
     */
    public final SitePlan pendingPlan() {
        return pendingPlan;
    }

    /**
     * <p>
     * The status of the network site.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkSiteStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network site.
     * @see NetworkSiteStatus
     */
    public final NetworkSiteStatus status() {
        return NetworkSiteStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the network site.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkSiteStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network site.
     * @see NetworkSiteStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the network site.
     * </p>
     * 
     * @return The status reason of the network site.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(currentPlan());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkSiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkSiteName());
        hashCode = 31 * hashCode + Objects.hashCode(pendingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkSite)) {
            return false;
        }
        NetworkSite other = (NetworkSite) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(currentPlan(), other.currentPlan())
                && Objects.equals(description(), other.description()) && Objects.equals(networkArn(), other.networkArn())
                && Objects.equals(networkSiteArn(), other.networkSiteArn())
                && Objects.equals(networkSiteName(), other.networkSiteName())
                && Objects.equals(pendingPlan(), other.pendingPlan()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkSite").add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("CreatedAt", createdAt()).add("CurrentPlan", currentPlan())
                .add("Description", description()).add("NetworkArn", networkArn()).add("NetworkSiteArn", networkSiteArn())
                .add("NetworkSiteName", networkSiteName()).add("PendingPlan", pendingPlan()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "currentPlan":
            return Optional.ofNullable(clazz.cast(currentPlan()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "networkArn":
            return Optional.ofNullable(clazz.cast(networkArn()));
        case "networkSiteArn":
            return Optional.ofNullable(clazz.cast(networkSiteArn()));
        case "networkSiteName":
            return Optional.ofNullable(clazz.cast(networkSiteName()));
        case "pendingPlan":
            return Optional.ofNullable(clazz.cast(pendingPlan()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkSite, T> g) {
        return obj -> g.apply((NetworkSite) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkSite> {
        /**
         * <p>
         * The parent Availability Zone for the network site.
         * </p>
         * 
         * @param availabilityZone
         *        The parent Availability Zone for the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The parent Availability Zone ID for the network site.
         * </p>
         * 
         * @param availabilityZoneId
         *        The parent Availability Zone ID for the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The creation time of the network site.
         * </p>
         * 
         * @param createdAt
         *        The creation time of the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The current plan of the network site.
         * </p>
         * 
         * @param currentPlan
         *        The current plan of the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPlan(SitePlan currentPlan);

        /**
         * <p>
         * The current plan of the network site.
         * </p>
         * This is a convenience method that creates an instance of the {@link SitePlan.Builder} avoiding the need to
         * create one manually via {@link SitePlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SitePlan.Builder#build()} is called immediately and its result is
         * passed to {@link #currentPlan(SitePlan)}.
         * 
         * @param currentPlan
         *        a consumer that will call methods on {@link SitePlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentPlan(SitePlan)
         */
        default Builder currentPlan(Consumer<SitePlan.Builder> currentPlan) {
            return currentPlan(SitePlan.builder().applyMutation(currentPlan).build());
        }

        /**
         * <p>
         * The description of the network site.
         * </p>
         * 
         * @param description
         *        The description of the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network to which the network site belongs.
         * </p>
         * 
         * @param networkArn
         *        The Amazon Resource Name (ARN) of the network to which the network site belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkArn(String networkArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network site.
         * </p>
         * 
         * @param networkSiteArn
         *        The Amazon Resource Name (ARN) of the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSiteArn(String networkSiteArn);

        /**
         * <p>
         * The name of the network site.
         * </p>
         * 
         * @param networkSiteName
         *        The name of the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSiteName(String networkSiteName);

        /**
         * <p>
         * The pending plan of the network site.
         * </p>
         * 
         * @param pendingPlan
         *        The pending plan of the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingPlan(SitePlan pendingPlan);

        /**
         * <p>
         * The pending plan of the network site.
         * </p>
         * This is a convenience method that creates an instance of the {@link SitePlan.Builder} avoiding the need to
         * create one manually via {@link SitePlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SitePlan.Builder#build()} is called immediately and its result is
         * passed to {@link #pendingPlan(SitePlan)}.
         * 
         * @param pendingPlan
         *        a consumer that will call methods on {@link SitePlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingPlan(SitePlan)
         */
        default Builder pendingPlan(Consumer<SitePlan.Builder> pendingPlan) {
            return pendingPlan(SitePlan.builder().applyMutation(pendingPlan).build());
        }

        /**
         * <p>
         * The status of the network site.
         * </p>
         * 
         * @param status
         *        The status of the network site.
         * @see NetworkSiteStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkSiteStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the network site.
         * </p>
         * 
         * @param status
         *        The status of the network site.
         * @see NetworkSiteStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkSiteStatus
         */
        Builder status(NetworkSiteStatus status);

        /**
         * <p>
         * The status reason of the network site.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String availabilityZoneId;

        private Instant createdAt;

        private SitePlan currentPlan;

        private String description;

        private String networkArn;

        private String networkSiteArn;

        private String networkSiteName;

        private SitePlan pendingPlan;

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkSite model) {
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            createdAt(model.createdAt);
            currentPlan(model.currentPlan);
            description(model.description);
            networkArn(model.networkArn);
            networkSiteArn(model.networkSiteArn);
            networkSiteName(model.networkSiteName);
            pendingPlan(model.pendingPlan);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final SitePlan.Builder getCurrentPlan() {
            return currentPlan != null ? currentPlan.toBuilder() : null;
        }

        public final void setCurrentPlan(SitePlan.BuilderImpl currentPlan) {
            this.currentPlan = currentPlan != null ? currentPlan.build() : null;
        }

        @Override
        public final Builder currentPlan(SitePlan currentPlan) {
            this.currentPlan = currentPlan;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNetworkArn() {
            return networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getNetworkSiteArn() {
            return networkSiteArn;
        }

        public final void setNetworkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
        }

        @Override
        public final Builder networkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
            return this;
        }

        public final String getNetworkSiteName() {
            return networkSiteName;
        }

        public final void setNetworkSiteName(String networkSiteName) {
            this.networkSiteName = networkSiteName;
        }

        @Override
        public final Builder networkSiteName(String networkSiteName) {
            this.networkSiteName = networkSiteName;
            return this;
        }

        public final SitePlan.Builder getPendingPlan() {
            return pendingPlan != null ? pendingPlan.toBuilder() : null;
        }

        public final void setPendingPlan(SitePlan.BuilderImpl pendingPlan) {
            this.pendingPlan = pendingPlan != null ? pendingPlan.build() : null;
        }

        @Override
        public final Builder pendingPlan(SitePlan pendingPlan) {
            this.pendingPlan = pendingPlan;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkSiteStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public NetworkSite build() {
            return new NetworkSite(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
