/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary;
import software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse;

public class ListEnvironmentAccountConnectionsIterable
implements SdkIterable<ListEnvironmentAccountConnectionsResponse> {
    private final ProtonClient client;
    private final ListEnvironmentAccountConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentAccountConnectionsIterable(ProtonClient client, ListEnvironmentAccountConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentAccountConnectionsResponseFetcher();
    }

    public Iterator<ListEnvironmentAccountConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentAccountConnectionSummary> environmentAccountConnections() {
        Function<ListEnvironmentAccountConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environmentAccountConnections() != null) {
                return response.environmentAccountConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentAccountConnectionsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentAccountConnectionsResponse> {
        private ListEnvironmentAccountConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentAccountConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentAccountConnectionsResponse nextPage(ListEnvironmentAccountConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentAccountConnectionsIterable.this.client.listEnvironmentAccountConnections(ListEnvironmentAccountConnectionsIterable.this.firstRequest);
            }
            return ListEnvironmentAccountConnectionsIterable.this.client.listEnvironmentAccountConnections((ListEnvironmentAccountConnectionsRequest)((Object)ListEnvironmentAccountConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

