/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RepositoryProvider {
    GITHUB("GITHUB"),
    GITHUB_ENTERPRISE("GITHUB_ENTERPRISE"),
    BITBUCKET("BITBUCKET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RepositoryProvider> VALUE_MAP;
    private final String value;

    private RepositoryProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RepositoryProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RepositoryProvider> knownValues() {
        EnumSet<RepositoryProvider> knownValues = EnumSet.allOf(RepositoryProvider.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RepositoryProvider.class, RepositoryProvider::toString);
    }
}

