/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.ActionExecution;
import software.amazon.awssdk.services.qbusiness.model.ActionReview;
import software.amazon.awssdk.services.qbusiness.model.AttachmentOutput;
import software.amazon.awssdk.services.qbusiness.model.AttachmentsOutputCopier;
import software.amazon.awssdk.services.qbusiness.model.MessageType;
import software.amazon.awssdk.services.qbusiness.model.SourceAttribution;
import software.amazon.awssdk.services.qbusiness.model.SourceAttributionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Message
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Message> {
    private static final SdkField<ActionExecution> ACTION_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionExecution").getter(Message.getter(Message::actionExecution)).setter(Message.setter(Builder::actionExecution)).constructor(ActionExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecution").build()}).build();
    private static final SdkField<ActionReview> ACTION_REVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionReview").getter(Message.getter(Message::actionReview)).setter(Message.setter(Builder::actionReview)).constructor(ActionReview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionReview").build()}).build();
    private static final SdkField<List<AttachmentOutput>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attachments").getter(Message.getter(Message::attachments)).setter(Message.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(Message.getter(Message::body)).setter(Message.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageId").getter(Message.getter(Message::messageId)).setter(Message.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()}).build();
    private static final SdkField<List<SourceAttribution>> SOURCE_ATTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceAttribution").getter(Message.getter(Message::sourceAttribution)).setter(Message.setter(Builder::sourceAttribution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAttribution").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceAttribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("time").getter(Message.getter(Message::time)).setter(Message.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("time").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Message.getter(Message::typeAsString)).setter(Message.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_EXECUTION_FIELD, ACTION_REVIEW_FIELD, ATTACHMENTS_FIELD, BODY_FIELD, MESSAGE_ID_FIELD, SOURCE_ATTRIBUTION_FIELD, TIME_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ActionExecution actionExecution;
    private final ActionReview actionReview;
    private final List<AttachmentOutput> attachments;
    private final String body;
    private final String messageId;
    private final List<SourceAttribution> sourceAttribution;
    private final Instant time;
    private final String type;

    private Message(BuilderImpl builder) {
        this.actionExecution = builder.actionExecution;
        this.actionReview = builder.actionReview;
        this.attachments = builder.attachments;
        this.body = builder.body;
        this.messageId = builder.messageId;
        this.sourceAttribution = builder.sourceAttribution;
        this.time = builder.time;
        this.type = builder.type;
    }

    public final ActionExecution actionExecution() {
        return this.actionExecution;
    }

    public final ActionReview actionReview() {
        return this.actionReview;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<AttachmentOutput> attachments() {
        return this.attachments;
    }

    public final String body() {
        return this.body;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final boolean hasSourceAttribution() {
        return this.sourceAttribution != null && !(this.sourceAttribution instanceof SdkAutoConstructList);
    }

    public final List<SourceAttribution> sourceAttribution() {
        return this.sourceAttribution;
    }

    public final Instant time() {
        return this.time;
    }

    public final MessageType type() {
        return MessageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionReview());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAttribution() ? this.sourceAttribution() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.actionExecution(), other.actionExecution()) && Objects.equals(this.actionReview(), other.actionReview()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.messageId(), other.messageId()) && this.hasSourceAttribution() == other.hasSourceAttribution() && Objects.equals(this.sourceAttribution(), other.sourceAttribution()) && Objects.equals(this.time(), other.time()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Message").add("ActionExecution", (Object)this.actionExecution()).add("ActionReview", (Object)this.actionReview()).add("Attachments", this.hasAttachments() ? this.attachments() : null).add("Body", (Object)this.body()).add("MessageId", (Object)this.messageId()).add("SourceAttribution", this.hasSourceAttribution() ? this.sourceAttribution() : null).add("Time", (Object)this.time()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionExecution": {
                return Optional.ofNullable(clazz.cast(this.actionExecution()));
            }
            case "actionReview": {
                return Optional.ofNullable(clazz.cast(this.actionReview()));
            }
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "messageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "sourceAttribution": {
                return Optional.ofNullable(clazz.cast(this.sourceAttribution()));
            }
            case "time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActionExecution actionExecution;
        private ActionReview actionReview;
        private List<AttachmentOutput> attachments = DefaultSdkAutoConstructList.getInstance();
        private String body;
        private String messageId;
        private List<SourceAttribution> sourceAttribution = DefaultSdkAutoConstructList.getInstance();
        private Instant time;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.actionExecution(model.actionExecution);
            this.actionReview(model.actionReview);
            this.attachments(model.attachments);
            this.body(model.body);
            this.messageId(model.messageId);
            this.sourceAttribution(model.sourceAttribution);
            this.time(model.time);
            this.type(model.type);
        }

        public final ActionExecution.Builder getActionExecution() {
            return this.actionExecution != null ? this.actionExecution.toBuilder() : null;
        }

        public final void setActionExecution(ActionExecution.BuilderImpl actionExecution) {
            this.actionExecution = actionExecution != null ? actionExecution.build() : null;
        }

        @Override
        public final Builder actionExecution(ActionExecution actionExecution) {
            this.actionExecution = actionExecution;
            return this;
        }

        public final ActionReview.Builder getActionReview() {
            return this.actionReview != null ? this.actionReview.toBuilder() : null;
        }

        public final void setActionReview(ActionReview.BuilderImpl actionReview) {
            this.actionReview = actionReview != null ? actionReview.build() : null;
        }

        @Override
        public final Builder actionReview(ActionReview actionReview) {
            this.actionReview = actionReview;
            return this;
        }

        public final List<AttachmentOutput.Builder> getAttachments() {
            List<AttachmentOutput.Builder> result = AttachmentsOutputCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AttachmentOutput.BuilderImpl> attachments) {
            this.attachments = AttachmentsOutputCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<AttachmentOutput> attachments) {
            this.attachments = AttachmentsOutputCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AttachmentOutput ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentOutput.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (AttachmentOutput)((AttachmentOutput.Builder)AttachmentOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final List<SourceAttribution.Builder> getSourceAttribution() {
            List<SourceAttribution.Builder> result = SourceAttributionsCopier.copyToBuilder(this.sourceAttribution);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAttribution(Collection<SourceAttribution.BuilderImpl> sourceAttribution) {
            this.sourceAttribution = SourceAttributionsCopier.copyFromBuilder(sourceAttribution);
        }

        @Override
        public final Builder sourceAttribution(Collection<SourceAttribution> sourceAttribution) {
            this.sourceAttribution = SourceAttributionsCopier.copy(sourceAttribution);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttribution(SourceAttribution ... sourceAttribution) {
            this.sourceAttribution(Arrays.asList(sourceAttribution));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttribution(Consumer<SourceAttribution.Builder> ... sourceAttribution) {
            this.sourceAttribution(Stream.of(sourceAttribution).map(c -> (SourceAttribution)((SourceAttribution.Builder)SourceAttribution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getTime() {
            return this.time;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public Message build() {
            return new Message(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Message> {
        public Builder actionExecution(ActionExecution var1);

        default public Builder actionExecution(Consumer<ActionExecution.Builder> actionExecution) {
            return this.actionExecution((ActionExecution)((ActionExecution.Builder)ActionExecution.builder().applyMutation(actionExecution)).build());
        }

        public Builder actionReview(ActionReview var1);

        default public Builder actionReview(Consumer<ActionReview.Builder> actionReview) {
            return this.actionReview((ActionReview)((ActionReview.Builder)ActionReview.builder().applyMutation(actionReview)).build());
        }

        public Builder attachments(Collection<AttachmentOutput> var1);

        public Builder attachments(AttachmentOutput ... var1);

        public Builder attachments(Consumer<AttachmentOutput.Builder> ... var1);

        public Builder body(String var1);

        public Builder messageId(String var1);

        public Builder sourceAttribution(Collection<SourceAttribution> var1);

        public Builder sourceAttribution(SourceAttribution ... var1);

        public Builder sourceAttribution(Consumer<SourceAttribution.Builder> ... var1);

        public Builder time(Instant var1);

        public Builder type(String var1);

        public Builder type(MessageType var1);
    }
}

