/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.ContentDataDetails;
import software.amazon.awssdk.services.qconnect.model.GenerativeDataDetails;
import software.amazon.awssdk.services.qconnect.model.SourceContentDataDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataDetails> {
    private static final SdkField<ContentDataDetails> CONTENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentData").getter(DataDetails.getter(DataDetails::contentData)).setter(DataDetails.setter(Builder::contentData)).constructor(ContentDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentData").build()}).build();
    private static final SdkField<GenerativeDataDetails> GENERATIVE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generativeData").getter(DataDetails.getter(DataDetails::generativeData)).setter(DataDetails.setter(Builder::generativeData)).constructor(GenerativeDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeData").build()}).build();
    private static final SdkField<SourceContentDataDetails> SOURCE_CONTENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceContentData").getter(DataDetails.getter(DataDetails::sourceContentData)).setter(DataDetails.setter(Builder::sourceContentData)).constructor(SourceContentDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceContentData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_DATA_FIELD, GENERATIVE_DATA_FIELD, SOURCE_CONTENT_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final ContentDataDetails contentData;
    private final GenerativeDataDetails generativeData;
    private final SourceContentDataDetails sourceContentData;
    private final Type type;

    private DataDetails(BuilderImpl builder) {
        this.contentData = builder.contentData;
        this.generativeData = builder.generativeData;
        this.sourceContentData = builder.sourceContentData;
        this.type = builder.type;
    }

    public final ContentDataDetails contentData() {
        return this.contentData;
    }

    public final GenerativeDataDetails generativeData() {
        return this.generativeData;
    }

    public final SourceContentDataDetails sourceContentData() {
        return this.sourceContentData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentData());
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeData());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceContentData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataDetails)) {
            return false;
        }
        DataDetails other = (DataDetails)obj;
        return Objects.equals(this.contentData(), other.contentData()) && Objects.equals(this.generativeData(), other.generativeData()) && Objects.equals(this.sourceContentData(), other.sourceContentData());
    }

    public final String toString() {
        return ToString.builder((String)"DataDetails").add("ContentData", (Object)this.contentData()).add("GenerativeData", (Object)this.generativeData()).add("SourceContentData", (Object)this.sourceContentData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentData": {
                return Optional.ofNullable(clazz.cast(this.contentData()));
            }
            case "generativeData": {
                return Optional.ofNullable(clazz.cast(this.generativeData()));
            }
            case "sourceContentData": {
                return Optional.ofNullable(clazz.cast(this.sourceContentData()));
            }
        }
        return Optional.empty();
    }

    public static DataDetails fromContentData(ContentDataDetails contentData) {
        return (DataDetails)DataDetails.builder().contentData(contentData).build();
    }

    public static DataDetails fromContentData(Consumer<ContentDataDetails.Builder> contentData) {
        ContentDataDetails.Builder builder = ContentDataDetails.builder();
        contentData.accept(builder);
        return DataDetails.fromContentData((ContentDataDetails)builder.build());
    }

    public static DataDetails fromGenerativeData(GenerativeDataDetails generativeData) {
        return (DataDetails)DataDetails.builder().generativeData(generativeData).build();
    }

    public static DataDetails fromGenerativeData(Consumer<GenerativeDataDetails.Builder> generativeData) {
        GenerativeDataDetails.Builder builder = GenerativeDataDetails.builder();
        generativeData.accept(builder);
        return DataDetails.fromGenerativeData((GenerativeDataDetails)builder.build());
    }

    public static DataDetails fromSourceContentData(SourceContentDataDetails sourceContentData) {
        return (DataDetails)DataDetails.builder().sourceContentData(sourceContentData).build();
    }

    public static DataDetails fromSourceContentData(Consumer<SourceContentDataDetails.Builder> sourceContentData) {
        SourceContentDataDetails.Builder builder = SourceContentDataDetails.builder();
        sourceContentData.accept(builder);
        return DataDetails.fromSourceContentData((SourceContentDataDetails)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataDetails, T> g) {
        return obj -> g.apply((DataDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONTENT_DATA,
        GENERATIVE_DATA,
        SOURCE_CONTENT_DATA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ContentDataDetails contentData;
        private GenerativeDataDetails generativeData;
        private SourceContentDataDetails sourceContentData;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataDetails model) {
            this.contentData(model.contentData);
            this.generativeData(model.generativeData);
            this.sourceContentData(model.sourceContentData);
        }

        public final ContentDataDetails.Builder getContentData() {
            return this.contentData != null ? this.contentData.toBuilder() : null;
        }

        public final void setContentData(ContentDataDetails.BuilderImpl contentData) {
            ContentDataDetails oldValue = this.contentData;
            this.contentData = contentData != null ? contentData.build() : null;
            this.handleUnionValueChange(Type.CONTENT_DATA, oldValue, this.contentData);
        }

        @Override
        public final Builder contentData(ContentDataDetails contentData) {
            ContentDataDetails oldValue = this.contentData;
            this.contentData = contentData;
            this.handleUnionValueChange(Type.CONTENT_DATA, oldValue, this.contentData);
            return this;
        }

        public final GenerativeDataDetails.Builder getGenerativeData() {
            return this.generativeData != null ? this.generativeData.toBuilder() : null;
        }

        public final void setGenerativeData(GenerativeDataDetails.BuilderImpl generativeData) {
            GenerativeDataDetails oldValue = this.generativeData;
            this.generativeData = generativeData != null ? generativeData.build() : null;
            this.handleUnionValueChange(Type.GENERATIVE_DATA, oldValue, this.generativeData);
        }

        @Override
        public final Builder generativeData(GenerativeDataDetails generativeData) {
            GenerativeDataDetails oldValue = this.generativeData;
            this.generativeData = generativeData;
            this.handleUnionValueChange(Type.GENERATIVE_DATA, oldValue, this.generativeData);
            return this;
        }

        public final SourceContentDataDetails.Builder getSourceContentData() {
            return this.sourceContentData != null ? this.sourceContentData.toBuilder() : null;
        }

        public final void setSourceContentData(SourceContentDataDetails.BuilderImpl sourceContentData) {
            SourceContentDataDetails oldValue = this.sourceContentData;
            this.sourceContentData = sourceContentData != null ? sourceContentData.build() : null;
            this.handleUnionValueChange(Type.SOURCE_CONTENT_DATA, oldValue, this.sourceContentData);
        }

        @Override
        public final Builder sourceContentData(SourceContentDataDetails sourceContentData) {
            SourceContentDataDetails oldValue = this.sourceContentData;
            this.sourceContentData = sourceContentData;
            this.handleUnionValueChange(Type.SOURCE_CONTENT_DATA, oldValue, this.sourceContentData);
            return this;
        }

        public DataDetails build() {
            return new DataDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataDetails> {
        public Builder contentData(ContentDataDetails var1);

        default public Builder contentData(Consumer<ContentDataDetails.Builder> contentData) {
            return this.contentData((ContentDataDetails)((ContentDataDetails.Builder)ContentDataDetails.builder().applyMutation(contentData)).build());
        }

        public Builder generativeData(GenerativeDataDetails var1);

        default public Builder generativeData(Consumer<GenerativeDataDetails.Builder> generativeData) {
            return this.generativeData((GenerativeDataDetails)((GenerativeDataDetails.Builder)GenerativeDataDetails.builder().applyMutation(generativeData)).build());
        }

        public Builder sourceContentData(SourceContentDataDetails var1);

        default public Builder sourceContentData(Consumer<SourceContentDataDetails.Builder> sourceContentData) {
            return this.sourceContentData((SourceContentDataDetails)((SourceContentDataDetails.Builder)SourceContentDataDetails.builder().applyMutation(sourceContentData)).build());
        }
    }
}

