/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.DataDetails;
import software.amazon.awssdk.services.qconnect.model.DataReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSummary> {
    private static final SdkField<DataDetails> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("details").getter(DataSummary.getter(DataSummary::details)).setter(DataSummary.setter(Builder::details)).constructor(DataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()}).build();
    private static final SdkField<DataReference> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reference").getter(DataSummary.getter(DataSummary::reference)).setter(DataSummary.setter(Builder::reference)).constructor(DataReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, REFERENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final DataDetails details;
    private final DataReference reference;

    private DataSummary(BuilderImpl builder) {
        this.details = builder.details;
        this.reference = builder.reference;
    }

    public final DataDetails details() {
        return this.details;
    }

    public final DataReference reference() {
        return this.reference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.reference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSummary)) {
            return false;
        }
        DataSummary other = (DataSummary)obj;
        return Objects.equals(this.details(), other.details()) && Objects.equals(this.reference(), other.reference());
    }

    public final String toString() {
        return ToString.builder((String)"DataSummary").add("Details", (Object)this.details()).add("Reference", (Object)this.reference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "reference": {
                return Optional.ofNullable(clazz.cast(this.reference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSummary, T> g) {
        return obj -> g.apply((DataSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataDetails details;
        private DataReference reference;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSummary model) {
            this.details(model.details);
            this.reference(model.reference);
        }

        public final DataDetails.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        public final void setDetails(DataDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(DataDetails details) {
            this.details = details;
            return this;
        }

        public final DataReference.Builder getReference() {
            return this.reference != null ? this.reference.toBuilder() : null;
        }

        public final void setReference(DataReference.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(DataReference reference) {
            this.reference = reference;
            return this;
        }

        public DataSummary build() {
            return new DataSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSummary> {
        public Builder details(DataDetails var1);

        default public Builder details(Consumer<DataDetails.Builder> details) {
            return this.details((DataDetails)((DataDetails.Builder)DataDetails.builder().applyMutation(details)).build());
        }

        public Builder reference(DataReference var1);

        default public Builder reference(Consumer<DataReference.Builder> reference) {
            return this.reference((DataReference)((DataReference.Builder)DataReference.builder().applyMutation(reference)).build());
        }
    }
}

