/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.ChannelsCopier;
import software.amazon.awssdk.services.qconnect.model.GroupingConfiguration;
import software.amazon.awssdk.services.qconnect.model.QuickResponseContents;
import software.amazon.awssdk.services.qconnect.model.QuickResponseStatus;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuickResponseData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuickResponseData> {
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("channels").getter(QuickResponseData.getter(QuickResponseData::channels)).setter(QuickResponseData.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(QuickResponseData.getter(QuickResponseData::contentType)).setter(QuickResponseData.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<QuickResponseContents> CONTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contents").getter(QuickResponseData.getter(QuickResponseData::contents)).setter(QuickResponseData.setter(Builder::contents)).constructor(QuickResponseContents::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contents").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(QuickResponseData.getter(QuickResponseData::createdTime)).setter(QuickResponseData.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(QuickResponseData.getter(QuickResponseData::description)).setter(QuickResponseData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groupingConfiguration").getter(QuickResponseData.getter(QuickResponseData::groupingConfiguration)).setter(QuickResponseData.setter(Builder::groupingConfiguration)).constructor(GroupingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isActive").getter(QuickResponseData.getter(QuickResponseData::isActive)).setter(QuickResponseData.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseArn").getter(QuickResponseData.getter(QuickResponseData::knowledgeBaseArn)).setter(QuickResponseData.setter(Builder::knowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(QuickResponseData.getter(QuickResponseData::knowledgeBaseId)).setter(QuickResponseData.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(QuickResponseData.getter(QuickResponseData::language)).setter(QuickResponseData.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastModifiedBy").getter(QuickResponseData.getter(QuickResponseData::lastModifiedBy)).setter(QuickResponseData.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(QuickResponseData.getter(QuickResponseData::lastModifiedTime)).setter(QuickResponseData.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(QuickResponseData.getter(QuickResponseData::name)).setter(QuickResponseData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> QUICK_RESPONSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quickResponseArn").getter(QuickResponseData.getter(QuickResponseData::quickResponseArn)).setter(QuickResponseData.setter(Builder::quickResponseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quickResponseArn").build()}).build();
    private static final SdkField<String> QUICK_RESPONSE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quickResponseId").getter(QuickResponseData.getter(QuickResponseData::quickResponseId)).setter(QuickResponseData.setter(Builder::quickResponseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quickResponseId").build()}).build();
    private static final SdkField<String> SHORTCUT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shortcutKey").getter(QuickResponseData.getter(QuickResponseData::shortcutKey)).setter(QuickResponseData.setter(Builder::shortcutKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortcutKey").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(QuickResponseData.getter(QuickResponseData::statusAsString)).setter(QuickResponseData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(QuickResponseData.getter(QuickResponseData::tags)).setter(QuickResponseData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, CONTENT_TYPE_FIELD, CONTENTS_FIELD, CREATED_TIME_FIELD, DESCRIPTION_FIELD, GROUPING_CONFIGURATION_FIELD, IS_ACTIVE_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, LANGUAGE_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, NAME_FIELD, QUICK_RESPONSE_ARN_FIELD, QUICK_RESPONSE_ID_FIELD, SHORTCUT_KEY_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> channels;
    private final String contentType;
    private final QuickResponseContents contents;
    private final Instant createdTime;
    private final String description;
    private final GroupingConfiguration groupingConfiguration;
    private final Boolean isActive;
    private final String knowledgeBaseArn;
    private final String knowledgeBaseId;
    private final String language;
    private final String lastModifiedBy;
    private final Instant lastModifiedTime;
    private final String name;
    private final String quickResponseArn;
    private final String quickResponseId;
    private final String shortcutKey;
    private final String status;
    private final Map<String, String> tags;

    private QuickResponseData(BuilderImpl builder) {
        this.channels = builder.channels;
        this.contentType = builder.contentType;
        this.contents = builder.contents;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.isActive = builder.isActive;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.language = builder.language;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.name = builder.name;
        this.quickResponseArn = builder.quickResponseArn;
        this.quickResponseId = builder.quickResponseId;
        this.shortcutKey = builder.shortcutKey;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<String> channels() {
        return this.channels;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final QuickResponseContents contents() {
        return this.contents;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String description() {
        return this.description;
    }

    public final GroupingConfiguration groupingConfiguration() {
        return this.groupingConfiguration;
    }

    public final Boolean isActive() {
        return this.isActive;
    }

    public final String knowledgeBaseArn() {
        return this.knowledgeBaseArn;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String language() {
        return this.language;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String quickResponseArn() {
        return this.quickResponseArn;
    }

    public final String quickResponseId() {
        return this.quickResponseId;
    }

    public final String shortcutKey() {
        return this.shortcutKey;
    }

    public final QuickResponseStatus status() {
        return QuickResponseStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.contents());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActive());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickResponseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortcutKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickResponseData)) {
            return false;
        }
        QuickResponseData other = (QuickResponseData)obj;
        return this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.contents(), other.contents()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.groupingConfiguration(), other.groupingConfiguration()) && Objects.equals(this.isActive(), other.isActive()) && Objects.equals(this.knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.quickResponseArn(), other.quickResponseArn()) && Objects.equals(this.quickResponseId(), other.quickResponseId()) && Objects.equals(this.shortcutKey(), other.shortcutKey()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"QuickResponseData").add("Channels", (Object)(this.channels() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).add("Contents", (Object)this.contents()).add("CreatedTime", (Object)this.createdTime()).add("Description", (Object)this.description()).add("GroupingConfiguration", (Object)this.groupingConfiguration()).add("IsActive", (Object)this.isActive()).add("KnowledgeBaseArn", (Object)this.knowledgeBaseArn()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Language", (Object)this.language()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Name", (Object)this.name()).add("QuickResponseArn", (Object)this.quickResponseArn()).add("QuickResponseId", (Object)this.quickResponseId()).add("ShortcutKey", (Object)this.shortcutKey()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "contents": {
                return Optional.ofNullable(clazz.cast(this.contents()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "groupingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.groupingConfiguration()));
            }
            case "isActive": {
                return Optional.ofNullable(clazz.cast(this.isActive()));
            }
            case "knowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseArn()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "lastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "quickResponseArn": {
                return Optional.ofNullable(clazz.cast(this.quickResponseArn()));
            }
            case "quickResponseId": {
                return Optional.ofNullable(clazz.cast(this.quickResponseId()));
            }
            case "shortcutKey": {
                return Optional.ofNullable(clazz.cast(this.shortcutKey()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuickResponseData, T> g) {
        return obj -> g.apply((QuickResponseData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();
        private String contentType;
        private QuickResponseContents contents;
        private Instant createdTime;
        private String description;
        private GroupingConfiguration groupingConfiguration;
        private Boolean isActive;
        private String knowledgeBaseArn;
        private String knowledgeBaseId;
        private String language;
        private String lastModifiedBy;
        private Instant lastModifiedTime;
        private String name;
        private String quickResponseArn;
        private String quickResponseId;
        private String shortcutKey;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuickResponseData model) {
            this.channels(model.channels);
            this.contentType(model.contentType);
            this.contents(model.contents);
            this.createdTime(model.createdTime);
            this.description(model.description);
            this.groupingConfiguration(model.groupingConfiguration);
            this.isActive(model.isActive);
            this.knowledgeBaseArn(model.knowledgeBaseArn);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.language(model.language);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.name(model.name);
            this.quickResponseArn(model.quickResponseArn);
            this.quickResponseId(model.quickResponseId);
            this.shortcutKey(model.shortcutKey);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final Collection<String> getChannels() {
            if (this.channels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(String ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final QuickResponseContents.Builder getContents() {
            return this.contents != null ? this.contents.toBuilder() : null;
        }

        public final void setContents(QuickResponseContents.BuilderImpl contents) {
            this.contents = contents != null ? contents.build() : null;
        }

        @Override
        public final Builder contents(QuickResponseContents contents) {
            this.contents = contents;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return this.groupingConfiguration != null ? this.groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getQuickResponseArn() {
            return this.quickResponseArn;
        }

        public final void setQuickResponseArn(String quickResponseArn) {
            this.quickResponseArn = quickResponseArn;
        }

        @Override
        public final Builder quickResponseArn(String quickResponseArn) {
            this.quickResponseArn = quickResponseArn;
            return this;
        }

        public final String getQuickResponseId() {
            return this.quickResponseId;
        }

        public final void setQuickResponseId(String quickResponseId) {
            this.quickResponseId = quickResponseId;
        }

        @Override
        public final Builder quickResponseId(String quickResponseId) {
            this.quickResponseId = quickResponseId;
            return this;
        }

        public final String getShortcutKey() {
            return this.shortcutKey;
        }

        public final void setShortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
        }

        @Override
        public final Builder shortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QuickResponseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public QuickResponseData build() {
            return new QuickResponseData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuickResponseData> {
        public Builder channels(Collection<String> var1);

        public Builder channels(String ... var1);

        public Builder contentType(String var1);

        public Builder contents(QuickResponseContents var1);

        default public Builder contents(Consumer<QuickResponseContents.Builder> contents) {
            return this.contents((QuickResponseContents)((QuickResponseContents.Builder)QuickResponseContents.builder().applyMutation(contents)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder description(String var1);

        public Builder groupingConfiguration(GroupingConfiguration var1);

        default public Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return this.groupingConfiguration((GroupingConfiguration)((GroupingConfiguration.Builder)GroupingConfiguration.builder().applyMutation(groupingConfiguration)).build());
        }

        public Builder isActive(Boolean var1);

        public Builder knowledgeBaseArn(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder language(String var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder name(String var1);

        public Builder quickResponseArn(String var1);

        public Builder quickResponseId(String var1);

        public Builder shortcutKey(String var1);

        public Builder status(String var1);

        public Builder status(QuickResponseStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

