/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The incremental refresh configuration for a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncrementalRefresh implements SdkPojo, Serializable,
        ToCopyableBuilder<IncrementalRefresh.Builder, IncrementalRefresh> {
    private static final SdkField<LookbackWindow> LOOKBACK_WINDOW_FIELD = SdkField
            .<LookbackWindow> builder(MarshallingType.SDK_POJO).memberName("LookbackWindow")
            .getter(getter(IncrementalRefresh::lookbackWindow)).setter(setter(Builder::lookbackWindow))
            .constructor(LookbackWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackWindow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOOKBACK_WINDOW_FIELD));

    private static final long serialVersionUID = 1L;

    private final LookbackWindow lookbackWindow;

    private IncrementalRefresh(BuilderImpl builder) {
        this.lookbackWindow = builder.lookbackWindow;
    }

    /**
     * <p>
     * The lookback window setup for an incremental refresh configuration.
     * </p>
     * 
     * @return The lookback window setup for an incremental refresh configuration.
     */
    public final LookbackWindow lookbackWindow() {
        return lookbackWindow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lookbackWindow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncrementalRefresh)) {
            return false;
        }
        IncrementalRefresh other = (IncrementalRefresh) obj;
        return Objects.equals(lookbackWindow(), other.lookbackWindow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncrementalRefresh").add("LookbackWindow", lookbackWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LookbackWindow":
            return Optional.ofNullable(clazz.cast(lookbackWindow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncrementalRefresh, T> g) {
        return obj -> g.apply((IncrementalRefresh) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncrementalRefresh> {
        /**
         * <p>
         * The lookback window setup for an incremental refresh configuration.
         * </p>
         * 
         * @param lookbackWindow
         *        The lookback window setup for an incremental refresh configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookbackWindow(LookbackWindow lookbackWindow);

        /**
         * <p>
         * The lookback window setup for an incremental refresh configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LookbackWindow.Builder} avoiding the need
         * to create one manually via {@link LookbackWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LookbackWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #lookbackWindow(LookbackWindow)}.
         * 
         * @param lookbackWindow
         *        a consumer that will call methods on {@link LookbackWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lookbackWindow(LookbackWindow)
         */
        default Builder lookbackWindow(Consumer<LookbackWindow.Builder> lookbackWindow) {
            return lookbackWindow(LookbackWindow.builder().applyMutation(lookbackWindow).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LookbackWindow lookbackWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(IncrementalRefresh model) {
            lookbackWindow(model.lookbackWindow);
        }

        public final LookbackWindow.Builder getLookbackWindow() {
            return lookbackWindow != null ? lookbackWindow.toBuilder() : null;
        }

        public final void setLookbackWindow(LookbackWindow.BuilderImpl lookbackWindow) {
            this.lookbackWindow = lookbackWindow != null ? lookbackWindow.build() : null;
        }

        @Override
        public final Builder lookbackWindow(LookbackWindow lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
            return this;
        }

        @Override
        public IncrementalRefresh build() {
            return new IncrementalRefresh(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
