/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the presentation of a line series in the visual
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineChartSeriesSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<LineChartSeriesSettings.Builder, LineChartSeriesSettings> {
    private static final SdkField<LineChartLineStyleSettings> LINE_STYLE_SETTINGS_FIELD = SdkField
            .<LineChartLineStyleSettings> builder(MarshallingType.SDK_POJO).memberName("LineStyleSettings")
            .getter(getter(LineChartSeriesSettings::lineStyleSettings)).setter(setter(Builder::lineStyleSettings))
            .constructor(LineChartLineStyleSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineStyleSettings").build()).build();

    private static final SdkField<LineChartMarkerStyleSettings> MARKER_STYLE_SETTINGS_FIELD = SdkField
            .<LineChartMarkerStyleSettings> builder(MarshallingType.SDK_POJO).memberName("MarkerStyleSettings")
            .getter(getter(LineChartSeriesSettings::markerStyleSettings)).setter(setter(Builder::markerStyleSettings))
            .constructor(LineChartMarkerStyleSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarkerStyleSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_STYLE_SETTINGS_FIELD,
            MARKER_STYLE_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LineChartLineStyleSettings lineStyleSettings;

    private final LineChartMarkerStyleSettings markerStyleSettings;

    private LineChartSeriesSettings(BuilderImpl builder) {
        this.lineStyleSettings = builder.lineStyleSettings;
        this.markerStyleSettings = builder.markerStyleSettings;
    }

    /**
     * <p>
     * Line styles options for a line series in <code>LineChartVisual</code>.
     * </p>
     * 
     * @return Line styles options for a line series in <code>LineChartVisual</code>.
     */
    public final LineChartLineStyleSettings lineStyleSettings() {
        return lineStyleSettings;
    }

    /**
     * <p>
     * Marker styles options for a line series in <code>LineChartVisual</code>.
     * </p>
     * 
     * @return Marker styles options for a line series in <code>LineChartVisual</code>.
     */
    public final LineChartMarkerStyleSettings markerStyleSettings() {
        return markerStyleSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lineStyleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(markerStyleSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartSeriesSettings)) {
            return false;
        }
        LineChartSeriesSettings other = (LineChartSeriesSettings) obj;
        return Objects.equals(lineStyleSettings(), other.lineStyleSettings())
                && Objects.equals(markerStyleSettings(), other.markerStyleSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineChartSeriesSettings").add("LineStyleSettings", lineStyleSettings())
                .add("MarkerStyleSettings", markerStyleSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LineStyleSettings":
            return Optional.ofNullable(clazz.cast(lineStyleSettings()));
        case "MarkerStyleSettings":
            return Optional.ofNullable(clazz.cast(markerStyleSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineChartSeriesSettings, T> g) {
        return obj -> g.apply((LineChartSeriesSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineChartSeriesSettings> {
        /**
         * <p>
         * Line styles options for a line series in <code>LineChartVisual</code>.
         * </p>
         * 
         * @param lineStyleSettings
         *        Line styles options for a line series in <code>LineChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineStyleSettings(LineChartLineStyleSettings lineStyleSettings);

        /**
         * <p>
         * Line styles options for a line series in <code>LineChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineChartLineStyleSettings.Builder}
         * avoiding the need to create one manually via {@link LineChartLineStyleSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineChartLineStyleSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #lineStyleSettings(LineChartLineStyleSettings)}.
         * 
         * @param lineStyleSettings
         *        a consumer that will call methods on {@link LineChartLineStyleSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineStyleSettings(LineChartLineStyleSettings)
         */
        default Builder lineStyleSettings(Consumer<LineChartLineStyleSettings.Builder> lineStyleSettings) {
            return lineStyleSettings(LineChartLineStyleSettings.builder().applyMutation(lineStyleSettings).build());
        }

        /**
         * <p>
         * Marker styles options for a line series in <code>LineChartVisual</code>.
         * </p>
         * 
         * @param markerStyleSettings
         *        Marker styles options for a line series in <code>LineChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder markerStyleSettings(LineChartMarkerStyleSettings markerStyleSettings);

        /**
         * <p>
         * Marker styles options for a line series in <code>LineChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineChartMarkerStyleSettings.Builder}
         * avoiding the need to create one manually via {@link LineChartMarkerStyleSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineChartMarkerStyleSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #markerStyleSettings(LineChartMarkerStyleSettings)}.
         * 
         * @param markerStyleSettings
         *        a consumer that will call methods on {@link LineChartMarkerStyleSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #markerStyleSettings(LineChartMarkerStyleSettings)
         */
        default Builder markerStyleSettings(Consumer<LineChartMarkerStyleSettings.Builder> markerStyleSettings) {
            return markerStyleSettings(LineChartMarkerStyleSettings.builder().applyMutation(markerStyleSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LineChartLineStyleSettings lineStyleSettings;

        private LineChartMarkerStyleSettings markerStyleSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(LineChartSeriesSettings model) {
            lineStyleSettings(model.lineStyleSettings);
            markerStyleSettings(model.markerStyleSettings);
        }

        public final LineChartLineStyleSettings.Builder getLineStyleSettings() {
            return lineStyleSettings != null ? lineStyleSettings.toBuilder() : null;
        }

        public final void setLineStyleSettings(LineChartLineStyleSettings.BuilderImpl lineStyleSettings) {
            this.lineStyleSettings = lineStyleSettings != null ? lineStyleSettings.build() : null;
        }

        @Override
        public final Builder lineStyleSettings(LineChartLineStyleSettings lineStyleSettings) {
            this.lineStyleSettings = lineStyleSettings;
            return this;
        }

        public final LineChartMarkerStyleSettings.Builder getMarkerStyleSettings() {
            return markerStyleSettings != null ? markerStyleSettings.toBuilder() : null;
        }

        public final void setMarkerStyleSettings(LineChartMarkerStyleSettings.BuilderImpl markerStyleSettings) {
            this.markerStyleSettings = markerStyleSettings != null ? markerStyleSettings.build() : null;
        }

        @Override
        public final Builder markerStyleSettings(LineChartMarkerStyleSettings markerStyleSettings) {
            this.markerStyleSettings = markerStyleSettings;
            return this;
        }

        @Override
        public LineChartSeriesSettings build() {
            return new LineChartSeriesSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
