/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reference line visual display options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceLine implements SdkPojo, Serializable, ToCopyableBuilder<ReferenceLine.Builder, ReferenceLine> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReferenceLine::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ReferenceLineDataConfiguration> DATA_CONFIGURATION_FIELD = SdkField
            .<ReferenceLineDataConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataConfiguration")
            .getter(getter(ReferenceLine::dataConfiguration)).setter(setter(Builder::dataConfiguration))
            .constructor(ReferenceLineDataConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataConfiguration").build()).build();

    private static final SdkField<ReferenceLineStyleConfiguration> STYLE_CONFIGURATION_FIELD = SdkField
            .<ReferenceLineStyleConfiguration> builder(MarshallingType.SDK_POJO).memberName("StyleConfiguration")
            .getter(getter(ReferenceLine::styleConfiguration)).setter(setter(Builder::styleConfiguration))
            .constructor(ReferenceLineStyleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StyleConfiguration").build())
            .build();

    private static final SdkField<ReferenceLineLabelConfiguration> LABEL_CONFIGURATION_FIELD = SdkField
            .<ReferenceLineLabelConfiguration> builder(MarshallingType.SDK_POJO).memberName("LabelConfiguration")
            .getter(getter(ReferenceLine::labelConfiguration)).setter(setter(Builder::labelConfiguration))
            .constructor(ReferenceLineLabelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            DATA_CONFIGURATION_FIELD, STYLE_CONFIGURATION_FIELD, LABEL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final ReferenceLineDataConfiguration dataConfiguration;

    private final ReferenceLineStyleConfiguration styleConfiguration;

    private final ReferenceLineLabelConfiguration labelConfiguration;

    private ReferenceLine(BuilderImpl builder) {
        this.status = builder.status;
        this.dataConfiguration = builder.dataConfiguration;
        this.styleConfiguration = builder.styleConfiguration;
        this.labelConfiguration = builder.labelConfiguration;
    }

    /**
     * <p>
     * The status of the reference line. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLE</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the reference line. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLE</code>
     *         </p>
     *         </li>
     * @see WidgetStatus
     */
    public final WidgetStatus status() {
        return WidgetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the reference line. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLE</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the reference line. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLE</code>
     *         </p>
     *         </li>
     * @see WidgetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The data configuration of the reference line.
     * </p>
     * 
     * @return The data configuration of the reference line.
     */
    public final ReferenceLineDataConfiguration dataConfiguration() {
        return dataConfiguration;
    }

    /**
     * <p>
     * The style configuration of the reference line.
     * </p>
     * 
     * @return The style configuration of the reference line.
     */
    public final ReferenceLineStyleConfiguration styleConfiguration() {
        return styleConfiguration;
    }

    /**
     * <p>
     * The label configuration of the reference line.
     * </p>
     * 
     * @return The label configuration of the reference line.
     */
    public final ReferenceLineLabelConfiguration labelConfiguration() {
        return labelConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(styleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(labelConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLine)) {
            return false;
        }
        ReferenceLine other = (ReferenceLine) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(dataConfiguration(), other.dataConfiguration())
                && Objects.equals(styleConfiguration(), other.styleConfiguration())
                && Objects.equals(labelConfiguration(), other.labelConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceLine").add("Status", statusAsString()).add("DataConfiguration", dataConfiguration())
                .add("StyleConfiguration", styleConfiguration()).add("LabelConfiguration", labelConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DataConfiguration":
            return Optional.ofNullable(clazz.cast(dataConfiguration()));
        case "StyleConfiguration":
            return Optional.ofNullable(clazz.cast(styleConfiguration()));
        case "LabelConfiguration":
            return Optional.ofNullable(clazz.cast(labelConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLine, T> g) {
        return obj -> g.apply((ReferenceLine) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceLine> {
        /**
         * <p>
         * The status of the reference line. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the reference line. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLE</code>
         *        </p>
         *        </li>
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the reference line. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the reference line. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLE</code>
         *        </p>
         *        </li>
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder status(WidgetStatus status);

        /**
         * <p>
         * The data configuration of the reference line.
         * </p>
         * 
         * @param dataConfiguration
         *        The data configuration of the reference line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataConfiguration(ReferenceLineDataConfiguration dataConfiguration);

        /**
         * <p>
         * The data configuration of the reference line.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferenceLineDataConfiguration.Builder}
         * avoiding the need to create one manually via {@link ReferenceLineDataConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceLineDataConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataConfiguration(ReferenceLineDataConfiguration)}.
         * 
         * @param dataConfiguration
         *        a consumer that will call methods on {@link ReferenceLineDataConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataConfiguration(ReferenceLineDataConfiguration)
         */
        default Builder dataConfiguration(Consumer<ReferenceLineDataConfiguration.Builder> dataConfiguration) {
            return dataConfiguration(ReferenceLineDataConfiguration.builder().applyMutation(dataConfiguration).build());
        }

        /**
         * <p>
         * The style configuration of the reference line.
         * </p>
         * 
         * @param styleConfiguration
         *        The style configuration of the reference line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder styleConfiguration(ReferenceLineStyleConfiguration styleConfiguration);

        /**
         * <p>
         * The style configuration of the reference line.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferenceLineStyleConfiguration.Builder}
         * avoiding the need to create one manually via {@link ReferenceLineStyleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceLineStyleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #styleConfiguration(ReferenceLineStyleConfiguration)}.
         * 
         * @param styleConfiguration
         *        a consumer that will call methods on {@link ReferenceLineStyleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #styleConfiguration(ReferenceLineStyleConfiguration)
         */
        default Builder styleConfiguration(Consumer<ReferenceLineStyleConfiguration.Builder> styleConfiguration) {
            return styleConfiguration(ReferenceLineStyleConfiguration.builder().applyMutation(styleConfiguration).build());
        }

        /**
         * <p>
         * The label configuration of the reference line.
         * </p>
         * 
         * @param labelConfiguration
         *        The label configuration of the reference line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelConfiguration(ReferenceLineLabelConfiguration labelConfiguration);

        /**
         * <p>
         * The label configuration of the reference line.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferenceLineLabelConfiguration.Builder}
         * avoiding the need to create one manually via {@link ReferenceLineLabelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceLineLabelConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #labelConfiguration(ReferenceLineLabelConfiguration)}.
         * 
         * @param labelConfiguration
         *        a consumer that will call methods on {@link ReferenceLineLabelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelConfiguration(ReferenceLineLabelConfiguration)
         */
        default Builder labelConfiguration(Consumer<ReferenceLineLabelConfiguration.Builder> labelConfiguration) {
            return labelConfiguration(ReferenceLineLabelConfiguration.builder().applyMutation(labelConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private ReferenceLineDataConfiguration dataConfiguration;

        private ReferenceLineStyleConfiguration styleConfiguration;

        private ReferenceLineLabelConfiguration labelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLine model) {
            status(model.status);
            dataConfiguration(model.dataConfiguration);
            styleConfiguration(model.styleConfiguration);
            labelConfiguration(model.labelConfiguration);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WidgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ReferenceLineDataConfiguration.Builder getDataConfiguration() {
            return dataConfiguration != null ? dataConfiguration.toBuilder() : null;
        }

        public final void setDataConfiguration(ReferenceLineDataConfiguration.BuilderImpl dataConfiguration) {
            this.dataConfiguration = dataConfiguration != null ? dataConfiguration.build() : null;
        }

        @Override
        public final Builder dataConfiguration(ReferenceLineDataConfiguration dataConfiguration) {
            this.dataConfiguration = dataConfiguration;
            return this;
        }

        public final ReferenceLineStyleConfiguration.Builder getStyleConfiguration() {
            return styleConfiguration != null ? styleConfiguration.toBuilder() : null;
        }

        public final void setStyleConfiguration(ReferenceLineStyleConfiguration.BuilderImpl styleConfiguration) {
            this.styleConfiguration = styleConfiguration != null ? styleConfiguration.build() : null;
        }

        @Override
        public final Builder styleConfiguration(ReferenceLineStyleConfiguration styleConfiguration) {
            this.styleConfiguration = styleConfiguration;
            return this;
        }

        public final ReferenceLineLabelConfiguration.Builder getLabelConfiguration() {
            return labelConfiguration != null ? labelConfiguration.toBuilder() : null;
        }

        public final void setLabelConfiguration(ReferenceLineLabelConfiguration.BuilderImpl labelConfiguration) {
            this.labelConfiguration = labelConfiguration != null ? labelConfiguration.build() : null;
        }

        @Override
        public final Builder labelConfiguration(ReferenceLineLabelConfiguration labelConfiguration) {
            this.labelConfiguration = labelConfiguration;
            return this;
        }

        @Override
        public ReferenceLine build() {
            return new ReferenceLine(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
