/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the same-sheet target visuals that you want to be filtered.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SameSheetTargetVisualConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SameSheetTargetVisualConfiguration.Builder, SameSheetTargetVisualConfiguration> {
    private static final SdkField<List<String>> TARGET_VISUALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetVisuals")
            .getter(getter(SameSheetTargetVisualConfiguration::targetVisuals))
            .setter(setter(Builder::targetVisuals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVisuals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_VISUAL_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetVisualOptions").getter(getter(SameSheetTargetVisualConfiguration::targetVisualOptionsAsString))
            .setter(setter(Builder::targetVisualOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVisualOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_VISUALS_FIELD,
            TARGET_VISUAL_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> targetVisuals;

    private final String targetVisualOptions;

    private SameSheetTargetVisualConfiguration(BuilderImpl builder) {
        this.targetVisuals = builder.targetVisuals;
        this.targetVisualOptions = builder.targetVisualOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetVisuals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetVisuals() {
        return targetVisuals != null && !(targetVisuals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the target visual IDs that are located in the same sheet of the analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetVisuals} method.
     * </p>
     * 
     * @return A list of the target visual IDs that are located in the same sheet of the analysis.
     */
    public final List<String> targetVisuals() {
        return targetVisuals;
    }

    /**
     * <p>
     * The options that choose the target visual in the same sheet.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VISUALS</code>: Applies the filter operation to all visuals in the same sheet.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetVisualOptions} will return {@link TargetVisualOptions#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetVisualOptionsAsString}.
     * </p>
     * 
     * @return The options that choose the target visual in the same sheet.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VISUALS</code>: Applies the filter operation to all visuals in the same sheet.
     *         </p>
     *         </li>
     * @see TargetVisualOptions
     */
    public final TargetVisualOptions targetVisualOptions() {
        return TargetVisualOptions.fromValue(targetVisualOptions);
    }

    /**
     * <p>
     * The options that choose the target visual in the same sheet.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VISUALS</code>: Applies the filter operation to all visuals in the same sheet.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetVisualOptions} will return {@link TargetVisualOptions#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetVisualOptionsAsString}.
     * </p>
     * 
     * @return The options that choose the target visual in the same sheet.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VISUALS</code>: Applies the filter operation to all visuals in the same sheet.
     *         </p>
     *         </li>
     * @see TargetVisualOptions
     */
    public final String targetVisualOptionsAsString() {
        return targetVisualOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetVisuals() ? targetVisuals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetVisualOptionsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SameSheetTargetVisualConfiguration)) {
            return false;
        }
        SameSheetTargetVisualConfiguration other = (SameSheetTargetVisualConfiguration) obj;
        return hasTargetVisuals() == other.hasTargetVisuals() && Objects.equals(targetVisuals(), other.targetVisuals())
                && Objects.equals(targetVisualOptionsAsString(), other.targetVisualOptionsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SameSheetTargetVisualConfiguration")
                .add("TargetVisuals", hasTargetVisuals() ? targetVisuals() : null)
                .add("TargetVisualOptions", targetVisualOptionsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetVisuals":
            return Optional.ofNullable(clazz.cast(targetVisuals()));
        case "TargetVisualOptions":
            return Optional.ofNullable(clazz.cast(targetVisualOptionsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SameSheetTargetVisualConfiguration, T> g) {
        return obj -> g.apply((SameSheetTargetVisualConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SameSheetTargetVisualConfiguration> {
        /**
         * <p>
         * A list of the target visual IDs that are located in the same sheet of the analysis.
         * </p>
         * 
         * @param targetVisuals
         *        A list of the target visual IDs that are located in the same sheet of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVisuals(Collection<String> targetVisuals);

        /**
         * <p>
         * A list of the target visual IDs that are located in the same sheet of the analysis.
         * </p>
         * 
         * @param targetVisuals
         *        A list of the target visual IDs that are located in the same sheet of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVisuals(String... targetVisuals);

        /**
         * <p>
         * The options that choose the target visual in the same sheet.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VISUALS</code>: Applies the filter operation to all visuals in the same sheet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetVisualOptions
         *        The options that choose the target visual in the same sheet.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VISUALS</code>: Applies the filter operation to all visuals in the same sheet.
         *        </p>
         *        </li>
         * @see TargetVisualOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetVisualOptions
         */
        Builder targetVisualOptions(String targetVisualOptions);

        /**
         * <p>
         * The options that choose the target visual in the same sheet.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VISUALS</code>: Applies the filter operation to all visuals in the same sheet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetVisualOptions
         *        The options that choose the target visual in the same sheet.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VISUALS</code>: Applies the filter operation to all visuals in the same sheet.
         *        </p>
         *        </li>
         * @see TargetVisualOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetVisualOptions
         */
        Builder targetVisualOptions(TargetVisualOptions targetVisualOptions);
    }

    static final class BuilderImpl implements Builder {
        private List<String> targetVisuals = DefaultSdkAutoConstructList.getInstance();

        private String targetVisualOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SameSheetTargetVisualConfiguration model) {
            targetVisuals(model.targetVisuals);
            targetVisualOptions(model.targetVisualOptions);
        }

        public final Collection<String> getTargetVisuals() {
            if (targetVisuals instanceof SdkAutoConstructList) {
                return null;
            }
            return targetVisuals;
        }

        public final void setTargetVisuals(Collection<String> targetVisuals) {
            this.targetVisuals = TargetVisualListCopier.copy(targetVisuals);
        }

        @Override
        public final Builder targetVisuals(Collection<String> targetVisuals) {
            this.targetVisuals = TargetVisualListCopier.copy(targetVisuals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetVisuals(String... targetVisuals) {
            targetVisuals(Arrays.asList(targetVisuals));
            return this;
        }

        public final String getTargetVisualOptions() {
            return targetVisualOptions;
        }

        public final void setTargetVisualOptions(String targetVisualOptions) {
            this.targetVisualOptions = targetVisualOptions;
        }

        @Override
        public final Builder targetVisualOptions(String targetVisualOptions) {
            this.targetVisualOptions = targetVisualOptions;
            return this;
        }

        @Override
        public final Builder targetVisualOptions(TargetVisualOptions targetVisualOptions) {
            this.targetVisualOptions(targetVisualOptions == null ? null : targetVisualOptions.toString());
            return this;
        }

        @Override
        public SameSheetTargetVisualConfiguration build() {
            return new SameSheetTargetVisualConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
