/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CategoryFilterType {
    CUSTOM_FILTER("CUSTOM_FILTER"),
    CUSTOM_FILTER_LIST("CUSTOM_FILTER_LIST"),
    FILTER_LIST("FILTER_LIST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CategoryFilterType> VALUE_MAP;
    private final String value;

    private CategoryFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CategoryFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CategoryFilterType> knownValues() {
        EnumSet<CategoryFilterType> knownValues = EnumSet.allOf(CategoryFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CategoryFilterType.class, CategoryFilterType::toString);
    }
}

