/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.NamedFilterAggType;
import software.amazon.awssdk.services.quicksight.model.TopicSingularFilterConstant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicNumericEqualityFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicNumericEqualityFilter> {
    private static final SdkField<TopicSingularFilterConstant> CONSTANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Constant").getter(TopicNumericEqualityFilter.getter(TopicNumericEqualityFilter::constant)).setter(TopicNumericEqualityFilter.setter(Builder::constant)).constructor(TopicSingularFilterConstant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constant").build()}).build();
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Aggregation").getter(TopicNumericEqualityFilter.getter(TopicNumericEqualityFilter::aggregationAsString)).setter(TopicNumericEqualityFilter.setter(Builder::aggregation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_FIELD, AGGREGATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final TopicSingularFilterConstant constant;
    private final String aggregation;

    private TopicNumericEqualityFilter(BuilderImpl builder) {
        this.constant = builder.constant;
        this.aggregation = builder.aggregation;
    }

    public final TopicSingularFilterConstant constant() {
        return this.constant;
    }

    public final NamedFilterAggType aggregation() {
        return NamedFilterAggType.fromValue(this.aggregation);
    }

    public final String aggregationAsString() {
        return this.aggregation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constant());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicNumericEqualityFilter)) {
            return false;
        }
        TopicNumericEqualityFilter other = (TopicNumericEqualityFilter)obj;
        return Objects.equals(this.constant(), other.constant()) && Objects.equals(this.aggregationAsString(), other.aggregationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TopicNumericEqualityFilter").add("Constant", (Object)(this.constant() == null ? null : "*** Sensitive Data Redacted ***")).add("Aggregation", (Object)this.aggregationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Constant": {
                return Optional.ofNullable(clazz.cast(this.constant()));
            }
            case "Aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicNumericEqualityFilter, T> g) {
        return obj -> g.apply((TopicNumericEqualityFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TopicSingularFilterConstant constant;
        private String aggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicNumericEqualityFilter model) {
            this.constant(model.constant);
            this.aggregation(model.aggregation);
        }

        public final TopicSingularFilterConstant.Builder getConstant() {
            return this.constant != null ? this.constant.toBuilder() : null;
        }

        public final void setConstant(TopicSingularFilterConstant.BuilderImpl constant) {
            this.constant = constant != null ? constant.build() : null;
        }

        @Override
        public final Builder constant(TopicSingularFilterConstant constant) {
            this.constant = constant;
            return this;
        }

        public final String getAggregation() {
            return this.aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(NamedFilterAggType aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public TopicNumericEqualityFilter build() {
            return new TopicNumericEqualityFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicNumericEqualityFilter> {
        public Builder constant(TopicSingularFilterConstant var1);

        default public Builder constant(Consumer<TopicSingularFilterConstant.Builder> constant) {
            return this.constant((TopicSingularFilterConstant)((TopicSingularFilterConstant.Builder)TopicSingularFilterConstant.builder().applyMutation(constant)).build());
        }

        public Builder aggregation(String var1);

        public Builder aggregation(NamedFilterAggType var1);
    }
}

