/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.VPCConnection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcConnectionResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeVpcConnectionResponse> {
    private static final SdkField<VPCConnection> VPC_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VPCConnection").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::vpcConnection)).setter(DescribeVpcConnectionResponse.setter(Builder::vpcConnection)).constructor(VPCConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnection").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::requestId)).setter(DescribeVpcConnectionResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::status)).setter(DescribeVpcConnectionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final VPCConnection vpcConnection;
    private final String requestId;
    private final Integer status;

    private DescribeVpcConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.vpcConnection = builder.vpcConnection;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final VPCConnection vpcConnection() {
        return this.vpcConnection;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnection());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcConnectionResponse)) {
            return false;
        }
        DescribeVpcConnectionResponse other = (DescribeVpcConnectionResponse)((Object)obj);
        return Objects.equals(this.vpcConnection(), other.vpcConnection()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcConnectionResponse").add("VPCConnection", (Object)this.vpcConnection()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VPCConnection": {
                return Optional.ofNullable(clazz.cast(this.vpcConnection()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcConnectionResponse, T> g) {
        return obj -> g.apply((DescribeVpcConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private VPCConnection vpcConnection;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcConnectionResponse model) {
            super(model);
            this.vpcConnection(model.vpcConnection);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final VPCConnection.Builder getVpcConnection() {
            return this.vpcConnection != null ? this.vpcConnection.toBuilder() : null;
        }

        public final void setVpcConnection(VPCConnection.BuilderImpl vpcConnection) {
            this.vpcConnection = vpcConnection != null ? vpcConnection.build() : null;
        }

        @Override
        public final Builder vpcConnection(VPCConnection vpcConnection) {
            this.vpcConnection = vpcConnection;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeVpcConnectionResponse build() {
            return new DescribeVpcConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcConnectionResponse> {
        public Builder vpcConnection(VPCConnection var1);

        default public Builder vpcConnection(Consumer<VPCConnection.Builder> vpcConnection) {
            return this.vpcConnection((VPCConnection)((VPCConnection.Builder)VPCConnection.builder().applyMutation(vpcConnection)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

