/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.TableCellStyle;
import software.amazon.awssdk.services.quicksight.model.TableTotalsPlacement;
import software.amazon.awssdk.services.quicksight.model.TableTotalsScrollStatus;
import software.amazon.awssdk.services.quicksight.model.TotalAggregationOption;
import software.amazon.awssdk.services.quicksight.model.TotalAggregationOptionListCopier;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PivotTotalOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PivotTotalOptions> {
    private static final SdkField<String> TOTALS_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalsVisibility").getter(PivotTotalOptions.getter(PivotTotalOptions::totalsVisibilityAsString)).setter(PivotTotalOptions.setter(Builder::totalsVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalsVisibility").build()}).build();
    private static final SdkField<String> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Placement").getter(PivotTotalOptions.getter(PivotTotalOptions::placementAsString)).setter(PivotTotalOptions.setter(Builder::placement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()}).build();
    private static final SdkField<String> SCROLL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScrollStatus").getter(PivotTotalOptions.getter(PivotTotalOptions::scrollStatusAsString)).setter(PivotTotalOptions.setter(Builder::scrollStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScrollStatus").build()}).build();
    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomLabel").getter(PivotTotalOptions.getter(PivotTotalOptions::customLabel)).setter(PivotTotalOptions.setter(Builder::customLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()}).build();
    private static final SdkField<TableCellStyle> TOTAL_CELL_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TotalCellStyle").getter(PivotTotalOptions.getter(PivotTotalOptions::totalCellStyle)).setter(PivotTotalOptions.setter(Builder::totalCellStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCellStyle").build()}).build();
    private static final SdkField<TableCellStyle> VALUE_CELL_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueCellStyle").getter(PivotTotalOptions.getter(PivotTotalOptions::valueCellStyle)).setter(PivotTotalOptions.setter(Builder::valueCellStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueCellStyle").build()}).build();
    private static final SdkField<TableCellStyle> METRIC_HEADER_CELL_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricHeaderCellStyle").getter(PivotTotalOptions.getter(PivotTotalOptions::metricHeaderCellStyle)).setter(PivotTotalOptions.setter(Builder::metricHeaderCellStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricHeaderCellStyle").build()}).build();
    private static final SdkField<List<TotalAggregationOption>> TOTAL_AGGREGATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TotalAggregationOptions").getter(PivotTotalOptions.getter(PivotTotalOptions::totalAggregationOptions)).setter(PivotTotalOptions.setter(Builder::totalAggregationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAggregationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TotalAggregationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTALS_VISIBILITY_FIELD, PLACEMENT_FIELD, SCROLL_STATUS_FIELD, CUSTOM_LABEL_FIELD, TOTAL_CELL_STYLE_FIELD, VALUE_CELL_STYLE_FIELD, METRIC_HEADER_CELL_STYLE_FIELD, TOTAL_AGGREGATION_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String totalsVisibility;
    private final String placement;
    private final String scrollStatus;
    private final String customLabel;
    private final TableCellStyle totalCellStyle;
    private final TableCellStyle valueCellStyle;
    private final TableCellStyle metricHeaderCellStyle;
    private final List<TotalAggregationOption> totalAggregationOptions;

    private PivotTotalOptions(BuilderImpl builder) {
        this.totalsVisibility = builder.totalsVisibility;
        this.placement = builder.placement;
        this.scrollStatus = builder.scrollStatus;
        this.customLabel = builder.customLabel;
        this.totalCellStyle = builder.totalCellStyle;
        this.valueCellStyle = builder.valueCellStyle;
        this.metricHeaderCellStyle = builder.metricHeaderCellStyle;
        this.totalAggregationOptions = builder.totalAggregationOptions;
    }

    public final Visibility totalsVisibility() {
        return Visibility.fromValue(this.totalsVisibility);
    }

    public final String totalsVisibilityAsString() {
        return this.totalsVisibility;
    }

    public final TableTotalsPlacement placement() {
        return TableTotalsPlacement.fromValue(this.placement);
    }

    public final String placementAsString() {
        return this.placement;
    }

    public final TableTotalsScrollStatus scrollStatus() {
        return TableTotalsScrollStatus.fromValue(this.scrollStatus);
    }

    public final String scrollStatusAsString() {
        return this.scrollStatus;
    }

    public final String customLabel() {
        return this.customLabel;
    }

    public final TableCellStyle totalCellStyle() {
        return this.totalCellStyle;
    }

    public final TableCellStyle valueCellStyle() {
        return this.valueCellStyle;
    }

    public final TableCellStyle metricHeaderCellStyle() {
        return this.metricHeaderCellStyle;
    }

    public final boolean hasTotalAggregationOptions() {
        return this.totalAggregationOptions != null && !(this.totalAggregationOptions instanceof SdkAutoConstructList);
    }

    public final List<TotalAggregationOption> totalAggregationOptions() {
        return this.totalAggregationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalsVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scrollStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricHeaderCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTotalAggregationOptions() ? this.totalAggregationOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTotalOptions)) {
            return false;
        }
        PivotTotalOptions other = (PivotTotalOptions)obj;
        return Objects.equals(this.totalsVisibilityAsString(), other.totalsVisibilityAsString()) && Objects.equals(this.placementAsString(), other.placementAsString()) && Objects.equals(this.scrollStatusAsString(), other.scrollStatusAsString()) && Objects.equals(this.customLabel(), other.customLabel()) && Objects.equals(this.totalCellStyle(), other.totalCellStyle()) && Objects.equals(this.valueCellStyle(), other.valueCellStyle()) && Objects.equals(this.metricHeaderCellStyle(), other.metricHeaderCellStyle()) && this.hasTotalAggregationOptions() == other.hasTotalAggregationOptions() && Objects.equals(this.totalAggregationOptions(), other.totalAggregationOptions());
    }

    public final String toString() {
        return ToString.builder((String)"PivotTotalOptions").add("TotalsVisibility", (Object)this.totalsVisibilityAsString()).add("Placement", (Object)this.placementAsString()).add("ScrollStatus", (Object)this.scrollStatusAsString()).add("CustomLabel", (Object)this.customLabel()).add("TotalCellStyle", (Object)this.totalCellStyle()).add("ValueCellStyle", (Object)this.valueCellStyle()).add("MetricHeaderCellStyle", (Object)this.metricHeaderCellStyle()).add("TotalAggregationOptions", this.hasTotalAggregationOptions() ? this.totalAggregationOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalsVisibility": {
                return Optional.ofNullable(clazz.cast(this.totalsVisibilityAsString()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placementAsString()));
            }
            case "ScrollStatus": {
                return Optional.ofNullable(clazz.cast(this.scrollStatusAsString()));
            }
            case "CustomLabel": {
                return Optional.ofNullable(clazz.cast(this.customLabel()));
            }
            case "TotalCellStyle": {
                return Optional.ofNullable(clazz.cast(this.totalCellStyle()));
            }
            case "ValueCellStyle": {
                return Optional.ofNullable(clazz.cast(this.valueCellStyle()));
            }
            case "MetricHeaderCellStyle": {
                return Optional.ofNullable(clazz.cast(this.metricHeaderCellStyle()));
            }
            case "TotalAggregationOptions": {
                return Optional.ofNullable(clazz.cast(this.totalAggregationOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PivotTotalOptions, T> g) {
        return obj -> g.apply((PivotTotalOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String totalsVisibility;
        private String placement;
        private String scrollStatus;
        private String customLabel;
        private TableCellStyle totalCellStyle;
        private TableCellStyle valueCellStyle;
        private TableCellStyle metricHeaderCellStyle;
        private List<TotalAggregationOption> totalAggregationOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTotalOptions model) {
            this.totalsVisibility(model.totalsVisibility);
            this.placement(model.placement);
            this.scrollStatus(model.scrollStatus);
            this.customLabel(model.customLabel);
            this.totalCellStyle(model.totalCellStyle);
            this.valueCellStyle(model.valueCellStyle);
            this.metricHeaderCellStyle(model.metricHeaderCellStyle);
            this.totalAggregationOptions(model.totalAggregationOptions);
        }

        public final String getTotalsVisibility() {
            return this.totalsVisibility;
        }

        public final void setTotalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
        }

        @Override
        public final Builder totalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
            return this;
        }

        @Override
        public final Builder totalsVisibility(Visibility totalsVisibility) {
            this.totalsVisibility(totalsVisibility == null ? null : totalsVisibility.toString());
            return this;
        }

        public final String getPlacement() {
            return this.placement;
        }

        public final void setPlacement(String placement) {
            this.placement = placement;
        }

        @Override
        public final Builder placement(String placement) {
            this.placement = placement;
            return this;
        }

        @Override
        public final Builder placement(TableTotalsPlacement placement) {
            this.placement(placement == null ? null : placement.toString());
            return this;
        }

        public final String getScrollStatus() {
            return this.scrollStatus;
        }

        public final void setScrollStatus(String scrollStatus) {
            this.scrollStatus = scrollStatus;
        }

        @Override
        public final Builder scrollStatus(String scrollStatus) {
            this.scrollStatus = scrollStatus;
            return this;
        }

        @Override
        public final Builder scrollStatus(TableTotalsScrollStatus scrollStatus) {
            this.scrollStatus(scrollStatus == null ? null : scrollStatus.toString());
            return this;
        }

        public final String getCustomLabel() {
            return this.customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public final TableCellStyle.Builder getTotalCellStyle() {
            return this.totalCellStyle != null ? this.totalCellStyle.toBuilder() : null;
        }

        public final void setTotalCellStyle(TableCellStyle.BuilderImpl totalCellStyle) {
            this.totalCellStyle = totalCellStyle != null ? totalCellStyle.build() : null;
        }

        @Override
        public final Builder totalCellStyle(TableCellStyle totalCellStyle) {
            this.totalCellStyle = totalCellStyle;
            return this;
        }

        public final TableCellStyle.Builder getValueCellStyle() {
            return this.valueCellStyle != null ? this.valueCellStyle.toBuilder() : null;
        }

        public final void setValueCellStyle(TableCellStyle.BuilderImpl valueCellStyle) {
            this.valueCellStyle = valueCellStyle != null ? valueCellStyle.build() : null;
        }

        @Override
        public final Builder valueCellStyle(TableCellStyle valueCellStyle) {
            this.valueCellStyle = valueCellStyle;
            return this;
        }

        public final TableCellStyle.Builder getMetricHeaderCellStyle() {
            return this.metricHeaderCellStyle != null ? this.metricHeaderCellStyle.toBuilder() : null;
        }

        public final void setMetricHeaderCellStyle(TableCellStyle.BuilderImpl metricHeaderCellStyle) {
            this.metricHeaderCellStyle = metricHeaderCellStyle != null ? metricHeaderCellStyle.build() : null;
        }

        @Override
        public final Builder metricHeaderCellStyle(TableCellStyle metricHeaderCellStyle) {
            this.metricHeaderCellStyle = metricHeaderCellStyle;
            return this;
        }

        public final List<TotalAggregationOption.Builder> getTotalAggregationOptions() {
            List<TotalAggregationOption.Builder> result = TotalAggregationOptionListCopier.copyToBuilder(this.totalAggregationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTotalAggregationOptions(Collection<TotalAggregationOption.BuilderImpl> totalAggregationOptions) {
            this.totalAggregationOptions = TotalAggregationOptionListCopier.copyFromBuilder(totalAggregationOptions);
        }

        @Override
        public final Builder totalAggregationOptions(Collection<TotalAggregationOption> totalAggregationOptions) {
            this.totalAggregationOptions = TotalAggregationOptionListCopier.copy(totalAggregationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalAggregationOptions(TotalAggregationOption ... totalAggregationOptions) {
            this.totalAggregationOptions(Arrays.asList(totalAggregationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalAggregationOptions(Consumer<TotalAggregationOption.Builder> ... totalAggregationOptions) {
            this.totalAggregationOptions(Stream.of(totalAggregationOptions).map(c -> (TotalAggregationOption)((TotalAggregationOption.Builder)TotalAggregationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PivotTotalOptions build() {
            return new PivotTotalOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PivotTotalOptions> {
        public Builder totalsVisibility(String var1);

        public Builder totalsVisibility(Visibility var1);

        public Builder placement(String var1);

        public Builder placement(TableTotalsPlacement var1);

        public Builder scrollStatus(String var1);

        public Builder scrollStatus(TableTotalsScrollStatus var1);

        public Builder customLabel(String var1);

        public Builder totalCellStyle(TableCellStyle var1);

        default public Builder totalCellStyle(Consumer<TableCellStyle.Builder> totalCellStyle) {
            return this.totalCellStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(totalCellStyle)).build());
        }

        public Builder valueCellStyle(TableCellStyle var1);

        default public Builder valueCellStyle(Consumer<TableCellStyle.Builder> valueCellStyle) {
            return this.valueCellStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(valueCellStyle)).build());
        }

        public Builder metricHeaderCellStyle(TableCellStyle var1);

        default public Builder metricHeaderCellStyle(Consumer<TableCellStyle.Builder> metricHeaderCellStyle) {
            return this.metricHeaderCellStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(metricHeaderCellStyle)).build());
        }

        public Builder totalAggregationOptions(Collection<TotalAggregationOption> var1);

        public Builder totalAggregationOptions(TotalAggregationOption ... var1);

        public Builder totalAggregationOptions(Consumer<TotalAggregationOption.Builder> ... var1);
    }
}

