/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ReferenceLinePatternType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceLineStyleConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceLineStyleConfiguration> {
    private static final SdkField<String> PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Pattern").getter(ReferenceLineStyleConfiguration.getter(ReferenceLineStyleConfiguration::patternAsString)).setter(ReferenceLineStyleConfiguration.setter(Builder::pattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()}).build();
    private static final SdkField<String> COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Color").getter(ReferenceLineStyleConfiguration.getter(ReferenceLineStyleConfiguration::color)).setter(ReferenceLineStyleConfiguration.setter(Builder::color)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATTERN_FIELD, COLOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pattern;
    private final String color;

    private ReferenceLineStyleConfiguration(BuilderImpl builder) {
        this.pattern = builder.pattern;
        this.color = builder.color;
    }

    public final ReferenceLinePatternType pattern() {
        return ReferenceLinePatternType.fromValue(this.pattern);
    }

    public final String patternAsString() {
        return this.pattern;
    }

    public final String color() {
        return this.color;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patternAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.color());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLineStyleConfiguration)) {
            return false;
        }
        ReferenceLineStyleConfiguration other = (ReferenceLineStyleConfiguration)obj;
        return Objects.equals(this.patternAsString(), other.patternAsString()) && Objects.equals(this.color(), other.color());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceLineStyleConfiguration").add("Pattern", (Object)this.patternAsString()).add("Color", (Object)this.color()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pattern": {
                return Optional.ofNullable(clazz.cast(this.patternAsString()));
            }
            case "Color": {
                return Optional.ofNullable(clazz.cast(this.color()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLineStyleConfiguration, T> g) {
        return obj -> g.apply((ReferenceLineStyleConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pattern;
        private String color;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLineStyleConfiguration model) {
            this.pattern(model.pattern);
            this.color(model.color);
        }

        public final String getPattern() {
            return this.pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        @Override
        public final Builder pattern(ReferenceLinePatternType pattern) {
            this.pattern(pattern == null ? null : pattern.toString());
            return this;
        }

        public final String getColor() {
            return this.color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public ReferenceLineStyleConfiguration build() {
            return new ReferenceLineStyleConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceLineStyleConfiguration> {
        public Builder pattern(String var1);

        public Builder pattern(ReferenceLinePatternType var1);

        public Builder color(String var1);
    }
}

