/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DashboardPublishOptions;
import software.amazon.awssdk.services.quicksight.model.DashboardSourceEntity;
import software.amazon.awssdk.services.quicksight.model.DashboardVersionDefinition;
import software.amazon.awssdk.services.quicksight.model.Parameters;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.ValidationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDashboardRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateDashboardRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::awsAccountId)).setter(UpdateDashboardRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::dashboardId)).setter(UpdateDashboardRequest.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::name)).setter(UpdateDashboardRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<DashboardSourceEntity> SOURCE_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceEntity").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::sourceEntity)).setter(UpdateDashboardRequest.setter(Builder::sourceEntity)).constructor(DashboardSourceEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()}).build();
    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Parameters").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::parameters)).setter(UpdateDashboardRequest.setter(Builder::parameters)).constructor(Parameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::versionDescription)).setter(UpdateDashboardRequest.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build()}).build();
    private static final SdkField<DashboardPublishOptions> DASHBOARD_PUBLISH_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashboardPublishOptions").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::dashboardPublishOptions)).setter(UpdateDashboardRequest.setter(Builder::dashboardPublishOptions)).constructor(DashboardPublishOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardPublishOptions").build()}).build();
    private static final SdkField<String> THEME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeArn").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::themeArn)).setter(UpdateDashboardRequest.setter(Builder::themeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()}).build();
    private static final SdkField<DashboardVersionDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::definition)).setter(UpdateDashboardRequest.setter(Builder::definition)).constructor(DashboardVersionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<ValidationStrategy> VALIDATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationStrategy").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::validationStrategy)).setter(UpdateDashboardRequest.setter(Builder::validationStrategy)).constructor(ValidationStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DASHBOARD_ID_FIELD, NAME_FIELD, SOURCE_ENTITY_FIELD, PARAMETERS_FIELD, VERSION_DESCRIPTION_FIELD, DASHBOARD_PUBLISH_OPTIONS_FIELD, THEME_ARN_FIELD, DEFINITION_FIELD, VALIDATION_STRATEGY_FIELD));
    private final String awsAccountId;
    private final String dashboardId;
    private final String name;
    private final DashboardSourceEntity sourceEntity;
    private final Parameters parameters;
    private final String versionDescription;
    private final DashboardPublishOptions dashboardPublishOptions;
    private final String themeArn;
    private final DashboardVersionDefinition definition;
    private final ValidationStrategy validationStrategy;

    private UpdateDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.name = builder.name;
        this.sourceEntity = builder.sourceEntity;
        this.parameters = builder.parameters;
        this.versionDescription = builder.versionDescription;
        this.dashboardPublishOptions = builder.dashboardPublishOptions;
        this.themeArn = builder.themeArn;
        this.definition = builder.definition;
        this.validationStrategy = builder.validationStrategy;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final String name() {
        return this.name;
    }

    public final DashboardSourceEntity sourceEntity() {
        return this.sourceEntity;
    }

    public final Parameters parameters() {
        return this.parameters;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final DashboardPublishOptions dashboardPublishOptions() {
        return this.dashboardPublishOptions;
    }

    public final String themeArn() {
        return this.themeArn;
    }

    public final DashboardVersionDefinition definition() {
        return this.definition;
    }

    public final ValidationStrategy validationStrategy() {
        return this.validationStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardPublishOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStrategy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardRequest)) {
            return false;
        }
        UpdateDashboardRequest other = (UpdateDashboardRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dashboardId(), other.dashboardId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceEntity(), other.sourceEntity()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.dashboardPublishOptions(), other.dashboardPublishOptions()) && Objects.equals(this.themeArn(), other.themeArn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.validationStrategy(), other.validationStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDashboardRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DashboardId", (Object)this.dashboardId()).add("Name", (Object)this.name()).add("SourceEntity", (Object)this.sourceEntity()).add("Parameters", (Object)this.parameters()).add("VersionDescription", (Object)this.versionDescription()).add("DashboardPublishOptions", (Object)this.dashboardPublishOptions()).add("ThemeArn", (Object)this.themeArn()).add("Definition", (Object)this.definition()).add("ValidationStrategy", (Object)this.validationStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SourceEntity": {
                return Optional.ofNullable(clazz.cast(this.sourceEntity()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "DashboardPublishOptions": {
                return Optional.ofNullable(clazz.cast(this.dashboardPublishOptions()));
            }
            case "ThemeArn": {
                return Optional.ofNullable(clazz.cast(this.themeArn()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "ValidationStrategy": {
                return Optional.ofNullable(clazz.cast(this.validationStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardRequest, T> g) {
        return obj -> g.apply((UpdateDashboardRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dashboardId;
        private String name;
        private DashboardSourceEntity sourceEntity;
        private Parameters parameters;
        private String versionDescription;
        private DashboardPublishOptions dashboardPublishOptions;
        private String themeArn;
        private DashboardVersionDefinition definition;
        private ValidationStrategy validationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dashboardId(model.dashboardId);
            this.name(model.name);
            this.sourceEntity(model.sourceEntity);
            this.parameters(model.parameters);
            this.versionDescription(model.versionDescription);
            this.dashboardPublishOptions(model.dashboardPublishOptions);
            this.themeArn(model.themeArn);
            this.definition(model.definition);
            this.validationStrategy(model.validationStrategy);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DashboardSourceEntity.Builder getSourceEntity() {
            return this.sourceEntity != null ? this.sourceEntity.toBuilder() : null;
        }

        public final void setSourceEntity(DashboardSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        @Override
        public final Builder sourceEntity(DashboardSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final Parameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final DashboardPublishOptions.Builder getDashboardPublishOptions() {
            return this.dashboardPublishOptions != null ? this.dashboardPublishOptions.toBuilder() : null;
        }

        public final void setDashboardPublishOptions(DashboardPublishOptions.BuilderImpl dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions != null ? dashboardPublishOptions.build() : null;
        }

        @Override
        public final Builder dashboardPublishOptions(DashboardPublishOptions dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions;
            return this;
        }

        public final String getThemeArn() {
            return this.themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final DashboardVersionDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(DashboardVersionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(DashboardVersionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final ValidationStrategy.Builder getValidationStrategy() {
            return this.validationStrategy != null ? this.validationStrategy.toBuilder() : null;
        }

        public final void setValidationStrategy(ValidationStrategy.BuilderImpl validationStrategy) {
            this.validationStrategy = validationStrategy != null ? validationStrategy.build() : null;
        }

        @Override
        public final Builder validationStrategy(ValidationStrategy validationStrategy) {
            this.validationStrategy = validationStrategy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDashboardRequest build() {
            return new UpdateDashboardRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDashboardRequest> {
        public Builder awsAccountId(String var1);

        public Builder dashboardId(String var1);

        public Builder name(String var1);

        public Builder sourceEntity(DashboardSourceEntity var1);

        default public Builder sourceEntity(Consumer<DashboardSourceEntity.Builder> sourceEntity) {
            return this.sourceEntity((DashboardSourceEntity)((DashboardSourceEntity.Builder)DashboardSourceEntity.builder().applyMutation(sourceEntity)).build());
        }

        public Builder parameters(Parameters var1);

        default public Builder parameters(Consumer<Parameters.Builder> parameters) {
            return this.parameters((Parameters)((Parameters.Builder)Parameters.builder().applyMutation(parameters)).build());
        }

        public Builder versionDescription(String var1);

        public Builder dashboardPublishOptions(DashboardPublishOptions var1);

        default public Builder dashboardPublishOptions(Consumer<DashboardPublishOptions.Builder> dashboardPublishOptions) {
            return this.dashboardPublishOptions((DashboardPublishOptions)((DashboardPublishOptions.Builder)DashboardPublishOptions.builder().applyMutation(dashboardPublishOptions)).build());
        }

        public Builder themeArn(String var1);

        public Builder definition(DashboardVersionDefinition var1);

        default public Builder definition(Consumer<DashboardVersionDefinition.Builder> definition) {
            return this.definition((DashboardVersionDefinition)((DashboardVersionDefinition.Builder)DashboardVersionDefinition.builder().applyMutation(definition)).build());
        }

        public Builder validationStrategy(ValidationStrategy var1);

        default public Builder validationStrategy(Consumer<ValidationStrategy.Builder> validationStrategy) {
            return this.validationStrategy((ValidationStrategy)((ValidationStrategy.Builder)ValidationStrategy.builder().applyMutation(validationStrategy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

