/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.IAMPolicyAssignmentSummary;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsResponse;

public class ListIAMPolicyAssignmentsPublisher
implements SdkPublisher<ListIamPolicyAssignmentsResponse> {
    private final QuickSightAsyncClient client;
    private final ListIamPolicyAssignmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIAMPolicyAssignmentsPublisher(QuickSightAsyncClient client, ListIamPolicyAssignmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIAMPolicyAssignmentsPublisher(QuickSightAsyncClient client, ListIamPolicyAssignmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIamPolicyAssignmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIamPolicyAssignmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IAMPolicyAssignmentSummary> iamPolicyAssignments() {
        Function<ListIamPolicyAssignmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.iamPolicyAssignments() != null) {
                return response.iamPolicyAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIamPolicyAssignmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIamPolicyAssignmentsResponseFetcher
    implements AsyncPageFetcher<ListIamPolicyAssignmentsResponse> {
        private ListIamPolicyAssignmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListIamPolicyAssignmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIamPolicyAssignmentsResponse> nextPage(ListIamPolicyAssignmentsResponse previousPage) {
            if (previousPage == null) {
                return ListIAMPolicyAssignmentsPublisher.this.client.listIAMPolicyAssignments(ListIAMPolicyAssignmentsPublisher.this.firstRequest);
            }
            return ListIAMPolicyAssignmentsPublisher.this.client.listIAMPolicyAssignments((ListIamPolicyAssignmentsRequest)((Object)ListIAMPolicyAssignmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

