/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.APIKeyConnectionMetadata;
import software.amazon.awssdk.services.quicksight.model.AuthorizationCodeGrantMetadata;
import software.amazon.awssdk.services.quicksight.model.BasicAuthConnectionMetadata;
import software.amazon.awssdk.services.quicksight.model.ClientCredentialsGrantMetadata;
import software.amazon.awssdk.services.quicksight.model.IAMConnectionMetadata;
import software.amazon.awssdk.services.quicksight.model.NoneConnectionMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationMetadata> {
    private static final SdkField<AuthorizationCodeGrantMetadata> AUTHORIZATION_CODE_GRANT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthorizationCodeGrantMetadata").getter(AuthenticationMetadata.getter(AuthenticationMetadata::authorizationCodeGrantMetadata)).setter(AuthenticationMetadata.setter(Builder::authorizationCodeGrantMetadata)).constructor(AuthorizationCodeGrantMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCodeGrantMetadata").build()}).build();
    private static final SdkField<ClientCredentialsGrantMetadata> CLIENT_CREDENTIALS_GRANT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientCredentialsGrantMetadata").getter(AuthenticationMetadata.getter(AuthenticationMetadata::clientCredentialsGrantMetadata)).setter(AuthenticationMetadata.setter(Builder::clientCredentialsGrantMetadata)).constructor(ClientCredentialsGrantMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsGrantMetadata").build()}).build();
    private static final SdkField<BasicAuthConnectionMetadata> BASIC_AUTH_CONNECTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BasicAuthConnectionMetadata").getter(AuthenticationMetadata.getter(AuthenticationMetadata::basicAuthConnectionMetadata)).setter(AuthenticationMetadata.setter(Builder::basicAuthConnectionMetadata)).constructor(BasicAuthConnectionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthConnectionMetadata").build()}).build();
    private static final SdkField<APIKeyConnectionMetadata> API_KEY_CONNECTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApiKeyConnectionMetadata").getter(AuthenticationMetadata.getter(AuthenticationMetadata::apiKeyConnectionMetadata)).setter(AuthenticationMetadata.setter(Builder::apiKeyConnectionMetadata)).constructor(APIKeyConnectionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyConnectionMetadata").build()}).build();
    private static final SdkField<NoneConnectionMetadata> NONE_CONNECTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NoneConnectionMetadata").getter(AuthenticationMetadata.getter(AuthenticationMetadata::noneConnectionMetadata)).setter(AuthenticationMetadata.setter(Builder::noneConnectionMetadata)).constructor(NoneConnectionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoneConnectionMetadata").build()}).build();
    private static final SdkField<IAMConnectionMetadata> IAM_CONNECTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamConnectionMetadata").getter(AuthenticationMetadata.getter(AuthenticationMetadata::iamConnectionMetadata)).setter(AuthenticationMetadata.setter(Builder::iamConnectionMetadata)).constructor(IAMConnectionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamConnectionMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_CODE_GRANT_METADATA_FIELD, CLIENT_CREDENTIALS_GRANT_METADATA_FIELD, BASIC_AUTH_CONNECTION_METADATA_FIELD, API_KEY_CONNECTION_METADATA_FIELD, NONE_CONNECTION_METADATA_FIELD, IAM_CONNECTION_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthenticationMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata;
    private final ClientCredentialsGrantMetadata clientCredentialsGrantMetadata;
    private final BasicAuthConnectionMetadata basicAuthConnectionMetadata;
    private final APIKeyConnectionMetadata apiKeyConnectionMetadata;
    private final NoneConnectionMetadata noneConnectionMetadata;
    private final IAMConnectionMetadata iamConnectionMetadata;
    private final Type type;

    private AuthenticationMetadata(BuilderImpl builder) {
        this.authorizationCodeGrantMetadata = builder.authorizationCodeGrantMetadata;
        this.clientCredentialsGrantMetadata = builder.clientCredentialsGrantMetadata;
        this.basicAuthConnectionMetadata = builder.basicAuthConnectionMetadata;
        this.apiKeyConnectionMetadata = builder.apiKeyConnectionMetadata;
        this.noneConnectionMetadata = builder.noneConnectionMetadata;
        this.iamConnectionMetadata = builder.iamConnectionMetadata;
        this.type = builder.type;
    }

    public final AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata() {
        return this.authorizationCodeGrantMetadata;
    }

    public final ClientCredentialsGrantMetadata clientCredentialsGrantMetadata() {
        return this.clientCredentialsGrantMetadata;
    }

    public final BasicAuthConnectionMetadata basicAuthConnectionMetadata() {
        return this.basicAuthConnectionMetadata;
    }

    public final APIKeyConnectionMetadata apiKeyConnectionMetadata() {
        return this.apiKeyConnectionMetadata;
    }

    public final NoneConnectionMetadata noneConnectionMetadata() {
        return this.noneConnectionMetadata;
    }

    public final IAMConnectionMetadata iamConnectionMetadata() {
        return this.iamConnectionMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationCodeGrantMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCredentialsGrantMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.noneConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamConnectionMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationMetadata)) {
            return false;
        }
        AuthenticationMetadata other = (AuthenticationMetadata)obj;
        return Objects.equals(this.authorizationCodeGrantMetadata(), other.authorizationCodeGrantMetadata()) && Objects.equals(this.clientCredentialsGrantMetadata(), other.clientCredentialsGrantMetadata()) && Objects.equals(this.basicAuthConnectionMetadata(), other.basicAuthConnectionMetadata()) && Objects.equals(this.apiKeyConnectionMetadata(), other.apiKeyConnectionMetadata()) && Objects.equals(this.noneConnectionMetadata(), other.noneConnectionMetadata()) && Objects.equals(this.iamConnectionMetadata(), other.iamConnectionMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationMetadata").add("AuthorizationCodeGrantMetadata", (Object)this.authorizationCodeGrantMetadata()).add("ClientCredentialsGrantMetadata", (Object)this.clientCredentialsGrantMetadata()).add("BasicAuthConnectionMetadata", (Object)this.basicAuthConnectionMetadata()).add("ApiKeyConnectionMetadata", (Object)this.apiKeyConnectionMetadata()).add("NoneConnectionMetadata", (Object)this.noneConnectionMetadata()).add("IamConnectionMetadata", (Object)this.iamConnectionMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizationCodeGrantMetadata": {
                return Optional.ofNullable(clazz.cast(this.authorizationCodeGrantMetadata()));
            }
            case "ClientCredentialsGrantMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientCredentialsGrantMetadata()));
            }
            case "BasicAuthConnectionMetadata": {
                return Optional.ofNullable(clazz.cast(this.basicAuthConnectionMetadata()));
            }
            case "ApiKeyConnectionMetadata": {
                return Optional.ofNullable(clazz.cast(this.apiKeyConnectionMetadata()));
            }
            case "NoneConnectionMetadata": {
                return Optional.ofNullable(clazz.cast(this.noneConnectionMetadata()));
            }
            case "IamConnectionMetadata": {
                return Optional.ofNullable(clazz.cast(this.iamConnectionMetadata()));
            }
        }
        return Optional.empty();
    }

    public static AuthenticationMetadata fromAuthorizationCodeGrantMetadata(AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata) {
        return (AuthenticationMetadata)AuthenticationMetadata.builder().authorizationCodeGrantMetadata(authorizationCodeGrantMetadata).build();
    }

    public static AuthenticationMetadata fromAuthorizationCodeGrantMetadata(Consumer<AuthorizationCodeGrantMetadata.Builder> authorizationCodeGrantMetadata) {
        AuthorizationCodeGrantMetadata.Builder builder = AuthorizationCodeGrantMetadata.builder();
        authorizationCodeGrantMetadata.accept(builder);
        return AuthenticationMetadata.fromAuthorizationCodeGrantMetadata((AuthorizationCodeGrantMetadata)builder.build());
    }

    public static AuthenticationMetadata fromClientCredentialsGrantMetadata(ClientCredentialsGrantMetadata clientCredentialsGrantMetadata) {
        return (AuthenticationMetadata)AuthenticationMetadata.builder().clientCredentialsGrantMetadata(clientCredentialsGrantMetadata).build();
    }

    public static AuthenticationMetadata fromClientCredentialsGrantMetadata(Consumer<ClientCredentialsGrantMetadata.Builder> clientCredentialsGrantMetadata) {
        ClientCredentialsGrantMetadata.Builder builder = ClientCredentialsGrantMetadata.builder();
        clientCredentialsGrantMetadata.accept(builder);
        return AuthenticationMetadata.fromClientCredentialsGrantMetadata((ClientCredentialsGrantMetadata)builder.build());
    }

    public static AuthenticationMetadata fromBasicAuthConnectionMetadata(BasicAuthConnectionMetadata basicAuthConnectionMetadata) {
        return (AuthenticationMetadata)AuthenticationMetadata.builder().basicAuthConnectionMetadata(basicAuthConnectionMetadata).build();
    }

    public static AuthenticationMetadata fromBasicAuthConnectionMetadata(Consumer<BasicAuthConnectionMetadata.Builder> basicAuthConnectionMetadata) {
        BasicAuthConnectionMetadata.Builder builder = BasicAuthConnectionMetadata.builder();
        basicAuthConnectionMetadata.accept(builder);
        return AuthenticationMetadata.fromBasicAuthConnectionMetadata((BasicAuthConnectionMetadata)builder.build());
    }

    public static AuthenticationMetadata fromApiKeyConnectionMetadata(APIKeyConnectionMetadata apiKeyConnectionMetadata) {
        return (AuthenticationMetadata)AuthenticationMetadata.builder().apiKeyConnectionMetadata(apiKeyConnectionMetadata).build();
    }

    public static AuthenticationMetadata fromApiKeyConnectionMetadata(Consumer<APIKeyConnectionMetadata.Builder> apiKeyConnectionMetadata) {
        APIKeyConnectionMetadata.Builder builder = APIKeyConnectionMetadata.builder();
        apiKeyConnectionMetadata.accept(builder);
        return AuthenticationMetadata.fromApiKeyConnectionMetadata((APIKeyConnectionMetadata)builder.build());
    }

    public static AuthenticationMetadata fromNoneConnectionMetadata(NoneConnectionMetadata noneConnectionMetadata) {
        return (AuthenticationMetadata)AuthenticationMetadata.builder().noneConnectionMetadata(noneConnectionMetadata).build();
    }

    public static AuthenticationMetadata fromNoneConnectionMetadata(Consumer<NoneConnectionMetadata.Builder> noneConnectionMetadata) {
        NoneConnectionMetadata.Builder builder = NoneConnectionMetadata.builder();
        noneConnectionMetadata.accept(builder);
        return AuthenticationMetadata.fromNoneConnectionMetadata((NoneConnectionMetadata)builder.build());
    }

    public static AuthenticationMetadata fromIamConnectionMetadata(IAMConnectionMetadata iamConnectionMetadata) {
        return (AuthenticationMetadata)AuthenticationMetadata.builder().iamConnectionMetadata(iamConnectionMetadata).build();
    }

    public static AuthenticationMetadata fromIamConnectionMetadata(Consumer<IAMConnectionMetadata.Builder> iamConnectionMetadata) {
        IAMConnectionMetadata.Builder builder = IAMConnectionMetadata.builder();
        iamConnectionMetadata.accept(builder);
        return AuthenticationMetadata.fromIamConnectionMetadata((IAMConnectionMetadata)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthorizationCodeGrantMetadata", AUTHORIZATION_CODE_GRANT_METADATA_FIELD);
        map.put("ClientCredentialsGrantMetadata", CLIENT_CREDENTIALS_GRANT_METADATA_FIELD);
        map.put("BasicAuthConnectionMetadata", BASIC_AUTH_CONNECTION_METADATA_FIELD);
        map.put("ApiKeyConnectionMetadata", API_KEY_CONNECTION_METADATA_FIELD);
        map.put("NoneConnectionMetadata", NONE_CONNECTION_METADATA_FIELD);
        map.put("IamConnectionMetadata", IAM_CONNECTION_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationMetadata, T> g) {
        return obj -> g.apply((AuthenticationMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AUTHORIZATION_CODE_GRANT_METADATA,
        CLIENT_CREDENTIALS_GRANT_METADATA,
        BASIC_AUTH_CONNECTION_METADATA,
        API_KEY_CONNECTION_METADATA,
        NONE_CONNECTION_METADATA,
        IAM_CONNECTION_METADATA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata;
        private ClientCredentialsGrantMetadata clientCredentialsGrantMetadata;
        private BasicAuthConnectionMetadata basicAuthConnectionMetadata;
        private APIKeyConnectionMetadata apiKeyConnectionMetadata;
        private NoneConnectionMetadata noneConnectionMetadata;
        private IAMConnectionMetadata iamConnectionMetadata;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationMetadata model) {
            this.authorizationCodeGrantMetadata(model.authorizationCodeGrantMetadata);
            this.clientCredentialsGrantMetadata(model.clientCredentialsGrantMetadata);
            this.basicAuthConnectionMetadata(model.basicAuthConnectionMetadata);
            this.apiKeyConnectionMetadata(model.apiKeyConnectionMetadata);
            this.noneConnectionMetadata(model.noneConnectionMetadata);
            this.iamConnectionMetadata(model.iamConnectionMetadata);
        }

        public final AuthorizationCodeGrantMetadata.Builder getAuthorizationCodeGrantMetadata() {
            return this.authorizationCodeGrantMetadata != null ? this.authorizationCodeGrantMetadata.toBuilder() : null;
        }

        public final void setAuthorizationCodeGrantMetadata(AuthorizationCodeGrantMetadata.BuilderImpl authorizationCodeGrantMetadata) {
            AuthorizationCodeGrantMetadata oldValue = this.authorizationCodeGrantMetadata;
            this.authorizationCodeGrantMetadata = authorizationCodeGrantMetadata != null ? authorizationCodeGrantMetadata.build() : null;
            this.handleUnionValueChange(Type.AUTHORIZATION_CODE_GRANT_METADATA, oldValue, this.authorizationCodeGrantMetadata);
        }

        @Override
        public final Builder authorizationCodeGrantMetadata(AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata) {
            AuthorizationCodeGrantMetadata oldValue = this.authorizationCodeGrantMetadata;
            this.authorizationCodeGrantMetadata = authorizationCodeGrantMetadata;
            this.handleUnionValueChange(Type.AUTHORIZATION_CODE_GRANT_METADATA, oldValue, this.authorizationCodeGrantMetadata);
            return this;
        }

        public final ClientCredentialsGrantMetadata.Builder getClientCredentialsGrantMetadata() {
            return this.clientCredentialsGrantMetadata != null ? this.clientCredentialsGrantMetadata.toBuilder() : null;
        }

        public final void setClientCredentialsGrantMetadata(ClientCredentialsGrantMetadata.BuilderImpl clientCredentialsGrantMetadata) {
            ClientCredentialsGrantMetadata oldValue = this.clientCredentialsGrantMetadata;
            this.clientCredentialsGrantMetadata = clientCredentialsGrantMetadata != null ? clientCredentialsGrantMetadata.build() : null;
            this.handleUnionValueChange(Type.CLIENT_CREDENTIALS_GRANT_METADATA, oldValue, this.clientCredentialsGrantMetadata);
        }

        @Override
        public final Builder clientCredentialsGrantMetadata(ClientCredentialsGrantMetadata clientCredentialsGrantMetadata) {
            ClientCredentialsGrantMetadata oldValue = this.clientCredentialsGrantMetadata;
            this.clientCredentialsGrantMetadata = clientCredentialsGrantMetadata;
            this.handleUnionValueChange(Type.CLIENT_CREDENTIALS_GRANT_METADATA, oldValue, this.clientCredentialsGrantMetadata);
            return this;
        }

        public final BasicAuthConnectionMetadata.Builder getBasicAuthConnectionMetadata() {
            return this.basicAuthConnectionMetadata != null ? this.basicAuthConnectionMetadata.toBuilder() : null;
        }

        public final void setBasicAuthConnectionMetadata(BasicAuthConnectionMetadata.BuilderImpl basicAuthConnectionMetadata) {
            BasicAuthConnectionMetadata oldValue = this.basicAuthConnectionMetadata;
            this.basicAuthConnectionMetadata = basicAuthConnectionMetadata != null ? basicAuthConnectionMetadata.build() : null;
            this.handleUnionValueChange(Type.BASIC_AUTH_CONNECTION_METADATA, oldValue, this.basicAuthConnectionMetadata);
        }

        @Override
        public final Builder basicAuthConnectionMetadata(BasicAuthConnectionMetadata basicAuthConnectionMetadata) {
            BasicAuthConnectionMetadata oldValue = this.basicAuthConnectionMetadata;
            this.basicAuthConnectionMetadata = basicAuthConnectionMetadata;
            this.handleUnionValueChange(Type.BASIC_AUTH_CONNECTION_METADATA, oldValue, this.basicAuthConnectionMetadata);
            return this;
        }

        public final APIKeyConnectionMetadata.Builder getApiKeyConnectionMetadata() {
            return this.apiKeyConnectionMetadata != null ? this.apiKeyConnectionMetadata.toBuilder() : null;
        }

        public final void setApiKeyConnectionMetadata(APIKeyConnectionMetadata.BuilderImpl apiKeyConnectionMetadata) {
            APIKeyConnectionMetadata oldValue = this.apiKeyConnectionMetadata;
            this.apiKeyConnectionMetadata = apiKeyConnectionMetadata != null ? apiKeyConnectionMetadata.build() : null;
            this.handleUnionValueChange(Type.API_KEY_CONNECTION_METADATA, oldValue, this.apiKeyConnectionMetadata);
        }

        @Override
        public final Builder apiKeyConnectionMetadata(APIKeyConnectionMetadata apiKeyConnectionMetadata) {
            APIKeyConnectionMetadata oldValue = this.apiKeyConnectionMetadata;
            this.apiKeyConnectionMetadata = apiKeyConnectionMetadata;
            this.handleUnionValueChange(Type.API_KEY_CONNECTION_METADATA, oldValue, this.apiKeyConnectionMetadata);
            return this;
        }

        public final NoneConnectionMetadata.Builder getNoneConnectionMetadata() {
            return this.noneConnectionMetadata != null ? this.noneConnectionMetadata.toBuilder() : null;
        }

        public final void setNoneConnectionMetadata(NoneConnectionMetadata.BuilderImpl noneConnectionMetadata) {
            NoneConnectionMetadata oldValue = this.noneConnectionMetadata;
            this.noneConnectionMetadata = noneConnectionMetadata != null ? noneConnectionMetadata.build() : null;
            this.handleUnionValueChange(Type.NONE_CONNECTION_METADATA, oldValue, this.noneConnectionMetadata);
        }

        @Override
        public final Builder noneConnectionMetadata(NoneConnectionMetadata noneConnectionMetadata) {
            NoneConnectionMetadata oldValue = this.noneConnectionMetadata;
            this.noneConnectionMetadata = noneConnectionMetadata;
            this.handleUnionValueChange(Type.NONE_CONNECTION_METADATA, oldValue, this.noneConnectionMetadata);
            return this;
        }

        public final IAMConnectionMetadata.Builder getIamConnectionMetadata() {
            return this.iamConnectionMetadata != null ? this.iamConnectionMetadata.toBuilder() : null;
        }

        public final void setIamConnectionMetadata(IAMConnectionMetadata.BuilderImpl iamConnectionMetadata) {
            IAMConnectionMetadata oldValue = this.iamConnectionMetadata;
            this.iamConnectionMetadata = iamConnectionMetadata != null ? iamConnectionMetadata.build() : null;
            this.handleUnionValueChange(Type.IAM_CONNECTION_METADATA, oldValue, this.iamConnectionMetadata);
        }

        @Override
        public final Builder iamConnectionMetadata(IAMConnectionMetadata iamConnectionMetadata) {
            IAMConnectionMetadata oldValue = this.iamConnectionMetadata;
            this.iamConnectionMetadata = iamConnectionMetadata;
            this.handleUnionValueChange(Type.IAM_CONNECTION_METADATA, oldValue, this.iamConnectionMetadata);
            return this;
        }

        public AuthenticationMetadata build() {
            return new AuthenticationMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationMetadata> {
        public Builder authorizationCodeGrantMetadata(AuthorizationCodeGrantMetadata var1);

        default public Builder authorizationCodeGrantMetadata(Consumer<AuthorizationCodeGrantMetadata.Builder> authorizationCodeGrantMetadata) {
            return this.authorizationCodeGrantMetadata((AuthorizationCodeGrantMetadata)((AuthorizationCodeGrantMetadata.Builder)AuthorizationCodeGrantMetadata.builder().applyMutation(authorizationCodeGrantMetadata)).build());
        }

        public Builder clientCredentialsGrantMetadata(ClientCredentialsGrantMetadata var1);

        default public Builder clientCredentialsGrantMetadata(Consumer<ClientCredentialsGrantMetadata.Builder> clientCredentialsGrantMetadata) {
            return this.clientCredentialsGrantMetadata((ClientCredentialsGrantMetadata)((ClientCredentialsGrantMetadata.Builder)ClientCredentialsGrantMetadata.builder().applyMutation(clientCredentialsGrantMetadata)).build());
        }

        public Builder basicAuthConnectionMetadata(BasicAuthConnectionMetadata var1);

        default public Builder basicAuthConnectionMetadata(Consumer<BasicAuthConnectionMetadata.Builder> basicAuthConnectionMetadata) {
            return this.basicAuthConnectionMetadata((BasicAuthConnectionMetadata)((BasicAuthConnectionMetadata.Builder)BasicAuthConnectionMetadata.builder().applyMutation(basicAuthConnectionMetadata)).build());
        }

        public Builder apiKeyConnectionMetadata(APIKeyConnectionMetadata var1);

        default public Builder apiKeyConnectionMetadata(Consumer<APIKeyConnectionMetadata.Builder> apiKeyConnectionMetadata) {
            return this.apiKeyConnectionMetadata((APIKeyConnectionMetadata)((APIKeyConnectionMetadata.Builder)APIKeyConnectionMetadata.builder().applyMutation(apiKeyConnectionMetadata)).build());
        }

        public Builder noneConnectionMetadata(NoneConnectionMetadata var1);

        default public Builder noneConnectionMetadata(Consumer<NoneConnectionMetadata.Builder> noneConnectionMetadata) {
            return this.noneConnectionMetadata((NoneConnectionMetadata)((NoneConnectionMetadata.Builder)NoneConnectionMetadata.builder().applyMutation(noneConnectionMetadata)).build());
        }

        public Builder iamConnectionMetadata(IAMConnectionMetadata var1);

        default public Builder iamConnectionMetadata(Consumer<IAMConnectionMetadata.Builder> iamConnectionMetadata) {
            return this.iamConnectionMetadata((IAMConnectionMetadata)((IAMConnectionMetadata.Builder)IAMConnectionMetadata.builder().applyMutation(iamConnectionMetadata)).build());
        }
    }
}

