/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.CastColumnTypeOperation;
import software.amazon.awssdk.services.quicksight.model.CastColumnTypeOperationListCopier;
import software.amazon.awssdk.services.quicksight.model.TransformOperationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CastColumnTypesOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CastColumnTypesOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(CastColumnTypesOperation.getter(CastColumnTypesOperation::alias)).setter(CastColumnTypesOperation.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<TransformOperationSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(CastColumnTypesOperation.getter(CastColumnTypesOperation::source)).setter(CastColumnTypesOperation.setter(Builder::source)).constructor(TransformOperationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<CastColumnTypeOperation>> CAST_COLUMN_TYPE_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CastColumnTypeOperations").getter(CastColumnTypesOperation.getter(CastColumnTypesOperation::castColumnTypeOperations)).setter(CastColumnTypesOperation.setter(Builder::castColumnTypeOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CastColumnTypeOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CastColumnTypeOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD, CAST_COLUMN_TYPE_OPERATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CastColumnTypesOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final TransformOperationSource source;
    private final List<CastColumnTypeOperation> castColumnTypeOperations;

    private CastColumnTypesOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
        this.castColumnTypeOperations = builder.castColumnTypeOperations;
    }

    public final String alias() {
        return this.alias;
    }

    public final TransformOperationSource source() {
        return this.source;
    }

    public final boolean hasCastColumnTypeOperations() {
        return this.castColumnTypeOperations != null && !(this.castColumnTypeOperations instanceof SdkAutoConstructList);
    }

    public final List<CastColumnTypeOperation> castColumnTypeOperations() {
        return this.castColumnTypeOperations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCastColumnTypeOperations() ? this.castColumnTypeOperations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CastColumnTypesOperation)) {
            return false;
        }
        CastColumnTypesOperation other = (CastColumnTypesOperation)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.source(), other.source()) && this.hasCastColumnTypeOperations() == other.hasCastColumnTypeOperations() && Objects.equals(this.castColumnTypeOperations(), other.castColumnTypeOperations());
    }

    public final String toString() {
        return ToString.builder((String)"CastColumnTypesOperation").add("Alias", (Object)this.alias()).add("Source", (Object)this.source()).add("CastColumnTypeOperations", this.hasCastColumnTypeOperations() ? this.castColumnTypeOperations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "CastColumnTypeOperations": {
                return Optional.ofNullable(clazz.cast(this.castColumnTypeOperations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("CastColumnTypeOperations", CAST_COLUMN_TYPE_OPERATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CastColumnTypesOperation, T> g) {
        return obj -> g.apply((CastColumnTypesOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private TransformOperationSource source;
        private List<CastColumnTypeOperation> castColumnTypeOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CastColumnTypesOperation model) {
            this.alias(model.alias);
            this.source(model.source);
            this.castColumnTypeOperations(model.castColumnTypeOperations);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TransformOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransformOperationSource source) {
            this.source = source;
            return this;
        }

        public final List<CastColumnTypeOperation.Builder> getCastColumnTypeOperations() {
            List<CastColumnTypeOperation.Builder> result = CastColumnTypeOperationListCopier.copyToBuilder(this.castColumnTypeOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCastColumnTypeOperations(Collection<CastColumnTypeOperation.BuilderImpl> castColumnTypeOperations) {
            this.castColumnTypeOperations = CastColumnTypeOperationListCopier.copyFromBuilder(castColumnTypeOperations);
        }

        @Override
        public final Builder castColumnTypeOperations(Collection<CastColumnTypeOperation> castColumnTypeOperations) {
            this.castColumnTypeOperations = CastColumnTypeOperationListCopier.copy(castColumnTypeOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder castColumnTypeOperations(CastColumnTypeOperation ... castColumnTypeOperations) {
            this.castColumnTypeOperations(Arrays.asList(castColumnTypeOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder castColumnTypeOperations(Consumer<CastColumnTypeOperation.Builder> ... castColumnTypeOperations) {
            this.castColumnTypeOperations(Stream.of(castColumnTypeOperations).map(c -> (CastColumnTypeOperation)((CastColumnTypeOperation.Builder)CastColumnTypeOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CastColumnTypesOperation build() {
            return new CastColumnTypesOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CastColumnTypesOperation> {
        public Builder alias(String var1);

        public Builder source(TransformOperationSource var1);

        default public Builder source(Consumer<TransformOperationSource.Builder> source) {
            return this.source((TransformOperationSource)((TransformOperationSource.Builder)TransformOperationSource.builder().applyMutation(source)).build());
        }

        public Builder castColumnTypeOperations(Collection<CastColumnTypeOperation> var1);

        public Builder castColumnTypeOperations(CastColumnTypeOperation ... var1);

        public Builder castColumnTypeOperations(Consumer<CastColumnTypeOperation.Builder> ... var1);
    }
}

