/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ClientCredentialsDetails;
import software.amazon.awssdk.services.quicksight.model.ClientCredentialsSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientCredentialsGrantMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientCredentialsGrantMetadata> {
    private static final SdkField<String> BASE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseEndpoint").getter(ClientCredentialsGrantMetadata.getter(ClientCredentialsGrantMetadata::baseEndpoint)).setter(ClientCredentialsGrantMetadata.setter(Builder::baseEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpoint").build()}).build();
    private static final SdkField<String> CLIENT_CREDENTIALS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCredentialsSource").getter(ClientCredentialsGrantMetadata.getter(ClientCredentialsGrantMetadata::clientCredentialsSourceAsString)).setter(ClientCredentialsGrantMetadata.setter(Builder::clientCredentialsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsSource").build()}).build();
    private static final SdkField<ClientCredentialsDetails> CLIENT_CREDENTIALS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientCredentialsDetails").getter(ClientCredentialsGrantMetadata.getter(ClientCredentialsGrantMetadata::clientCredentialsDetails)).setter(ClientCredentialsGrantMetadata.setter(Builder::clientCredentialsDetails)).constructor(ClientCredentialsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_ENDPOINT_FIELD, CLIENT_CREDENTIALS_SOURCE_FIELD, CLIENT_CREDENTIALS_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClientCredentialsGrantMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String baseEndpoint;
    private final String clientCredentialsSource;
    private final ClientCredentialsDetails clientCredentialsDetails;

    private ClientCredentialsGrantMetadata(BuilderImpl builder) {
        this.baseEndpoint = builder.baseEndpoint;
        this.clientCredentialsSource = builder.clientCredentialsSource;
        this.clientCredentialsDetails = builder.clientCredentialsDetails;
    }

    public final String baseEndpoint() {
        return this.baseEndpoint;
    }

    public final ClientCredentialsSource clientCredentialsSource() {
        return ClientCredentialsSource.fromValue(this.clientCredentialsSource);
    }

    public final String clientCredentialsSourceAsString() {
        return this.clientCredentialsSource;
    }

    public final ClientCredentialsDetails clientCredentialsDetails() {
        return this.clientCredentialsDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCredentialsSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCredentialsDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientCredentialsGrantMetadata)) {
            return false;
        }
        ClientCredentialsGrantMetadata other = (ClientCredentialsGrantMetadata)obj;
        return Objects.equals(this.baseEndpoint(), other.baseEndpoint()) && Objects.equals(this.clientCredentialsSourceAsString(), other.clientCredentialsSourceAsString()) && Objects.equals(this.clientCredentialsDetails(), other.clientCredentialsDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ClientCredentialsGrantMetadata").add("BaseEndpoint", (Object)this.baseEndpoint()).add("ClientCredentialsSource", (Object)this.clientCredentialsSourceAsString()).add("ClientCredentialsDetails", (Object)this.clientCredentialsDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseEndpoint": {
                return Optional.ofNullable(clazz.cast(this.baseEndpoint()));
            }
            case "ClientCredentialsSource": {
                return Optional.ofNullable(clazz.cast(this.clientCredentialsSourceAsString()));
            }
            case "ClientCredentialsDetails": {
                return Optional.ofNullable(clazz.cast(this.clientCredentialsDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BaseEndpoint", BASE_ENDPOINT_FIELD);
        map.put("ClientCredentialsSource", CLIENT_CREDENTIALS_SOURCE_FIELD);
        map.put("ClientCredentialsDetails", CLIENT_CREDENTIALS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientCredentialsGrantMetadata, T> g) {
        return obj -> g.apply((ClientCredentialsGrantMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseEndpoint;
        private String clientCredentialsSource;
        private ClientCredentialsDetails clientCredentialsDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientCredentialsGrantMetadata model) {
            this.baseEndpoint(model.baseEndpoint);
            this.clientCredentialsSource(model.clientCredentialsSource);
            this.clientCredentialsDetails(model.clientCredentialsDetails);
        }

        public final String getBaseEndpoint() {
            return this.baseEndpoint;
        }

        public final void setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        @Override
        public final Builder baseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public final String getClientCredentialsSource() {
            return this.clientCredentialsSource;
        }

        public final void setClientCredentialsSource(String clientCredentialsSource) {
            this.clientCredentialsSource = clientCredentialsSource;
        }

        @Override
        public final Builder clientCredentialsSource(String clientCredentialsSource) {
            this.clientCredentialsSource = clientCredentialsSource;
            return this;
        }

        @Override
        public final Builder clientCredentialsSource(ClientCredentialsSource clientCredentialsSource) {
            this.clientCredentialsSource(clientCredentialsSource == null ? null : clientCredentialsSource.toString());
            return this;
        }

        public final ClientCredentialsDetails.Builder getClientCredentialsDetails() {
            return this.clientCredentialsDetails != null ? this.clientCredentialsDetails.toBuilder() : null;
        }

        public final void setClientCredentialsDetails(ClientCredentialsDetails.BuilderImpl clientCredentialsDetails) {
            this.clientCredentialsDetails = clientCredentialsDetails != null ? clientCredentialsDetails.build() : null;
        }

        @Override
        public final Builder clientCredentialsDetails(ClientCredentialsDetails clientCredentialsDetails) {
            this.clientCredentialsDetails = clientCredentialsDetails;
            return this;
        }

        public ClientCredentialsGrantMetadata build() {
            return new ClientCredentialsGrantMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientCredentialsGrantMetadata> {
        public Builder baseEndpoint(String var1);

        public Builder clientCredentialsSource(String var1);

        public Builder clientCredentialsSource(ClientCredentialsSource var1);

        public Builder clientCredentialsDetails(ClientCredentialsDetails var1);

        default public Builder clientCredentialsDetails(Consumer<ClientCredentialsDetails.Builder> clientCredentialsDetails) {
            return this.clientCredentialsDetails((ClientCredentialsDetails)((ClientCredentialsDetails.Builder)ClientCredentialsDetails.builder().applyMutation(clientCredentialsDetails)).build());
        }
    }
}

