/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComparisonMethodType {
    DIFF("DIFF"),
    PERC_DIFF("PERC_DIFF"),
    DIFF_AS_PERC("DIFF_AS_PERC"),
    POP_CURRENT_DIFF_AS_PERC("POP_CURRENT_DIFF_AS_PERC"),
    POP_CURRENT_DIFF("POP_CURRENT_DIFF"),
    POP_OVERTIME_DIFF_AS_PERC("POP_OVERTIME_DIFF_AS_PERC"),
    POP_OVERTIME_DIFF("POP_OVERTIME_DIFF"),
    PERCENT_OF_TOTAL("PERCENT_OF_TOTAL"),
    RUNNING_SUM("RUNNING_SUM"),
    MOVING_AVERAGE("MOVING_AVERAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComparisonMethodType> VALUE_MAP;
    private final String value;

    private ComparisonMethodType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComparisonMethodType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComparisonMethodType> knownValues() {
        EnumSet<ComparisonMethodType> knownValues = EnumSet.allOf(ComparisonMethodType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComparisonMethodType.class, ComparisonMethodType::toString);
    }
}

