/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataSetNumericComparisonFilterOperator;
import software.amazon.awssdk.services.quicksight.model.DataSetNumericFilterValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSetNumericComparisonFilterCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSetNumericComparisonFilterCondition> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(DataSetNumericComparisonFilterCondition.getter(DataSetNumericComparisonFilterCondition::operatorAsString)).setter(DataSetNumericComparisonFilterCondition.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final SdkField<DataSetNumericFilterValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(DataSetNumericComparisonFilterCondition.getter(DataSetNumericComparisonFilterCondition::value)).setter(DataSetNumericComparisonFilterCondition.setter(Builder::value)).constructor(DataSetNumericFilterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSetNumericComparisonFilterCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operator;
    private final DataSetNumericFilterValue value;

    private DataSetNumericComparisonFilterCondition(BuilderImpl builder) {
        this.operator = builder.operator;
        this.value = builder.value;
    }

    public final DataSetNumericComparisonFilterOperator operator() {
        return DataSetNumericComparisonFilterOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final DataSetNumericFilterValue value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetNumericComparisonFilterCondition)) {
            return false;
        }
        DataSetNumericComparisonFilterCondition other = (DataSetNumericComparisonFilterCondition)obj;
        return Objects.equals(this.operatorAsString(), other.operatorAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"DataSetNumericComparisonFilterCondition").add("Operator", (Object)this.operatorAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Operator", OPERATOR_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetNumericComparisonFilterCondition, T> g) {
        return obj -> g.apply((DataSetNumericComparisonFilterCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operator;
        private DataSetNumericFilterValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetNumericComparisonFilterCondition model) {
            this.operator(model.operator);
            this.value(model.value);
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(DataSetNumericComparisonFilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final DataSetNumericFilterValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(DataSetNumericFilterValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DataSetNumericFilterValue value) {
            this.value = value;
            return this;
        }

        public DataSetNumericComparisonFilterCondition build() {
            return new DataSetNumericComparisonFilterCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSetNumericComparisonFilterCondition> {
        public Builder operator(String var1);

        public Builder operator(DataSetNumericComparisonFilterOperator var1);

        public Builder value(DataSetNumericFilterValue var1);

        default public Builder value(Consumer<DataSetNumericFilterValue.Builder> value) {
            return this.value((DataSetNumericFilterValue)((DataSetNumericFilterValue.Builder)DataSetNumericFilterValue.builder().applyMutation(value)).build());
        }
    }
}

