/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.NegativeFormat;
import software.amazon.awssdk.services.quicksight.model.NumberScale;
import software.amazon.awssdk.services.quicksight.model.TopicNumericSeparatorSymbol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisplayFormatOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DisplayFormatOptions> {
    private static final SdkField<Boolean> USE_BLANK_CELL_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseBlankCellFormat").getter(DisplayFormatOptions.getter(DisplayFormatOptions::useBlankCellFormat)).setter(DisplayFormatOptions.setter(Builder::useBlankCellFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseBlankCellFormat").build()}).build();
    private static final SdkField<String> BLANK_CELL_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlankCellFormat").getter(DisplayFormatOptions.getter(DisplayFormatOptions::blankCellFormat)).setter(DisplayFormatOptions.setter(Builder::blankCellFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlankCellFormat").build()}).build();
    private static final SdkField<String> DATE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DateFormat").getter(DisplayFormatOptions.getter(DisplayFormatOptions::dateFormat)).setter(DisplayFormatOptions.setter(Builder::dateFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFormat").build()}).build();
    private static final SdkField<String> DECIMAL_SEPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DecimalSeparator").getter(DisplayFormatOptions.getter(DisplayFormatOptions::decimalSeparatorAsString)).setter(DisplayFormatOptions.setter(Builder::decimalSeparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalSeparator").build()}).build();
    private static final SdkField<String> GROUPING_SEPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupingSeparator").getter(DisplayFormatOptions.getter(DisplayFormatOptions::groupingSeparator)).setter(DisplayFormatOptions.setter(Builder::groupingSeparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingSeparator").build()}).build();
    private static final SdkField<Boolean> USE_GROUPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseGrouping").getter(DisplayFormatOptions.getter(DisplayFormatOptions::useGrouping)).setter(DisplayFormatOptions.setter(Builder::useGrouping)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseGrouping").build()}).build();
    private static final SdkField<Integer> FRACTION_DIGITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FractionDigits").getter(DisplayFormatOptions.getter(DisplayFormatOptions::fractionDigits)).setter(DisplayFormatOptions.setter(Builder::fractionDigits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FractionDigits").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(DisplayFormatOptions.getter(DisplayFormatOptions::prefix)).setter(DisplayFormatOptions.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<String> SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Suffix").getter(DisplayFormatOptions.getter(DisplayFormatOptions::suffix)).setter(DisplayFormatOptions.setter(Builder::suffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suffix").build()}).build();
    private static final SdkField<String> UNIT_SCALER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnitScaler").getter(DisplayFormatOptions.getter(DisplayFormatOptions::unitScalerAsString)).setter(DisplayFormatOptions.setter(Builder::unitScaler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnitScaler").build()}).build();
    private static final SdkField<NegativeFormat> NEGATIVE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NegativeFormat").getter(DisplayFormatOptions.getter(DisplayFormatOptions::negativeFormat)).setter(DisplayFormatOptions.setter(Builder::negativeFormat)).constructor(NegativeFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NegativeFormat").build()}).build();
    private static final SdkField<String> CURRENCY_SYMBOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencySymbol").getter(DisplayFormatOptions.getter(DisplayFormatOptions::currencySymbol)).setter(DisplayFormatOptions.setter(Builder::currencySymbol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencySymbol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_BLANK_CELL_FORMAT_FIELD, BLANK_CELL_FORMAT_FIELD, DATE_FORMAT_FIELD, DECIMAL_SEPARATOR_FIELD, GROUPING_SEPARATOR_FIELD, USE_GROUPING_FIELD, FRACTION_DIGITS_FIELD, PREFIX_FIELD, SUFFIX_FIELD, UNIT_SCALER_FIELD, NEGATIVE_FORMAT_FIELD, CURRENCY_SYMBOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisplayFormatOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean useBlankCellFormat;
    private final String blankCellFormat;
    private final String dateFormat;
    private final String decimalSeparator;
    private final String groupingSeparator;
    private final Boolean useGrouping;
    private final Integer fractionDigits;
    private final String prefix;
    private final String suffix;
    private final String unitScaler;
    private final NegativeFormat negativeFormat;
    private final String currencySymbol;

    private DisplayFormatOptions(BuilderImpl builder) {
        this.useBlankCellFormat = builder.useBlankCellFormat;
        this.blankCellFormat = builder.blankCellFormat;
        this.dateFormat = builder.dateFormat;
        this.decimalSeparator = builder.decimalSeparator;
        this.groupingSeparator = builder.groupingSeparator;
        this.useGrouping = builder.useGrouping;
        this.fractionDigits = builder.fractionDigits;
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.unitScaler = builder.unitScaler;
        this.negativeFormat = builder.negativeFormat;
        this.currencySymbol = builder.currencySymbol;
    }

    public final Boolean useBlankCellFormat() {
        return this.useBlankCellFormat;
    }

    public final String blankCellFormat() {
        return this.blankCellFormat;
    }

    public final String dateFormat() {
        return this.dateFormat;
    }

    public final TopicNumericSeparatorSymbol decimalSeparator() {
        return TopicNumericSeparatorSymbol.fromValue(this.decimalSeparator);
    }

    public final String decimalSeparatorAsString() {
        return this.decimalSeparator;
    }

    public final String groupingSeparator() {
        return this.groupingSeparator;
    }

    public final Boolean useGrouping() {
        return this.useGrouping;
    }

    public final Integer fractionDigits() {
        return this.fractionDigits;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String suffix() {
        return this.suffix;
    }

    public final NumberScale unitScaler() {
        return NumberScale.fromValue(this.unitScaler);
    }

    public final String unitScalerAsString() {
        return this.unitScaler;
    }

    public final NegativeFormat negativeFormat() {
        return this.negativeFormat;
    }

    public final String currencySymbol() {
        return this.currencySymbol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.useBlankCellFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.blankCellFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.decimalSeparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingSeparator());
        hashCode = 31 * hashCode + Objects.hashCode(this.useGrouping());
        hashCode = 31 * hashCode + Objects.hashCode(this.fractionDigits());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.suffix());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitScalerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.negativeFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencySymbol());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisplayFormatOptions)) {
            return false;
        }
        DisplayFormatOptions other = (DisplayFormatOptions)obj;
        return Objects.equals(this.useBlankCellFormat(), other.useBlankCellFormat()) && Objects.equals(this.blankCellFormat(), other.blankCellFormat()) && Objects.equals(this.dateFormat(), other.dateFormat()) && Objects.equals(this.decimalSeparatorAsString(), other.decimalSeparatorAsString()) && Objects.equals(this.groupingSeparator(), other.groupingSeparator()) && Objects.equals(this.useGrouping(), other.useGrouping()) && Objects.equals(this.fractionDigits(), other.fractionDigits()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.suffix(), other.suffix()) && Objects.equals(this.unitScalerAsString(), other.unitScalerAsString()) && Objects.equals(this.negativeFormat(), other.negativeFormat()) && Objects.equals(this.currencySymbol(), other.currencySymbol());
    }

    public final String toString() {
        return ToString.builder((String)"DisplayFormatOptions").add("UseBlankCellFormat", (Object)this.useBlankCellFormat()).add("BlankCellFormat", (Object)this.blankCellFormat()).add("DateFormat", (Object)this.dateFormat()).add("DecimalSeparator", (Object)this.decimalSeparatorAsString()).add("GroupingSeparator", (Object)this.groupingSeparator()).add("UseGrouping", (Object)this.useGrouping()).add("FractionDigits", (Object)this.fractionDigits()).add("Prefix", (Object)this.prefix()).add("Suffix", (Object)this.suffix()).add("UnitScaler", (Object)this.unitScalerAsString()).add("NegativeFormat", (Object)this.negativeFormat()).add("CurrencySymbol", (Object)this.currencySymbol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UseBlankCellFormat": {
                return Optional.ofNullable(clazz.cast(this.useBlankCellFormat()));
            }
            case "BlankCellFormat": {
                return Optional.ofNullable(clazz.cast(this.blankCellFormat()));
            }
            case "DateFormat": {
                return Optional.ofNullable(clazz.cast(this.dateFormat()));
            }
            case "DecimalSeparator": {
                return Optional.ofNullable(clazz.cast(this.decimalSeparatorAsString()));
            }
            case "GroupingSeparator": {
                return Optional.ofNullable(clazz.cast(this.groupingSeparator()));
            }
            case "UseGrouping": {
                return Optional.ofNullable(clazz.cast(this.useGrouping()));
            }
            case "FractionDigits": {
                return Optional.ofNullable(clazz.cast(this.fractionDigits()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "Suffix": {
                return Optional.ofNullable(clazz.cast(this.suffix()));
            }
            case "UnitScaler": {
                return Optional.ofNullable(clazz.cast(this.unitScalerAsString()));
            }
            case "NegativeFormat": {
                return Optional.ofNullable(clazz.cast(this.negativeFormat()));
            }
            case "CurrencySymbol": {
                return Optional.ofNullable(clazz.cast(this.currencySymbol()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UseBlankCellFormat", USE_BLANK_CELL_FORMAT_FIELD);
        map.put("BlankCellFormat", BLANK_CELL_FORMAT_FIELD);
        map.put("DateFormat", DATE_FORMAT_FIELD);
        map.put("DecimalSeparator", DECIMAL_SEPARATOR_FIELD);
        map.put("GroupingSeparator", GROUPING_SEPARATOR_FIELD);
        map.put("UseGrouping", USE_GROUPING_FIELD);
        map.put("FractionDigits", FRACTION_DIGITS_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("Suffix", SUFFIX_FIELD);
        map.put("UnitScaler", UNIT_SCALER_FIELD);
        map.put("NegativeFormat", NEGATIVE_FORMAT_FIELD);
        map.put("CurrencySymbol", CURRENCY_SYMBOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisplayFormatOptions, T> g) {
        return obj -> g.apply((DisplayFormatOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean useBlankCellFormat;
        private String blankCellFormat;
        private String dateFormat;
        private String decimalSeparator;
        private String groupingSeparator;
        private Boolean useGrouping;
        private Integer fractionDigits;
        private String prefix;
        private String suffix;
        private String unitScaler;
        private NegativeFormat negativeFormat;
        private String currencySymbol;

        private BuilderImpl() {
        }

        private BuilderImpl(DisplayFormatOptions model) {
            this.useBlankCellFormat(model.useBlankCellFormat);
            this.blankCellFormat(model.blankCellFormat);
            this.dateFormat(model.dateFormat);
            this.decimalSeparator(model.decimalSeparator);
            this.groupingSeparator(model.groupingSeparator);
            this.useGrouping(model.useGrouping);
            this.fractionDigits(model.fractionDigits);
            this.prefix(model.prefix);
            this.suffix(model.suffix);
            this.unitScaler(model.unitScaler);
            this.negativeFormat(model.negativeFormat);
            this.currencySymbol(model.currencySymbol);
        }

        public final Boolean getUseBlankCellFormat() {
            return this.useBlankCellFormat;
        }

        public final void setUseBlankCellFormat(Boolean useBlankCellFormat) {
            this.useBlankCellFormat = useBlankCellFormat;
        }

        @Override
        public final Builder useBlankCellFormat(Boolean useBlankCellFormat) {
            this.useBlankCellFormat = useBlankCellFormat;
            return this;
        }

        public final String getBlankCellFormat() {
            return this.blankCellFormat;
        }

        public final void setBlankCellFormat(String blankCellFormat) {
            this.blankCellFormat = blankCellFormat;
        }

        @Override
        public final Builder blankCellFormat(String blankCellFormat) {
            this.blankCellFormat = blankCellFormat;
            return this;
        }

        public final String getDateFormat() {
            return this.dateFormat;
        }

        public final void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public final Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public final String getDecimalSeparator() {
            return this.decimalSeparator;
        }

        public final void setDecimalSeparator(String decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
        }

        @Override
        public final Builder decimalSeparator(String decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
            return this;
        }

        @Override
        public final Builder decimalSeparator(TopicNumericSeparatorSymbol decimalSeparator) {
            this.decimalSeparator(decimalSeparator == null ? null : decimalSeparator.toString());
            return this;
        }

        public final String getGroupingSeparator() {
            return this.groupingSeparator;
        }

        public final void setGroupingSeparator(String groupingSeparator) {
            this.groupingSeparator = groupingSeparator;
        }

        @Override
        public final Builder groupingSeparator(String groupingSeparator) {
            this.groupingSeparator = groupingSeparator;
            return this;
        }

        public final Boolean getUseGrouping() {
            return this.useGrouping;
        }

        public final void setUseGrouping(Boolean useGrouping) {
            this.useGrouping = useGrouping;
        }

        @Override
        public final Builder useGrouping(Boolean useGrouping) {
            this.useGrouping = useGrouping;
            return this;
        }

        public final Integer getFractionDigits() {
            return this.fractionDigits;
        }

        public final void setFractionDigits(Integer fractionDigits) {
            this.fractionDigits = fractionDigits;
        }

        @Override
        public final Builder fractionDigits(Integer fractionDigits) {
            this.fractionDigits = fractionDigits;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getSuffix() {
            return this.suffix;
        }

        public final void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public final Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public final String getUnitScaler() {
            return this.unitScaler;
        }

        public final void setUnitScaler(String unitScaler) {
            this.unitScaler = unitScaler;
        }

        @Override
        public final Builder unitScaler(String unitScaler) {
            this.unitScaler = unitScaler;
            return this;
        }

        @Override
        public final Builder unitScaler(NumberScale unitScaler) {
            this.unitScaler(unitScaler == null ? null : unitScaler.toString());
            return this;
        }

        public final NegativeFormat.Builder getNegativeFormat() {
            return this.negativeFormat != null ? this.negativeFormat.toBuilder() : null;
        }

        public final void setNegativeFormat(NegativeFormat.BuilderImpl negativeFormat) {
            this.negativeFormat = negativeFormat != null ? negativeFormat.build() : null;
        }

        @Override
        public final Builder negativeFormat(NegativeFormat negativeFormat) {
            this.negativeFormat = negativeFormat;
            return this;
        }

        public final String getCurrencySymbol() {
            return this.currencySymbol;
        }

        public final void setCurrencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
        }

        @Override
        public final Builder currencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
            return this;
        }

        public DisplayFormatOptions build() {
            return new DisplayFormatOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DisplayFormatOptions> {
        public Builder useBlankCellFormat(Boolean var1);

        public Builder blankCellFormat(String var1);

        public Builder dateFormat(String var1);

        public Builder decimalSeparator(String var1);

        public Builder decimalSeparator(TopicNumericSeparatorSymbol var1);

        public Builder groupingSeparator(String var1);

        public Builder useGrouping(Boolean var1);

        public Builder fractionDigits(Integer var1);

        public Builder prefix(String var1);

        public Builder suffix(String var1);

        public Builder unitScaler(String var1);

        public Builder unitScaler(NumberScale var1);

        public Builder negativeFormat(NegativeFormat var1);

        default public Builder negativeFormat(Consumer<NegativeFormat.Builder> negativeFormat) {
            return this.negativeFormat((NegativeFormat)((NegativeFormat.Builder)NegativeFormat.builder().applyMutation(negativeFormat)).build());
        }

        public Builder currencySymbol(String var1);
    }
}

